/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import java.beans.PropertyDescriptor;
import java.util.Locale;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.apache.commons.jxpath.ri.pointers.PropertyAccessHelper;
import org.apache.commons.jxpath.ri.pointers.PropertyOwnerPointer;

public class BeanPointer
extends PropertyOwnerPointer {
    private QName name;
    private Object bean;
    private JXPathBeanInfo beanInfo;
    private PropertyDescriptor[] propertyDescriptors;
    private String[] names;

    public BeanPointer(QName name, Object bean, JXPathBeanInfo beanInfo, Locale locale) {
        super(null, locale);
        this.name = name;
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    public BeanPointer(NodePointer parent, QName name, Object bean, JXPathBeanInfo beanInfo) {
        super(parent);
        this.name = name;
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    public QName getName() {
        return this.name;
    }

    public Object getBaseValue() {
        return this.bean;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Cannot setValue of an object that is not some other object's property");
    }

    public int getLength() {
        return PropertyAccessHelper.getLength(this.getBaseValue());
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BeanPointer)) {
            return false;
        }
        BeanPointer other = (BeanPointer)object;
        if (this.name == null && other.name != null || this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        if (this.bean instanceof Number || this.bean instanceof String || this.bean instanceof Boolean) {
            return this.bean.equals(other.bean);
        }
        return this.bean == other.bean;
    }

    public String asPath() {
        if (this.parent != null) {
            return super.asPath();
        }
        if (this.bean == null) {
            return "null()";
        }
        if (this.bean instanceof Number) {
            String string = this.bean.toString();
            if (string.endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }
        if (this.bean instanceof Boolean) {
            return (Boolean)this.bean != false ? "true()" : "false()";
        }
        if (this.bean instanceof String) {
            return "'" + this.bean + "'";
        }
        return "";
    }
}

