/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import java.beans.PropertyDescriptor;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.apache.commons.jxpath.ri.pointers.PropertyAccessHelper;
import org.apache.commons.jxpath.ri.pointers.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.pointers.PropertyPointer;

public class BeanPropertyPointer
extends PropertyPointer {
    private JXPathBeanInfo beanInfo;
    private PropertyDescriptor[] propertyDescriptors;
    private PropertyDescriptor propertyDescriptor;
    private String[] names;

    public BeanPropertyPointer(NodePointer parent, JXPathBeanInfo beanInfo) {
        super(parent);
        this.beanInfo = beanInfo;
    }

    public int getPropertyCount() {
        return this.getPropertyDescriptors().length;
    }

    public String[] getPropertyNames() {
        if (this.names == null) {
            PropertyDescriptor[] pds = this.getPropertyDescriptors();
            this.names = new String[pds.length];
            int i = 0;
            while (i < this.names.length) {
                this.names[i] = pds[i].getName();
                ++i;
            }
        }
        return this.names;
    }

    public void setPropertyName(String propertyName) {
        this.setPropertyIndex(PropertyOwnerPointer.UNSPECIFIED_PROPERTY);
        String[] names = this.getPropertyNames();
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(propertyName)) {
                this.propertyIndex = i;
                break;
            }
            ++i;
        }
    }

    public void setPropertyIndex(int index) {
        if (this.propertyIndex != index) {
            super.setPropertyIndex(index);
            this.propertyDescriptor = null;
        }
    }

    public int getLength() {
        PropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd == null) {
            return 0;
        }
        return PropertyAccessHelper.getLength(this.getBean(), pd);
    }

    public Object getBaseValue() {
        PropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd == null) {
            return null;
        }
        return PropertyAccessHelper.getValue(this.getBean(), pd);
    }

    public Object getValue() {
        PropertyDescriptor pd = this.getPropertyDescriptor();
        Object value = pd == null ? null : (this.index == NodePointer.WHOLE_COLLECTION ? PropertyAccessHelper.getValue(this.getBean(), this.getPropertyDescriptor()) : PropertyAccessHelper.getValue(this.getBean(), this.getPropertyDescriptor(), this.index));
        return value;
    }

    public void setValue(Object value) {
        if (this.index == NodePointer.WHOLE_COLLECTION) {
            PropertyAccessHelper.setValue(this.getBean(), this.getPropertyDescriptor(), value);
        } else {
            PropertyAccessHelper.setValue(this.getBean(), this.getPropertyDescriptor(), this.index, value);
        }
    }

    public String getPropertyName() {
        PropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd == null) {
            return "*";
        }
        return pd.getName();
    }

    private PropertyDescriptor getPropertyDescriptor() {
        if (this.propertyDescriptor == null) {
            int inx = this.getPropertyIndex();
            PropertyDescriptor[] propertyDescriptors = this.getPropertyDescriptors();
            this.propertyDescriptor = inx >= 0 && inx < propertyDescriptors.length ? propertyDescriptors[inx] : null;
        }
        return this.propertyDescriptor;
    }

    protected PropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = this.beanInfo.getPropertyDescriptors();
        }
        return this.propertyDescriptors;
    }
}

