/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import java.util.Locale;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.pointers.NodeIterator;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.apache.commons.jxpath.ri.pointers.PropertyAccessHelper;

public class ContainerPointer
extends NodePointer {
    private Container container;
    private NodePointer valuePointer;

    public ContainerPointer(Container container, Locale locale) {
        super(null, locale);
        this.container = container;
    }

    public ContainerPointer(NodePointer parent, Container container) {
        super(parent);
        this.container = container;
    }

    public QName getName() {
        return null;
    }

    public Object getBaseValue() {
        return this.container.getValue();
    }

    public Object getValue() {
        Object value = this.getBaseValue();
        if (this.index != NodePointer.WHOLE_COLLECTION) {
            return PropertyAccessHelper.getValue(value, this.index);
        }
        return value;
    }

    public void setValue(Object value) {
        this.container.setValue(value);
    }

    private NodePointer getValuePointer() {
        if (this.valuePointer == null) {
            Object value = this.getValue();
            this.valuePointer = NodePointer.createNodePointer(this, null, value);
        }
        return this.valuePointer;
    }

    public int hashCode() {
        return System.identityHashCode(this.container) + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ContainerPointer)) {
            return false;
        }
        ContainerPointer other = (ContainerPointer)object;
        return this.container == other.container && this.index == other.index;
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse) {
        return this.getValuePointer().childIterator(test, reverse);
    }

    public NodeIterator siblingIterator(NodeTest test, boolean reverse) {
        return this.getValuePointer().siblingIterator(test, reverse);
    }

    public NodeIterator attributeIterator(QName name) {
        return this.getValuePointer().attributeIterator(name);
    }

    public NodeIterator namespaceIterator() {
        return this.getValuePointer().namespaceIterator();
    }

    public NodePointer namespacePointer(String namespace) {
        return this.getValuePointer().namespacePointer(namespace);
    }

    public boolean testNode(NodeTest nodeTest) {
        return this.getValuePointer().testNode(nodeTest);
    }
}

