/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.pointers.DOMNodePointer;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.w3c.dom.Attr;

public class DOMAttributePointer
extends NodePointer {
    private Attr attr;

    public DOMAttributePointer(NodePointer parent, Attr attr) {
        super(parent);
        this.attr = attr;
    }

    public QName getName() {
        return new QName(DOMNodePointer.getPrefix(this.attr), DOMNodePointer.getLocalName(this.attr));
    }

    public QName getExpandedName() {
        return new QName(this.getNamespaceURI(), DOMNodePointer.getLocalName(this.attr));
    }

    public String getNamespaceURI() {
        String prefix = DOMNodePointer.getPrefix(this.attr);
        if (prefix == null) {
            return null;
        }
        return this.parent.getNamespaceURI(prefix);
    }

    public Object getBaseValue() {
        return this.attr;
    }

    public Object getValue() {
        String value = this.attr.getValue();
        if (value == null) {
            return null;
        }
        if (value.equals("") && !this.attr.getSpecified()) {
            return null;
        }
        return value;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean testNode(NodeTest nodeTest) {
        return nodeTest == null || nodeTest instanceof NodeTypeTest && ((NodeTypeTest)nodeTest).getNodeType() == 1;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Cannot modify DOM trees");
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
            buffer.append('/');
        }
        buffer.append('@');
        buffer.append(this.getName());
        return buffer.toString();
    }

    public int hashCode() {
        return System.identityHashCode(this.attr);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DOMAttributePointer)) {
            return false;
        }
        DOMAttributePointer other = (DOMAttributePointer)object;
        return this.attr == other.attr;
    }
}

