/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.pointers.DOMNodePointer;
import org.apache.commons.jxpath.ri.pointers.NodeIterator;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.w3c.dom.Node;

public class DOMNodeIterator
implements NodeIterator {
    private NodePointer parent;
    private NodeTest nodeTest;
    private String namespaceURI;
    private Node node;
    private Node child = null;
    private boolean children;
    private boolean reverse;
    private int position = 0;

    public DOMNodeIterator(NodePointer parent, boolean children, NodeTest nodeTest, boolean reverse) {
        this.parent = parent;
        this.children = children;
        this.node = (Node)parent.getValue();
        this.nodeTest = nodeTest;
        this.reverse = reverse;
    }

    public NodePointer getNodePointer() {
        if (this.child == null) {
            if (!this.setPosition(1)) {
                return null;
            }
            this.position = 0;
        }
        if (this.children) {
            return new DOMNodePointer(this.parent, this.child);
        }
        return new DOMNodePointer(this.parent.getParent(), this.child);
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        while (this.position < position) {
            if (this.next()) continue;
            return false;
        }
        while (this.position > position) {
            if (this.previous()) continue;
            return false;
        }
        return true;
    }

    private boolean previous() {
        --this.position;
        if (!this.reverse) {
            this.child = this.child.getPreviousSibling();
            while (this.child != null && !this.testChild()) {
                this.child = this.child.getPreviousSibling();
            }
        } else {
            this.child = this.child.getNextSibling();
            while (this.child != null && !this.testChild()) {
                this.child = this.child.getNextSibling();
            }
        }
        return this.child != null;
    }

    private boolean next() {
        ++this.position;
        if (!this.reverse) {
            this.child = this.position == 1 ? (this.children ? this.node.getFirstChild() : this.node.getNextSibling()) : this.child.getNextSibling();
            while (this.child != null && !this.testChild()) {
                this.child = this.child.getNextSibling();
            }
        } else {
            this.child = this.position == 1 ? (this.children ? this.node.getLastChild() : this.node.getPreviousSibling()) : this.child.getPreviousSibling();
            while (this.child != null && !this.testChild()) {
                this.child = this.child.getPreviousSibling();
            }
        }
        return this.child != null;
    }

    private boolean testChild() {
        return DOMNodePointer.testNode(this.parent, this.child, this.nodeTest);
    }
}

