/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.ProcessingInstructionTest;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.pointers.DOMAttributeIterator;
import org.apache.commons.jxpath.ri.pointers.DOMNamespaceIterator;
import org.apache.commons.jxpath.ri.pointers.DOMNodeIterator;
import org.apache.commons.jxpath.ri.pointers.NamespacePointer;
import org.apache.commons.jxpath.ri.pointers.NodeIterator;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class DOMNodePointer
extends NodePointer {
    private Node node;
    private Map namespaces;
    private String defaultNamespace;
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";

    public DOMNodePointer(Node node, Locale locale) {
        super(null, locale);
        this.node = node;
    }

    public DOMNodePointer(NodePointer parent, Node node) {
        super(parent);
        this.node = node;
    }

    public boolean testNode(NodeTest test) {
        return DOMNodePointer.testNode(this, this.node, test);
    }

    public static boolean testNode(NodePointer pointer, Node node, NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            if (node.getNodeType() != 1) {
                return false;
            }
            QName testName = ((NodeNameTest)test).getNodeName();
            String testLocalName = testName.getName();
            if (testLocalName.equals("*") || testLocalName.equals(DOMNodePointer.getLocalName(node))) {
                String nodePrefix;
                String testPrefix = testName.getPrefix();
                if (DOMNodePointer.equalStrings(testPrefix, nodePrefix = DOMNodePointer.getPrefix(node))) {
                    return true;
                }
                String testNS = pointer.getNamespaceURI(testPrefix);
                String nodeNS = pointer.getNamespaceURI(nodePrefix);
                return DOMNodePointer.equalStrings(testNS, nodeNS);
            }
        } else {
            if (test instanceof NodeTypeTest) {
                short nodeType = node.getNodeType();
                switch (((NodeTypeTest)test).getNodeType()) {
                    case 1: {
                        return nodeType == 1;
                    }
                    case 2: {
                        return nodeType == 4 || nodeType == 3;
                    }
                    case 3: {
                        return nodeType == 8;
                    }
                    case 4: {
                        return nodeType == 7;
                    }
                }
                return false;
            }
            if (test instanceof ProcessingInstructionTest && node.getNodeType() == 7) {
                String testPI = ((ProcessingInstructionTest)test).getTarget();
                String nodePI = ((ProcessingInstruction)node).getTarget();
                return testPI.equals(nodePI);
            }
        }
        return false;
    }

    private static boolean equalStrings(String s1, String s2) {
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1 == null || s1.equals(s2);
    }

    public QName getName() {
        short type = this.node.getNodeType();
        if (type == 1) {
            return new QName(DOMNodePointer.getPrefix(this.node), DOMNodePointer.getLocalName(this.node));
        }
        if (type == 7) {
            return new QName(null, ((ProcessingInstruction)this.node).getTarget());
        }
        return null;
    }

    public String getNamespaceURI() {
        if (this.node.getNodeType() == 1) {
            return this.getNamespaceURI(this.getName().getPrefix());
        }
        return null;
    }

    public QName getExpandedName() {
        return new QName(this.getNamespaceURI(), this.getName().getName());
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse) {
        return new DOMNodeIterator(this, true, test, reverse);
    }

    public NodeIterator siblingIterator(NodeTest test, boolean reverse) {
        return new DOMNodeIterator(this, false, test, reverse);
    }

    public NodeIterator attributeIterator(QName name) {
        return new DOMAttributeIterator(this, name);
    }

    public NodePointer namespacePointer(String prefix) {
        return new NamespacePointer((NodePointer)this, prefix);
    }

    public NodeIterator namespaceIterator() {
        return new DOMNamespaceIterator(this);
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null || prefix.equals("")) {
            return this.getDefaultNamespaceURI();
        }
        if (prefix.equals("xml")) {
            return XML_NAMESPACE_URI;
        }
        if (prefix.equals("xmlns")) {
            return XMLNS_NAMESPACE_URI;
        }
        String namespace = null;
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        } else {
            namespace = (String)this.namespaces.get(prefix);
        }
        if (namespace == null) {
            String qname = "xmlns:" + prefix;
            Node aNode = this.node;
            while (aNode != null) {
                Attr attr;
                if (aNode.getNodeType() == 1 && (attr = ((Element)aNode).getAttributeNode(qname)) != null) {
                    namespace = attr.getValue();
                    break;
                }
                aNode = aNode.getParentNode();
            }
            if (namespace == null || namespace.equals("")) {
                namespace = NodePointer.UNKNOWN_NAMESPACE;
            }
        }
        this.namespaces.put(prefix, namespace);
        return namespace;
    }

    public String getDefaultNamespaceURI() {
        if (this.defaultNamespace == null) {
            Node aNode = this.node;
            while (aNode != null) {
                Attr attr;
                if (aNode.getNodeType() == 1 && (attr = ((Element)aNode).getAttributeNode("xmlns")) != null) {
                    this.defaultNamespace = attr.getValue();
                    break;
                }
                aNode = aNode.getParentNode();
            }
        }
        if (this.defaultNamespace == null) {
            this.defaultNamespace = "";
        }
        return this.defaultNamespace.equals("") ? null : this.defaultNamespace;
    }

    public Object getBaseValue() {
        return this.node;
    }

    public Object getValue() {
        return this.node;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public boolean isLeaf() {
        return !this.node.hasChildNodes();
    }

    public boolean isLanguage(String lang) {
        String current = this.getLanguage();
        if (current == null) {
            return super.isLanguage(lang);
        }
        return current.toUpperCase().startsWith(lang.toUpperCase());
    }

    protected String getLanguage() {
        Node n = this.node;
        while (n != null) {
            Element e;
            String attr;
            if (n.getNodeType() == 1 && (attr = (e = (Element)n).getAttribute("xml:lang")) != null && !attr.equals("")) {
                return attr;
            }
            n = n.getParentNode();
        }
        return null;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Cannot modify DOM trees");
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
        }
        switch (this.node.getNodeType()) {
            case 1: {
                if (!(this.parent instanceof DOMNodePointer)) break;
                buffer.append('/');
                buffer.append(this.getName());
                buffer.append('[').append(this.getRelativePositionByName()).append(']');
                break;
            }
            case 3: 
            case 4: {
                buffer.append("/text()");
                buffer.append('[').append(this.getRelativePositionOfTextNode()).append(']');
                break;
            }
            case 7: {
                String target = ((ProcessingInstruction)this.node).getTarget();
                buffer.append("/processing-instruction('").append(target).append("')");
                buffer.append('[').append(this.getRelativePositionOfPI(target)).append(']');
                break;
            }
        }
        return buffer.toString();
    }

    private int getRelativePositionByName() {
        int count = 1;
        Node n = this.node.getPreviousSibling();
        while (n != null) {
            String nm;
            if (n.getNodeType() == 1 && (nm = n.getNodeName()).equals(this.node.getNodeName())) {
                ++count;
            }
            n = n.getPreviousSibling();
        }
        return count;
    }

    private int getRelativePositionOfTextNode() {
        int count = 1;
        Node n = this.node.getPreviousSibling();
        while (n != null) {
            if (n.getNodeType() == 3 || n.getNodeType() == 4) {
                ++count;
            }
            n = n.getPreviousSibling();
        }
        return count;
    }

    private int getRelativePositionOfPI(String target) {
        int count = 1;
        Node n = this.node.getPreviousSibling();
        while (n != null) {
            if (n.getNodeType() == 7 && ((ProcessingInstruction)n).getTarget().equals(target)) {
                ++count;
            }
            n = n.getPreviousSibling();
        }
        return count;
    }

    public int hashCode() {
        return System.identityHashCode(this.node);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DOMNodePointer)) {
            return false;
        }
        DOMNodePointer other = (DOMNodePointer)object;
        return this.node == other.node;
    }

    public static String getPrefix(Node node) {
        String prefix = node.getPrefix();
        if (prefix != null) {
            return prefix;
        }
        String name = node.getNodeName();
        int index = name.lastIndexOf(58);
        if (index == -1) {
            return null;
        }
        return name.substring(0, index);
    }

    public static String getLocalName(Node node) {
        String localName = node.getLocalName();
        if (localName != null) {
            return localName;
        }
        String name = node.getNodeName();
        int index = name.lastIndexOf(58);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }
}

