/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import java.util.Arrays;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.apache.commons.jxpath.ri.pointers.PropertyAccessHelper;
import org.apache.commons.jxpath.ri.pointers.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.pointers.PropertyPointer;

public class DynamicPropertyPointer
extends PropertyPointer {
    private DynamicPropertyHandler handler;
    private String name;
    private String[] names;
    private String requiredPropertyName;

    public DynamicPropertyPointer(NodePointer parent, DynamicPropertyHandler handler) {
        super(parent);
        this.handler = handler;
    }

    public int getPropertyCount() {
        return this.getPropertyNames().length;
    }

    public String[] getPropertyNames() {
        if (this.names == null) {
            int inx;
            String[] allNames = this.handler.getPropertyNames(this.getBean());
            this.names = new String[allNames.length];
            int i = 0;
            while (i < this.names.length) {
                this.names[i] = allNames[i];
                ++i;
            }
            Arrays.sort(this.names);
            if (this.requiredPropertyName != null && (inx = Arrays.binarySearch(this.names, this.requiredPropertyName)) < 0) {
                allNames = this.names;
                this.names = new String[allNames.length + 1];
                this.names[0] = this.requiredPropertyName;
                System.arraycopy(allNames, 0, this.names, 1, allNames.length);
                Arrays.sort(this.names);
            }
        }
        return this.names;
    }

    public String getPropertyName() {
        if (this.name == null) {
            String[] names = this.getPropertyNames();
            this.name = this.propertyIndex >= 0 && this.propertyIndex < names.length ? names[this.propertyIndex] : "*";
        }
        return this.name;
    }

    public void setPropertyName(String propertyName) {
        this.setPropertyIndex(PropertyOwnerPointer.UNSPECIFIED_PROPERTY);
        this.name = propertyName;
        this.requiredPropertyName = propertyName;
        if (this.names != null && Arrays.binarySearch(this.names, propertyName) < 0) {
            this.names = null;
        }
    }

    public int getPropertyIndex() {
        if (this.propertyIndex == PropertyOwnerPointer.UNSPECIFIED_PROPERTY) {
            String[] names = this.getPropertyNames();
            int i = 0;
            while (i < names.length) {
                if (names[i].equals(this.name)) {
                    this.setPropertyIndex(i);
                    break;
                }
                ++i;
            }
        }
        return super.getPropertyIndex();
    }

    public void setPropertyIndex(int index) {
        if (this.propertyIndex != index) {
            super.setPropertyIndex(index);
            this.name = null;
        }
    }

    public int getLength() {
        return PropertyAccessHelper.getLength(this.getValue());
    }

    public Object getBaseValue() {
        return this.handler.getProperty(this.getBean(), this.getPropertyName());
    }

    public Object getValue() {
        Object value = this.index == NodePointer.WHOLE_COLLECTION ? this.handler.getProperty(this.getBean(), this.getPropertyName()) : PropertyAccessHelper.getValue(this.handler.getProperty(this.getBean(), this.getPropertyName()), this.index);
        return value;
    }

    public void setValue(Object value) {
        if (this.index == NodePointer.WHOLE_COLLECTION) {
            this.handler.setProperty(this.getBean(), this.getPropertyName(), value);
        } else {
            PropertyAccessHelper.setValue(this.handler.getProperty(this.getBean(), this.getPropertyName()), this.index, value);
        }
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getParent().asPath());
        buffer.append("[@name='");
        buffer.append(this.escape(this.getPropertyName()));
        buffer.append("']");
        if (this.index != NodePointer.WHOLE_COLLECTION && this.isCollection()) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    private String escape(String string) {
        int index = string.indexOf(39);
        while (index != -1) {
            string = string.substring(0, index) + "&apos;" + string.substring(index + 1);
            index = string.indexOf(39);
        }
        index = string.indexOf(34);
        while (index != -1) {
            string = string.substring(0, index) + "&quot;" + string.substring(index + 1);
            index = string.indexOf(34);
        }
        return string;
    }
}

