/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.pointers.NodePointer;

public class NamespacePointer
extends NodePointer {
    private String prefix;
    private String namespaceURI;

    public NamespacePointer(NodePointer parent, String prefix) {
        super(parent);
        this.prefix = prefix;
    }

    public NamespacePointer(NodePointer parent, String prefix, String namespaceURI) {
        super(parent);
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
    }

    public QName getName() {
        return new QName(this.getNamespaceURI(), this.prefix);
    }

    public Object getBaseValue() {
        return null;
    }

    public Object getValue() {
        return this.getNamespaceURI();
    }

    public String getNamespaceURI() {
        if (this.namespaceURI == null) {
            this.namespaceURI = this.parent.getNamespaceURI(this.prefix);
        }
        return this.namespaceURI;
    }

    public boolean isLeaf() {
        return true;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Cannot modify DOM trees");
    }

    public boolean testNode(NodeTest nodeTest) {
        return nodeTest == null || nodeTest instanceof NodeTypeTest && ((NodeTypeTest)nodeTest).getNodeType() == 1;
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
            buffer.append('/');
        }
        buffer.append("namespace::");
        buffer.append(this.prefix);
        return buffer.toString();
    }

    public int hashCode() {
        String nsURI = this.getNamespaceURI();
        if (nsURI == null) {
            return 0;
        }
        return nsURI.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NamespacePointer)) {
            return false;
        }
        NamespacePointer other = (NamespacePointer)object;
        String nsURI = this.getNamespaceURI();
        String otherNSURI = other.getNamespaceURI();
        return nsURI == null && otherNSURI == null || nsURI != null && nsURI.endsWith(otherNSURI);
    }
}

