/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import java.util.Locale;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.pointers.BeanPointer;
import org.apache.commons.jxpath.ri.pointers.ContainerPointer;
import org.apache.commons.jxpath.ri.pointers.DOMNodePointer;
import org.apache.commons.jxpath.ri.pointers.DynamicPointer;
import org.apache.commons.jxpath.ri.pointers.NodeIterator;
import org.apache.commons.jxpath.ri.pointers.NullPointer;
import org.apache.commons.jxpath.ri.pointers.PropertyAccessHelper;
import org.w3c.dom.Node;

public abstract class NodePointer
implements Pointer,
Cloneable {
    public static int WHOLE_COLLECTION = Integer.MIN_VALUE;
    protected int index = WHOLE_COLLECTION;
    public static String UNKNOWN_NAMESPACE = "<<unknown namespace>>";
    protected NodePointer parent;
    protected Locale locale;

    public static NodePointer createNodePointer(QName name, Object bean, Locale locale) {
        if (bean == null) {
            return new NullPointer(name, locale);
        }
        if (bean instanceof Node) {
            return new DOMNodePointer((Node)bean, locale);
        }
        if (bean instanceof Container) {
            return new ContainerPointer((Container)bean, locale);
        }
        JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(bean.getClass());
        if (bi.isDynamic()) {
            DynamicPropertyHandler handler = PropertyAccessHelper.getDynamicPropertyHandler(bi.getDynamicPropertyHandlerClass());
            return new DynamicPointer(name, bean, handler, locale);
        }
        return new BeanPointer(name, bean, bi, locale);
    }

    public static NodePointer createNodePointer(NodePointer parent, QName name, Object bean) {
        if (bean == null) {
            return new NullPointer(parent, name);
        }
        if (bean instanceof Node) {
            return new DOMNodePointer(parent, (Node)bean);
        }
        if (bean instanceof Container) {
            return new ContainerPointer(parent, (Container)bean);
        }
        JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(bean.getClass());
        if (bi.isDynamic()) {
            DynamicPropertyHandler handler = PropertyAccessHelper.getDynamicPropertyHandler(bi.getDynamicPropertyHandlerClass());
            return new DynamicPointer(parent, name, bean, handler);
        }
        return new BeanPointer(parent, name, bean, bi);
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse) {
        return null;
    }

    public NodeIterator siblingIterator(NodeTest test, boolean reverse) {
        return null;
    }

    public NodeIterator attributeIterator(QName qname) {
        return null;
    }

    public NodeIterator namespaceIterator() {
        return null;
    }

    public NodePointer namespacePointer(String namespace) {
        return null;
    }

    public String getNamespaceURI(String prefix) {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    protected boolean isDefaultNamespace(String prefix) {
        if (prefix == null) {
            return true;
        }
        String namespace = this.getNamespaceURI(prefix);
        if (namespace == null) {
            return false;
        }
        return namespace.equals(this.getDefaultNamespaceURI());
    }

    protected String getDefaultNamespaceURI() {
        return null;
    }

    public QName getExpandedName() {
        return this.getName();
    }

    protected NodePointer(NodePointer parent) {
        this.parent = parent;
    }

    protected NodePointer(NodePointer parent, Locale locale) {
        this.parent = parent;
        this.locale = locale;
    }

    public NodePointer getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        Object value = this.getValue();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isCollection() {
        Object value = this.getBaseValue();
        return value != null && PropertyAccessHelper.isCollection(value);
    }

    public int getLength() {
        Object value = this.getBaseValue();
        if (value == null) {
            return 1;
        }
        return PropertyAccessHelper.getLength(value);
    }

    public abstract QName getName();

    public abstract Object getBaseValue();

    public abstract void setValue(Object var1);

    public abstract boolean testNode(NodeTest var1);

    public Locale getLocale() {
        if (this.locale == null && this.parent != null) {
            this.locale = this.parent.getLocale();
        }
        return this.locale;
    }

    public boolean isLanguage(String lang) {
        Locale loc = this.getLocale();
        String name = loc.toString().replace('_', '-');
        return name.toUpperCase().startsWith(lang.toUpperCase());
    }

    public String asPath() {
        QName name;
        StringBuffer buffer = new StringBuffer();
        if (this.getParent() != null) {
            buffer.append(this.getParent().asPath());
        }
        if ((name = this.getName()) != null) {
            if (this.getParent() != null) {
                buffer.append('/');
            }
            buffer.append(name);
        }
        if (this.index != WHOLE_COLLECTION && this.isCollection()) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.asPath();
    }

    public abstract Object getValue();
}

