/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import java.util.Locale;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.apache.commons.jxpath.ri.pointers.PropertyOwnerPointer;

public class NullPointer
extends PropertyOwnerPointer {
    private QName name;

    public NullPointer(QName name, Locale locale) {
        super(null, locale);
        this.name = name;
    }

    public NullPointer(NodePointer parent, QName name) {
        super(parent);
        this.name = name;
    }

    public QName getName() {
        return this.name;
    }

    public Object getBaseValue() {
        return null;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Cannot setValue of an object that is not some other object's property");
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NullPointer)) {
            return false;
        }
        NullPointer other = (NullPointer)object;
        return this.name == null && other.name == null || this.name != null && this.name.equals(other.name);
    }

    public String asPath() {
        if (this.parent != null) {
            return super.asPath();
        }
        return "null()";
    }

    public int getLength() {
        return 0;
    }
}

