/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.DynamicPropertyHandler;

public class PropertyAccessHelper {
    private static Map dynamicPropertyHandlerMap = new HashMap();

    public static boolean isCollection(PropertyDescriptor propertyDescriptor) {
        return false;
    }

    public static boolean isCollection(PropertyDescriptor propertyDescriptor, Object value) {
        return PropertyAccessHelper.isCollection(value);
    }

    public static boolean isCollection(Object value) {
        if (value == null) {
            return false;
        }
        if (value.getClass().isArray()) {
            return true;
        }
        return value instanceof Collection;
    }

    public static int getLength(Object bean, PropertyDescriptor propertyDescriptor) {
        Object obj = PropertyAccessHelper.getValue(bean, propertyDescriptor);
        return PropertyAccessHelper.getLength(obj);
    }

    public static int getLength(Object collection) {
        if (collection == null) {
            return 0;
        }
        if (collection.getClass().isArray()) {
            return Array.getLength(collection);
        }
        if (collection instanceof Collection) {
            return ((Collection)collection).size();
        }
        return 1;
    }

    public static Object getValue(Object bean, PropertyDescriptor propertyDescriptor, int index) {
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            try {
                IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)propertyDescriptor;
                Method method = ipd.getIndexedReadMethod();
                if (method != null) {
                    return method.invoke(bean, new Integer(index));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot access property: " + propertyDescriptor.getName() + ", " + ex.getMessage());
            }
        }
        return PropertyAccessHelper.getValue(PropertyAccessHelper.getValue(bean, propertyDescriptor), index);
    }

    public static void setValue(Object bean, PropertyDescriptor propertyDescriptor, int index, Object value) {
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            try {
                IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)propertyDescriptor;
                Method method = ipd.getIndexedWriteMethod();
                if (method != null) {
                    method.invoke(bean, new Integer(index), value);
                    return;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot access property: " + propertyDescriptor.getName() + ", " + ex.getMessage());
            }
        }
        PropertyAccessHelper.setValue(PropertyAccessHelper.getValue(bean, propertyDescriptor), index, value);
    }

    public static Object getValue(Object collection, int index) {
        Object value = collection;
        if (collection != null) {
            if (collection.getClass().isArray()) {
                value = Array.get(collection, index);
            } else if (collection instanceof List) {
                value = ((List)collection).get(index);
            } else if (collection instanceof Collection) {
                Iterator it = ((Collection)collection).iterator();
                int i = 0;
                while (i <= index) {
                    value = it.next();
                    ++i;
                }
            }
        }
        return value;
    }

    public static void setValue(Object collection, int index, Object value) {
        if (collection != null) {
            if (collection.getClass().isArray()) {
                Array.set(collection, index, value);
            } else if (collection instanceof List) {
                ((List)collection).set(index, value);
            } else if (collection instanceof Collection) {
                throw new UnsupportedOperationException("Cannot set value of an element of a " + collection.getClass().getName());
            }
        }
    }

    public static Object getValue(Object bean, PropertyDescriptor propertyDescriptor) {
        Object value;
        try {
            Method method = PropertyAccessHelper.getAccessibleMethod(propertyDescriptor.getReadMethod());
            if (method == null) {
                throw new RuntimeException("No read method");
            }
            value = method.invoke(bean, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot access property: " + propertyDescriptor.getName() + ", " + ex.getMessage());
        }
        return value;
    }

    public static void setValue(Object bean, PropertyDescriptor propertyDescriptor, Object value) {
        try {
            Method method = PropertyAccessHelper.getAccessibleMethod(propertyDescriptor.getWriteMethod());
            if (method == null) {
                throw new RuntimeException("No write method");
            }
            value = method.invoke(bean, value);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot modify property: " + propertyDescriptor.getName() + ", " + ex);
        }
    }

    public static DynamicPropertyHandler getDynamicPropertyHandler(Class clazz) {
        DynamicPropertyHandler handler = (DynamicPropertyHandler)dynamicPropertyHandlerMap.get(clazz);
        if (handler == null) {
            try {
                handler = (DynamicPropertyHandler)clazz.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot allocate dynamic property handler  of class " + clazz + ".\n" + ex);
            }
            dynamicPropertyHandlerMap.put(clazz, handler);
        }
        return handler;
    }

    private static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        method = PropertyAccessHelper.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (Modifier.isPublic(interfaces[i].getModifiers())) {
                try {
                    method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (method != null || (method = PropertyAccessHelper.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
            }
            ++i;
        }
        return method;
    }
}

