/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import org.apache.commons.jxpath.ri.pointers.DynamicPropertyPointer;
import org.apache.commons.jxpath.ri.pointers.NodeIterator;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.apache.commons.jxpath.ri.pointers.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.pointers.PropertyPointer;

public class PropertyIterator
implements NodeIterator {
    boolean empty = false;
    private boolean reverse;
    private String name;
    private int startIndex = 0;
    private boolean targetReady = false;
    private int position = 0;
    private PropertyPointer propertyNodePointer;
    private int startPropertyIndex;
    private boolean ready = false;
    private boolean includeStart = false;

    public PropertyIterator(PropertyOwnerPointer pointer, boolean children, String name, boolean reverse) {
        if (children) {
            this.propertyNodePointer = pointer.getPropertyPointer();
            this.name = name;
            this.reverse = reverse;
            this.includeStart = true;
            if (reverse) {
                this.startPropertyIndex = -1;
                this.startIndex = -1;
            }
        } else {
            this.propertyNodePointer = (PropertyPointer)pointer.clone();
            this.name = name;
            this.reverse = reverse;
            this.startPropertyIndex = this.propertyNodePointer.getPropertyIndex();
            this.startIndex = this.propertyNodePointer.getIndex();
            this.includeStart = false;
            if (reverse && this.startIndex == -1) {
                this.includeStart = true;
            }
        }
    }

    public void reset() {
        this.position = 0;
        this.targetReady = false;
    }

    public NodePointer getNodePointer() {
        if (this.position == 0) {
            if (this.name != null) {
                if (!this.targetReady) {
                    this.prepare();
                }
                if (this.empty) {
                    return null;
                }
            } else {
                if (!this.setPosition(1)) {
                    return null;
                }
                this.reset();
            }
        }
        return this.propertyNodePointer.childNodePointer();
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        if (this.name != null) {
            return this.setPositionIndividual(position);
        }
        return this.setPositionMultiple(position);
    }

    private boolean setPositionIndividual(int position) {
        int index;
        this.position = position;
        if (position < 1) {
            return false;
        }
        if (!this.targetReady) {
            this.prepare();
        }
        if (this.empty) {
            return false;
        }
        int length = this.propertyNodePointer.getLength();
        if (!this.reverse) {
            index = position + this.startIndex;
            if (!this.includeStart) {
                ++index;
            }
            if (index > length) {
                return false;
            }
        } else {
            int end = this.startIndex;
            if (end == -1) {
                end = length - 1;
            }
            index = end - position + 2;
            if (!this.includeStart) {
                --index;
            }
            if (index < 1) {
                return false;
            }
        }
        this.propertyNodePointer.setIndex(index - 1);
        return true;
    }

    private boolean setPositionMultiple(int position) {
        this.position = position;
        if (position < 1) {
            return false;
        }
        int count = this.propertyNodePointer.getPropertyCount();
        if (!this.reverse) {
            int index = 1;
            int i = this.startPropertyIndex;
            while (i < count) {
                int offset;
                this.propertyNodePointer.setPropertyIndex(i);
                int length = this.propertyNodePointer.getLength();
                if (i == this.startPropertyIndex) {
                    length -= this.startIndex;
                    if (!this.includeStart) {
                        --length;
                    }
                    offset = this.startIndex + position - index;
                    if (!this.includeStart) {
                        ++offset;
                    }
                } else {
                    offset = position - index;
                }
                if (index <= position && position < index + length) {
                    this.propertyNodePointer.setIndex(offset);
                    return true;
                }
                index += length;
                ++i;
            }
        } else {
            int index = 1;
            int start = this.startPropertyIndex;
            if (start == -1) {
                start = count - 1;
            }
            int i = start;
            while (i >= 0) {
                int offset;
                this.propertyNodePointer.setPropertyIndex(i);
                int length = this.propertyNodePointer.getLength();
                if (i == this.startPropertyIndex) {
                    int end = this.startIndex;
                    if (end == -1) {
                        end = length - 1;
                    }
                    length = end + 1;
                    offset = end - position + 1;
                    if (!this.includeStart) {
                        --offset;
                        --length;
                    }
                } else {
                    offset = length - (position - index) - 1;
                }
                if (index <= position && position < index + length) {
                    this.propertyNodePointer.setIndex(offset);
                    return true;
                }
                index += length;
                --i;
            }
        }
        return false;
    }

    private void prepare() {
        this.targetReady = true;
        this.empty = true;
        if (this.propertyNodePointer instanceof DynamicPropertyPointer) {
            this.propertyNodePointer.setPropertyName(this.name);
        }
        String[] names = this.propertyNodePointer.getPropertyNames();
        if (!this.reverse) {
            int startPropertyIndex = this.propertyNodePointer.getPropertyIndex();
            if (startPropertyIndex == PropertyOwnerPointer.UNSPECIFIED_PROPERTY) {
                startPropertyIndex = 0;
            }
            if (this.propertyNodePointer.getIndex() == NodePointer.WHOLE_COLLECTION) {
                this.startIndex = 0;
            }
            int i = startPropertyIndex;
            while (i < names.length) {
                if (names[i].equals(this.name)) {
                    this.propertyNodePointer.setPropertyIndex(i);
                    if (i != startPropertyIndex) {
                        this.startIndex = 0;
                        this.includeStart = true;
                    }
                    this.empty = false;
                    break;
                }
                ++i;
            }
        } else {
            int startPropertyIndex = this.propertyNodePointer.getPropertyIndex();
            if (startPropertyIndex == PropertyOwnerPointer.UNSPECIFIED_PROPERTY) {
                startPropertyIndex = names.length - 1;
            }
            if (this.propertyNodePointer.getIndex() == NodePointer.WHOLE_COLLECTION) {
                this.startIndex = -1;
            }
            int i = startPropertyIndex;
            while (i >= 0) {
                if (names[i].equals(this.name)) {
                    this.propertyNodePointer.setPropertyIndex(i);
                    if (i != startPropertyIndex) {
                        this.startIndex = -1;
                        this.includeStart = true;
                    }
                    this.empty = false;
                    break;
                }
                --i;
            }
        }
    }
}

