/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import java.util.Locale;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.pointers.BeanAttributeIterator;
import org.apache.commons.jxpath.ri.pointers.BeanPropertyPointer;
import org.apache.commons.jxpath.ri.pointers.DynamicPropertyPointer;
import org.apache.commons.jxpath.ri.pointers.NodeIterator;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.apache.commons.jxpath.ri.pointers.NullPropertyPointer;
import org.apache.commons.jxpath.ri.pointers.PropertyAccessHelper;
import org.apache.commons.jxpath.ri.pointers.PropertyIterator;
import org.apache.commons.jxpath.ri.pointers.PropertyPointer;

public abstract class PropertyOwnerPointer
extends NodePointer {
    public static int UNSPECIFIED_PROPERTY = Integer.MIN_VALUE;

    public NodeIterator childIterator(NodeTest test, boolean reverse) {
        return this.nodeIterator(test, reverse, true);
    }

    public NodeIterator siblingIterator(NodeTest test, boolean reverse) {
        return this.nodeIterator(test, reverse, false);
    }

    private NodeIterator nodeIterator(NodeTest test, boolean reverse, boolean children) {
        if (test == null) {
            return new PropertyIterator(this, children, null, reverse);
        }
        if (test instanceof NodeNameTest) {
            QName testName = ((NodeNameTest)test).getNodeName();
            if (!this.isDefaultNamespace(testName.getPrefix())) {
                return null;
            }
            String property = testName.getName().equals("*") ? null : testName.getName();
            return new PropertyIterator(this, children, property, reverse);
        }
        if (test instanceof NodeTypeTest && ((NodeTypeTest)test).getNodeType() == 1) {
            return new PropertyIterator(this, children, null, reverse);
        }
        return null;
    }

    public boolean testNode(NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            String nodeNS;
            String testNS;
            String nodePrefix;
            QName testName = ((NodeNameTest)test).getNodeName();
            QName nodeName = this.getName();
            String testPrefix = testName.getPrefix();
            if (!PropertyOwnerPointer.equalStrings(testPrefix, nodePrefix = nodeName.getPrefix()) && !PropertyOwnerPointer.equalStrings(testNS = this.getNamespaceURI(testPrefix), nodeNS = this.getNamespaceURI(nodePrefix))) {
                return false;
            }
            String testLocalName = testName.getName();
            if (testLocalName.equals("*")) {
                return true;
            }
            return testLocalName.equals(nodeName.getName());
        }
        return test instanceof NodeTypeTest && ((NodeTypeTest)test).getNodeType() == 1;
    }

    private static boolean equalStrings(String s1, String s2) {
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1 == null || s1.equals(s2);
    }

    public NodeIterator attributeIterator(QName name) {
        return new BeanAttributeIterator(this, name);
    }

    protected PropertyOwnerPointer(NodePointer parent, Locale locale) {
        super(parent, locale);
    }

    protected PropertyOwnerPointer(NodePointer parent) {
        super(parent);
    }

    public boolean isCollection() {
        Object value = this.getBaseValue();
        return value != null && PropertyAccessHelper.isCollection(value);
    }

    public Object getValue() {
        Object value = this.index == NodePointer.WHOLE_COLLECTION ? this.getBaseValue() : PropertyAccessHelper.getValue(this.getBaseValue(), this.index);
        return value;
    }

    public abstract QName getName();

    public abstract void setValue(Object var1);

    public PropertyPointer getPropertyPointer() {
        Object value = this.getValue();
        if (value == null) {
            return new NullPropertyPointer(this);
        }
        JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(value.getClass());
        if (bi.isDynamic()) {
            DynamicPropertyHandler handler = PropertyAccessHelper.getDynamicPropertyHandler(bi.getDynamicPropertyHandlerClass());
            return new DynamicPropertyPointer((NodePointer)this, handler);
        }
        return new BeanPropertyPointer((NodePointer)this, bi);
    }
}

