/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.pointers.ContainerPointer;
import org.apache.commons.jxpath.ri.pointers.DOMNodePointer;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.apache.commons.jxpath.ri.pointers.PropertyOwnerPointer;
import org.w3c.dom.Node;

public abstract class PropertyPointer
extends PropertyOwnerPointer {
    protected int propertyIndex = PropertyOwnerPointer.UNSPECIFIED_PROPERTY;
    protected Object bean;

    public PropertyPointer(NodePointer parent) {
        super(parent);
    }

    public int getPropertyIndex() {
        return this.propertyIndex;
    }

    public void setPropertyIndex(int index) {
        this.propertyIndex = index;
        index = NodePointer.WHOLE_COLLECTION;
    }

    public Object getBean() {
        if (this.bean == null) {
            this.bean = this.getParent().getValue();
        }
        return this.bean;
    }

    public QName getName() {
        return new QName(null, this.getPropertyName());
    }

    public abstract String getPropertyName();

    public abstract void setPropertyName(String var1);

    public abstract int getPropertyCount();

    public abstract String[] getPropertyNames();

    public NodePointer childNodePointer() {
        Object bean = this.getValue();
        if (bean instanceof Node) {
            return new DOMNodePointer((NodePointer)this, (Node)bean);
        }
        if (bean instanceof Container) {
            return new ContainerPointer((NodePointer)this, (Container)bean);
        }
        return (NodePointer)this.clone();
    }

    public int hashCode() {
        return this.getParent().hashCode() + this.propertyIndex + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyPointer)) {
            return false;
        }
        PropertyPointer other = (PropertyPointer)object;
        return this.getParent() == other.getParent() && this.propertyIndex == other.propertyIndex && this.index == other.index;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getBean().getClass().getName());
        buffer.append('@');
        buffer.append(System.identityHashCode(this.getBean()));
        buffer.append('.');
        buffer.append(this.getPropertyName());
        if (this.index != NodePointer.WHOLE_COLLECTION) {
            buffer.append('[').append(this.index).append(']');
        }
        buffer.append(" = ").append(this.getValue());
        return buffer.toString();
    }
}

