/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.pointers;

import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.pointers.NodeIterator;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.apache.commons.jxpath.ri.pointers.PropertyAccessHelper;

public class VariablePointer
extends NodePointer {
    private Variables variables;
    private QName name;
    private NodePointer valuePointer;

    public VariablePointer(Variables variables, QName name) {
        super(null);
        this.variables = variables;
        this.name = name;
    }

    public QName getName() {
        return this.name;
    }

    public Object getBaseValue() {
        return this.variables.getVariable(this.name.getName());
    }

    public Object getValue() {
        Object value = this.getBaseValue();
        if (this.index != NodePointer.WHOLE_COLLECTION) {
            return PropertyAccessHelper.getValue(value, this.index);
        }
        return value;
    }

    public void setValue(Object value) {
        this.valuePointer = null;
        this.variables.declareVariable(this.name.getName(), value);
    }

    private NodePointer getValuePointer() {
        if (this.valuePointer == null) {
            Object value = this.getValue();
            this.valuePointer = NodePointer.createNodePointer(this, null, value);
        }
        return this.valuePointer;
    }

    public int hashCode() {
        return System.identityHashCode(this.variables) + this.name.hashCode() + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VariablePointer)) {
            return false;
        }
        VariablePointer other = (VariablePointer)object;
        return this.variables == other.variables && this.name.equals(other.name) && this.index == other.index;
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('$');
        buffer.append(this.name);
        if (this.index != NodePointer.WHOLE_COLLECTION && this.isCollection()) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse) {
        return this.getValuePointer().childIterator(test, reverse);
    }

    public NodeIterator siblingIterator(NodeTest test, boolean reverse) {
        return this.getValuePointer().siblingIterator(test, reverse);
    }

    public NodeIterator attributeIterator(QName name) {
        return this.getValuePointer().attributeIterator(name);
    }

    public NodeIterator namespaceIterator() {
        return this.getValuePointer().namespaceIterator();
    }

    public NodePointer namespacePointer(String name) {
        return this.getValuePointer().namespacePointer(name);
    }

    public boolean testNode(NodeTest nodeTest) {
        return this.getValuePointer().testNode(nodeTest);
    }
}

