/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.collections;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class BucketMap
implements Map {
    private static final int DEFAULT_BUCKETS = 256;
    private final Node[] m_buckets;
    private volatile int m_size = 0;

    public BucketMap() {
        this(256);
    }

    public BucketMap(int numBuckets) {
        int size = Math.max(17, numBuckets);
        this.m_buckets = new Node[size];
        int i = 0;
        while (i < size) {
            this.m_buckets[i] = new Node();
            ++i;
        }
    }

    private final int getHash(Object key) {
        int hash = key.hashCode();
        hash += ~(hash << 9);
        hash ^= hash >>> 14;
        hash += hash << 4;
        hash ^= hash >>> 10;
        return (hash %= this.m_buckets.length) < 0 ? hash * -1 : hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        HashSet<Object> keySet = new HashSet<Object>();
        int i = 0;
        while (i < this.m_buckets.length) {
            Node node = this.m_buckets[i];
            synchronized (node) {
                Node n = this.m_buckets[i];
                while (n != null && n.key != null) {
                    keySet.add(n.key);
                    n = n.next;
                }
            }
            ++i;
        }
        return keySet;
    }

    public int size() {
        return this.m_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object put(Object key, Object value) {
        if (null == key) return null;
        if (null == value) {
            return null;
        }
        int hash = this.getHash(key);
        Node node = this.m_buckets[hash];
        synchronized (node) {
            Node n = this.m_buckets[hash];
            if (n.key == null) {
                n.key = key;
                n.value = value;
                ++this.m_size;
                return value;
            }
            Node next = n;
            while (next != null) {
                n = next;
                if (n.key.equals(key)) {
                    Object returnVal = n.value;
                    n.value = value;
                    return returnVal;
                }
                next = next.next;
            }
            Node newNode = new Node();
            newNode.key = key;
            newNode.value = value;
            n.next = newNode;
            ++this.m_size;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object get(Object key) {
        if (null == key) {
            return null;
        }
        int hash = this.getHash(key);
        Node node = this.m_buckets[hash];
        synchronized (node) {
            Node n = this.m_buckets[hash];
            while (n != null && n.key != null) {
                if (n.key.equals(key)) {
                    Object object = n.value;
                    return object;
                }
                n = n.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean containsKey(Object key) {
        if (null == key) {
            return false;
        }
        int hash = this.getHash(key);
        Node node = this.m_buckets[hash];
        synchronized (node) {
            Node n = this.m_buckets[hash];
            while (n != null && n.key != null) {
                if (n.key.equals(key)) {
                    boolean bl = true;
                    return bl;
                }
                n = n.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsValue(Object value) {
        if (null == value) {
            return false;
        }
        int i = 0;
        while (i < this.m_buckets.length) {
            Node node = this.m_buckets[i];
            synchronized (node) {
                Node n = this.m_buckets[i];
                while (n != null && n.key != null) {
                    if (n.value.equals(value)) {
                        return true;
                    }
                    n = n.next;
                }
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        HashSet<Object> valueSet = new HashSet<Object>();
        int i = 0;
        while (i < this.m_buckets.length) {
            Node node = this.m_buckets[i];
            synchronized (node) {
                Node n = this.m_buckets[i];
                while (n != null && n.key != null) {
                    valueSet.add(n.value);
                    n = n.next;
                }
            }
            ++i;
        }
        return valueSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        HashSet<Node> entrySet = new HashSet<Node>();
        int i = 0;
        while (i < this.m_buckets.length) {
            Node node = this.m_buckets[i];
            synchronized (node) {
                Node n = this.m_buckets[i];
                while (n != null && n.key != null) {
                    entrySet.add(n);
                    n = n.next;
                }
            }
            ++i;
        }
        return entrySet;
    }

    public void putAll(Map other) {
        Iterator i = other.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.put(key, other.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object remove(Object key) {
        if (null == key) {
            return null;
        }
        int hash = this.getHash(key);
        Node node = this.m_buckets[hash];
        synchronized (node) {
            Node n = this.m_buckets[hash];
            Node prev = null;
            while (n != null && n.key != null) {
                if (n.key.equals(key)) {
                    if (null == prev) {
                        this.m_buckets[hash] = n.next == null ? new Node() : n.next;
                    } else {
                        prev.next = n.next;
                    }
                    --this.m_size;
                    Object object = n.value;
                    return object;
                }
                prev = n;
                n = n.next;
            }
        }
        return null;
    }

    public final boolean isEmpty() {
        return this.m_size == 0;
    }

    public final void clear() {
        int i = 0;
        while (i < this.m_buckets.length) {
            this.m_buckets[i] = null;
            this.m_buckets[i] = new Node();
            ++i;
        }
    }

    static {
        DEFAULT_BUCKETS = 256;
    }

    private final class Node
    implements Map.Entry {
        protected Object key;
        protected Object value;
        protected Node next;

        private Node() {
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return BucketMap.this.getHash(this.key);
        }

        public Object setValue(Object val) {
            Object retVal = this.value;
            this.value = val;
            return retVal;
        }
    }
}

