/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.concurrent;

public class ConditionalEvent {
    private boolean m_state = false;
    private boolean m_autoReset = false;

    public ConditionalEvent(boolean initialState) {
        this.m_state = initialState;
    }

    public ConditionalEvent(boolean initialState, boolean autoReset) {
        this.m_state = initialState;
        this.m_autoReset = autoReset;
    }

    public boolean isSignalled() {
        return this.m_state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal() {
        ConditionalEvent conditionalEvent = this;
        synchronized (conditionalEvent) {
            this.m_state = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAll() {
        ConditionalEvent conditionalEvent = this;
        synchronized (conditionalEvent) {
            this.m_state = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ConditionalEvent conditionalEvent = this;
        synchronized (conditionalEvent) {
            this.m_state = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSignal() throws InterruptedException {
        ConditionalEvent conditionalEvent = this;
        synchronized (conditionalEvent) {
            while (!this.m_state) {
                this.wait();
            }
            if (this.m_autoReset) {
                this.m_state = false;
            }
        }
    }
}

