/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import com.informix.jdbcx.IfxConnectionPoolDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.PooledConnection;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.log.Logger;

public class InformixDataSource
extends AbstractLogEnabled
implements DataSourceComponent,
Loggable {
    private IfxConnectionPoolDataSource m_dataSource;
    private PooledConnection m_pooledConnection;
    private boolean m_autocommit;

    public void setLogger(Logger logger) {
        this.enableLogging((org.apache.avalon.framework.logger.Logger)new LogKitLogger(logger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        InformixDataSource informixDataSource = this;
        synchronized (informixDataSource) {
            if (this.m_pooledConnection == null) {
                this.m_pooledConnection = this.m_dataSource.getPooledConnection();
            }
        }
        Connection conn = this.m_pooledConnection.getConnection();
        if (conn.getAutoCommit() != this.m_autocommit) {
            conn.setAutoCommit(this.m_autocommit);
        }
        return conn;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration poolController = conf.getChild("pool-controller");
        String dbname = conf.getChild("dbname").getValue("ifx");
        this.m_dataSource = new IfxConnectionPoolDataSource();
        this.m_autocommit = conf.getChild("autocommit").getValueAsBoolean(true);
        this.m_dataSource.setIfxCPMInitPoolSize(poolController.getAttributeAsInteger("init", 5));
        this.m_dataSource.setIfxCPMMinPoolSize(poolController.getAttributeAsInteger("min", 5));
        this.m_dataSource.setIfxCPMMaxPoolSize(poolController.getAttributeAsInteger("max", 10));
        this.m_dataSource.setIfxCPMServiceInterval(100L);
        this.m_dataSource.setServerName(conf.getChild("servername").getValue());
        this.m_dataSource.setDatabaseName(conf.getChild("dbname").getValue());
        this.m_dataSource.setIfxIFXHOST(conf.getChild("host").getValue());
        this.m_dataSource.setPortNumber(conf.getChild("host").getAttributeAsInteger("port"));
        this.m_dataSource.setUser(conf.getChild("user").getValue());
        this.m_dataSource.setPassword(conf.getChild("password").getValue());
        this.configureTracing(conf.getChild("tracing", false));
    }

    private void configureTracing(Configuration config) throws ConfigurationException {
        if (config != null) {
            Configuration child = config.getChild("jdbc", false);
            if (child != null) {
                this.m_dataSource.setIfxTRACE(child.getAttributeAsInteger("level"));
                this.m_dataSource.setIfxTRACEFILE(child.getAttribute("file"));
            }
            if ((child = config.getChild("sqli", false)) != null) {
                this.m_dataSource.setIfxPROTOCOLTRACE(child.getAttributeAsInteger("level"));
                this.m_dataSource.setIfxPROTOCOLTRACEFILE(child.getAttribute("file"));
            }
        }
    }
}

