/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.avalon.excalibur.datasource.AbstractJdbcConnection;
import org.apache.avalon.excalibur.datasource.NoValidConnectionException;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public class JdbcConnectionFactory
extends AbstractLogEnabled
implements ObjectFactory {
    private final String m_dburl;
    private final String m_username;
    private final String m_password;
    private final boolean m_autoCommit;
    private final String m_keepAlive;
    private final Class m_class;
    private static final String DEFAULT_KEEPALIVE = "SELECT 1";
    private static final String ORACLE_KEEPALIVE = "SELECT 1 FROM DUAL";
    private Connection m_firstConnection;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$lang$String;

    public JdbcConnectionFactory(String url, String username, String password, boolean autoCommit, boolean oradb) {
        this(url, username, password, autoCommit, oradb, null);
    }

    public JdbcConnectionFactory(String url, String username, String password, boolean autoCommit, boolean oradb, String connectionClass) {
        this(url, username, password, autoCommit, oradb ? ORACLE_KEEPALIVE : DEFAULT_KEEPALIVE, connectionClass);
    }

    public JdbcConnectionFactory(String url, String username, String password, boolean autoCommit, String keepAlive, String connectionClass) {
        this.m_dburl = url;
        this.m_username = username;
        this.m_password = password;
        this.m_autoCommit = autoCommit;
        this.m_keepAlive = keepAlive;
        Class<?> clazz = null;
        try {
            this.m_firstConnection = null == this.m_username ? DriverManager.getConnection(this.m_dburl) : DriverManager.getConnection(this.m_dburl, this.m_username, this.m_password);
            String className = connectionClass;
            if (null == className) {
                try {
                    Method meth = this.m_firstConnection.getClass().getMethod("getHoldability", new Class[0]);
                    className = "org.apache.avalon.excalibur.datasource.Jdbc3Connection";
                }
                catch (Exception e) {
                    className = "org.apache.avalon.excalibur.datasource.JdbcConnection";
                }
            }
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_class = clazz;
    }

    public Object newInstance() throws Exception {
        AbstractJdbcConnection jdbcConnection = null;
        Connection connection = this.m_firstConnection;
        if (null == connection) {
            connection = null == this.m_username ? DriverManager.getConnection(this.m_dburl) : DriverManager.getConnection(this.m_dburl, this.m_username, this.m_password);
        } else {
            this.m_firstConnection = null;
        }
        if (null != this.m_class) {
            try {
                Class[] paramTypes = new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = JdbcConnectionFactory.class$("java.sql.Connection")) : class$java$sql$Connection, class$java$lang$String == null ? (class$java$lang$String = JdbcConnectionFactory.class$("java.lang.String")) : class$java$lang$String};
                Object[] params = new Object[]{connection, this.m_keepAlive};
                Constructor constructor = this.m_class.getConstructor(paramTypes);
                jdbcConnection = (AbstractJdbcConnection)constructor.newInstance(params);
            }
            catch (Exception e) {
                try {
                    boolean oracleKeepAlive = this.m_keepAlive != null && this.m_keepAlive.equalsIgnoreCase(ORACLE_KEEPALIVE);
                    Class[] paramTypes = new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = JdbcConnectionFactory.class$("java.sql.Connection")) : class$java$sql$Connection, Boolean.TYPE};
                    Object[] params = new Object[]{connection, new Boolean(oracleKeepAlive)};
                    Constructor constructor = this.m_class.getConstructor(paramTypes);
                    jdbcConnection = (AbstractJdbcConnection)constructor.newInstance(params);
                }
                catch (Exception ie) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Exception in JdbcConnectionFactory.newInstance:", (Throwable)ie);
                    }
                    throw new NoValidConnectionException(ie.getMessage());
                }
            }
        } else {
            throw new NoValidConnectionException("No valid JdbcConnection class available");
        }
        jdbcConnection.enableLogging(this.getLogger());
        if (jdbcConnection.getAutoCommit() != this.m_autoCommit) {
            jdbcConnection.setAutoCommit(this.m_autoCommit);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("JdbcConnection object created");
        }
        return jdbcConnection;
    }

    public Class getCreatedClass() {
        return this.m_class;
    }

    public void decommission(Object object) throws Exception {
        if (object instanceof AbstractJdbcConnection) {
            ((AbstractJdbcConnection)object).dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_KEEPALIVE = DEFAULT_KEEPALIVE;
        ORACLE_KEEPALIVE = ORACLE_KEEPALIVE;
    }
}

