/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.logger.DefaultLogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.DefaultLogTargetManager;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManageable;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.LogTargetManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;

public class LogKitLoggerManager
implements LoggerManager,
Contextualizable,
Configurable {
    private final Map m_loggers = new HashMap();
    private Context m_context;
    private Hierarchy m_hierarchy;
    private String m_prefix;
    private final org.apache.avalon.framework.logger.Logger m_defaultLogger;

    public LogKitLoggerManager() {
        this(new Hierarchy());
    }

    public LogKitLoggerManager(Hierarchy hierarchy) {
        this(null, hierarchy);
    }

    public LogKitLoggerManager(String prefix) {
        this(prefix, new Hierarchy());
    }

    public LogKitLoggerManager(String prefix, Hierarchy hierarchy) {
        this(prefix, hierarchy, (org.apache.avalon.framework.logger.Logger)new LogKitLogger(hierarchy.getLoggerFor("")));
    }

    public LogKitLoggerManager(String prefix, Hierarchy hierarchy, org.apache.avalon.framework.logger.Logger defaultLogger) {
        this.m_prefix = prefix;
        this.m_hierarchy = hierarchy;
        this.m_defaultLogger = defaultLogger;
    }

    public final org.apache.avalon.framework.logger.Logger getLoggerForCategory(String categoryName) {
        org.apache.avalon.framework.logger.Logger logger = (org.apache.avalon.framework.logger.Logger)this.m_loggers.get(categoryName);
        if (null != logger) {
            if (this.m_defaultLogger.isDebugEnabled()) {
                this.m_defaultLogger.debug("Logger for category " + categoryName + " returned");
            }
            return logger;
        }
        if (this.m_defaultLogger.isDebugEnabled()) {
            this.m_defaultLogger.debug("Logger for category " + categoryName + " not defined in configuration. New Logger created and returned");
        }
        return new LogKitLogger(this.m_hierarchy.getLoggerFor(categoryName));
    }

    public final org.apache.avalon.framework.logger.Logger getDefaultLogger() {
        return this.m_defaultLogger;
    }

    public final void contextualize(Context context) throws ContextException {
        this.m_context = context;
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        Configuration factories = configuration.getChild("factories");
        LogTargetFactoryManager targetFactoryManager = this.setupTargetFactoryManager(factories);
        Configuration targets = configuration.getChild("targets");
        LogTargetManager targetManager = this.setupTargetManager(targets, targetFactoryManager);
        Configuration categories = configuration.getChild("categories");
        Configuration[] category = categories.getChildren("category");
        this.setupLoggers(targetManager, this.m_prefix, category);
    }

    private final LogTargetFactoryManager setupTargetFactoryManager(Configuration configuration) throws ConfigurationException {
        DefaultLogTargetFactoryManager targetFactoryManager = new DefaultLogTargetFactoryManager();
        if (targetFactoryManager instanceof LogEnabled) {
            targetFactoryManager.enableLogging(this.m_defaultLogger);
        }
        if (targetFactoryManager instanceof Contextualizable) {
            try {
                targetFactoryManager.contextualize(this.m_context);
            }
            catch (ContextException ce) {
                throw new ConfigurationException("cannot contextualize default factory manager", (Throwable)ce);
            }
        }
        targetFactoryManager.configure(configuration);
        return targetFactoryManager;
    }

    private final LogTargetManager setupTargetManager(Configuration configuration, LogTargetFactoryManager targetFactoryManager) throws ConfigurationException {
        DefaultLogTargetManager targetManager = new DefaultLogTargetManager();
        if (targetManager instanceof LogEnabled) {
            targetManager.enableLogging(this.m_defaultLogger);
        }
        if (targetManager instanceof LogTargetFactoryManageable) {
            targetManager.setLogTargetFactoryManager(targetFactoryManager);
        }
        if (targetManager instanceof Configurable) {
            targetManager.configure(configuration);
        }
        return targetManager;
    }

    private final void setupLoggers(LogTargetManager targetManager, String parentCategory, Configuration[] categories) throws ConfigurationException {
        int i = 0;
        while (i < categories.length) {
            String category = categories[i].getAttribute("name");
            String loglevel = categories[i].getAttribute("log-level").toUpperCase();
            Configuration[] targets = categories[i].getChildren("log-target");
            LogTarget[] logTargets = new LogTarget[targets.length];
            int j = 0;
            while (j < targets.length) {
                String id = targets[j].getAttribute("id-ref");
                logTargets[j] = targetManager.getLogTarget(id);
                ++j;
            }
            if ("".equals(category) && logTargets.length > 0) {
                this.m_hierarchy.setDefaultPriority(Priority.getPriorityForName((String)loglevel));
                this.m_hierarchy.setDefaultLogTargets(logTargets);
            }
            String fullCategory = null == parentCategory ? category : parentCategory + '.' + category;
            Logger logger = this.m_hierarchy.getLoggerFor(fullCategory);
            this.m_loggers.put(fullCategory, new LogKitLogger(logger));
            if (this.m_defaultLogger.isDebugEnabled()) {
                this.m_defaultLogger.debug("added logger for category " + fullCategory);
            }
            logger.setPriority(Priority.getPriorityForName((String)loglevel));
            logger.setLogTargets(logTargets);
            Configuration[] subCategories = categories[i].getChildren("category");
            if (null != subCategories) {
                this.setupLoggers(targetManager, fullCategory, subCategories);
            }
            ++i;
        }
    }
}

