/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.logger.factory.AbstractTargetFactory;
import org.apache.avalon.excalibur.logger.factory.FormatterFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.log.LogTarget;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;
import org.apache.log.output.io.rotate.FileStrategy;
import org.apache.log.output.io.rotate.OrRotateStrategy;
import org.apache.log.output.io.rotate.RevolvingFileStrategy;
import org.apache.log.output.io.rotate.RotateStrategy;
import org.apache.log.output.io.rotate.RotateStrategyByDate;
import org.apache.log.output.io.rotate.RotateStrategyBySize;
import org.apache.log.output.io.rotate.RotateStrategyByTime;
import org.apache.log.output.io.rotate.RotatingFileTarget;
import org.apache.log.output.io.rotate.UniqueFileStrategy;

public class FileTargetFactory
extends AbstractTargetFactory {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long KILOBYTE = 1000L;
    private static final long MEGABYTE = 1000000L;

    public final LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        FileTarget logtarget;
        Configuration confFilename = configuration.getChild("filename");
        String filename = this.getFilename(confFilename.getValue());
        Configuration confRotation = configuration.getChild("rotation", false);
        Configuration confFormat = configuration.getChild("format");
        Configuration confAppend = configuration.getChild("append");
        boolean append = confAppend.getValueAsBoolean(false);
        File file = new File(filename);
        Formatter formatter = this.getFormatter(confFormat);
        try {
            if (null == confRotation) {
                logtarget = new FileTarget(file, append, formatter);
            } else {
                Configuration confStrategy = confRotation.getChildren()[0];
                RotateStrategy rotateStrategy = this.getRotateStrategy(confStrategy);
                FileStrategy fileStrategy = this.getFileStrategy(confRotation, file);
                logtarget = new RotatingFileTarget(append, formatter, rotateStrategy, fileStrategy);
            }
        }
        catch (IOException ioe) {
            throw new ConfigurationException("cannot create FileTarget", (Throwable)ioe);
        }
        return logtarget;
    }

    private RotateStrategy getRotateStrategy(Configuration conf) {
        String type = conf.getName();
        if ("or".equals(type)) {
            Configuration[] configurations = conf.getChildren();
            int size = configurations.length;
            RotateStrategy[] strategies = new RotateStrategy[size];
            int i = 0;
            while (i < size) {
                strategies[i] = this.getRotateStrategy(configurations[i]);
                ++i;
            }
            return new OrRotateStrategy(strategies);
        }
        if ("size".equals(type)) {
            long size;
            String value = conf.getValue("2m");
            int count = value.length();
            char end = value.charAt(count - 1);
            switch (end) {
                case 'm': {
                    long no = Long.parseLong(value.substring(0, count - 1));
                    size = no * 1000000L;
                    break;
                }
                case 'k': {
                    long no = Long.parseLong(value.substring(0, count - 1));
                    size = no * 1000L;
                    break;
                }
                default: {
                    size = Long.parseLong(value);
                }
            }
            return new RotateStrategyBySize(size);
        }
        if ("date".equals(type)) {
            String value = conf.getValue("yyyyMMdd");
            return new RotateStrategyByDate(value);
        }
        String value = conf.getValue("24:00:00");
        StringTokenizer tokenizer = new StringTokenizer(value, ":");
        int count = tokenizer.countTokens();
        long time = 0L;
        int i = count;
        while (i > 0) {
            long no = Long.parseLong(tokenizer.nextToken());
            if (4 == i) {
                time += no * 86400000L;
            }
            if (3 == i) {
                time += no * 3600000L;
            }
            if (2 == i) {
                time += no * 60000L;
            }
            if (1 == i) {
                time += no * 1000L;
            }
            --i;
        }
        return new RotateStrategyByTime(time);
    }

    protected FileStrategy getFileStrategy(Configuration conf, File file) {
        String type = conf.getAttribute("type", "unique");
        if ("revolving".equals(type)) {
            int initialRotation = conf.getAttributeAsInteger("init", 5);
            int maxRotation = conf.getAttributeAsInteger("max", 10);
            return new RevolvingFileStrategy(file, initialRotation, maxRotation);
        }
        String pattern = conf.getAttribute("pattern", null);
        String suffix = conf.getAttribute("suffix", null);
        if (pattern == null) {
            return new UniqueFileStrategy(file);
        }
        if (suffix == null) {
            return new UniqueFileStrategy(file, pattern);
        }
        return new UniqueFileStrategy(file, pattern, suffix);
    }

    protected Formatter getFormatter(Configuration conf) {
        Formatter formatter = null;
        if (null != conf) {
            FormatterFactory formatterFactory = new FormatterFactory();
            formatter = formatterFactory.createFormatter(conf);
        }
        return formatter;
    }

    protected final String getFilename(String rawFilename) throws ConfigurationException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = -1;
        while ((j = rawFilename.indexOf("${", i)) > -1) {
            Object ctx;
            if (this.m_context == null) {
                throw new ConfigurationException("Context not available.");
            }
            if (i < j) {
                sb.append(rawFilename.substring(i, j));
            }
            int k = rawFilename.indexOf(125, j);
            String ctxName = rawFilename.substring(j + 2, k);
            try {
                ctx = this.m_context.get((Object)ctxName);
            }
            catch (ContextException ce) {
                throw new ConfigurationException("missing entry '" + ctxName + "' in Context.");
            }
            sb.append(ctx.toString());
            i = k + 1;
        }
        if (i < rawFilename.length()) {
            sb.append(rawFilename.substring(i, rawFilename.length()));
        }
        return sb.toString();
    }

    static {
        SECOND = 1000L;
        MINUTE = 60000L;
        HOUR = 3600000L;
        DAY = 86400000L;
        KILOBYTE = 1000L;
        MEGABYTE = 1000000L;
    }
}

