/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.avalon.excalibur.instrument.CounterInstrument;
import org.apache.avalon.excalibur.instrument.Instrument;
import org.apache.avalon.excalibur.instrument.Instrumentable;
import org.apache.avalon.excalibur.instrument.ValueInstrument;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;

public class ResourceLimitingPool
extends AbstractLogEnabled
implements Pool,
LogEnabled,
Disposable,
ThreadSafe,
Instrumentable {
    public static final String DEFAULT_INSTRUMENTABLE_NAME = "pool";
    public static final String INSTRUMENT_SIZE_NAME = "size";
    public static final String INSTRUMENT_READY_SIZE_NAME = "ready-size";
    public static final String INSTRUMENT_GETS_NAME = "gets";
    public static final String INSTRUMENT_PUTS_NAME = "puts";
    public static final String INSTRUMENT_BLOCKS_NAME = "blocks";
    public static final String INSTRUMENT_CREATES_NAME = "creates";
    public static final String INSTRUMENT_DECOMMISSIONS_NAME = "decommissions";
    protected final Object m_semaphore = new Object();
    private boolean m_disposed = false;
    private final ObjectFactory m_factory;
    private final int m_max;
    private final boolean m_maxStrict;
    private final boolean m_blocking;
    private final long m_blockTimeout;
    private final long m_trimInterval;
    private long m_lastTrim;
    private LinkedList m_ready;
    private int m_readySize;
    private LinkedList m_oldReady;
    private int m_oldReadySize;
    private int m_size;
    private String m_instrumentableName = "pool";
    private ValueInstrument m_sizeInstrument;
    private ValueInstrument m_readySizeInstrument;
    private CounterInstrument m_getsInstrument;
    private CounterInstrument m_putsInstrument;
    private CounterInstrument m_blocksInstrument;
    private CounterInstrument m_createsInstrument;
    private CounterInstrument m_decommissionsInstrument;

    public ResourceLimitingPool(ObjectFactory factory, int max, boolean maxStrict, boolean blocking, long blockTimeout, long trimInterval) {
        this.m_factory = factory;
        this.m_max = max <= 0 ? Integer.MAX_VALUE : max;
        this.m_maxStrict = maxStrict;
        this.m_blocking = blocking;
        this.m_blockTimeout = blockTimeout;
        this.m_trimInterval = trimInterval;
        this.m_ready = new LinkedList();
        if (this.m_trimInterval > 0L) {
            this.m_oldReady = new LinkedList();
        }
        this.m_sizeInstrument = new ValueInstrument(INSTRUMENT_SIZE_NAME);
        this.m_readySizeInstrument = new ValueInstrument(INSTRUMENT_READY_SIZE_NAME);
        this.m_getsInstrument = new CounterInstrument(INSTRUMENT_GETS_NAME);
        this.m_putsInstrument = new CounterInstrument(INSTRUMENT_PUTS_NAME);
        this.m_blocksInstrument = new CounterInstrument(INSTRUMENT_BLOCKS_NAME);
        this.m_createsInstrument = new CounterInstrument(INSTRUMENT_CREATES_NAME);
        this.m_decommissionsInstrument = new CounterInstrument(INSTRUMENT_DECOMMISSIONS_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Poolable get() throws Exception {
        Poolable poolable;
        if (this.m_disposed) {
            throw new IllegalStateException("Already Disposed");
        }
        Object object = this.m_semaphore;
        synchronized (object) {
            if (this.m_oldReady != null && System.currentTimeMillis() - this.m_lastTrim >= this.m_trimInterval) {
                this.trimInner();
            }
            if (this.m_readySize > 0) {
                poolable = (Poolable)this.m_ready.removeLast();
                --this.m_readySize;
            } else if (this.m_oldReadySize > 0) {
                poolable = (Poolable)this.m_oldReady.removeLast();
                --this.m_oldReadySize;
            } else if (this.m_size >= this.m_max && this.m_maxStrict) {
                if (!this.m_blocking) throw new Exception("Could not create enough Components to service your request.");
                long blockStart = System.currentTimeMillis();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Blocking until a Poolable is available. Thread: " + Thread.currentThread().getName());
                }
                this.m_blocksInstrument.increment();
                if (this.m_blockTimeout > 0L) {
                    long blockWait = this.m_blockTimeout;
                    do {
                        if (blockWait > 0L) {
                            try {
                                this.m_semaphore.wait(blockWait);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (this.m_disposed) {
                                throw new IllegalStateException("Already Disposed");
                            }
                            if (this.m_readySize != 0) continue;
                            long now = System.currentTimeMillis();
                            blockWait = this.m_blockTimeout - (now - blockStart);
                            continue;
                        }
                        long now = System.currentTimeMillis();
                        if (!this.getLogger().isDebugEnabled()) throw new Exception("Could not create enough Components to service your request (Timed out).");
                        this.getLogger().debug("Timed out waiting for a Poolable to become available.  Blocked for " + (now - blockStart) + "ms. Thread: " + Thread.currentThread().getName());
                        throw new Exception("Could not create enough Components to service your request (Timed out).");
                    } while (this.m_readySize == 0);
                } else {
                    do {
                        try {
                            this.m_semaphore.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (!this.m_disposed) continue;
                        throw new IllegalStateException("Already Disposed");
                    } while (this.m_readySize == 0);
                }
                poolable = (Poolable)this.m_ready.removeLast();
                --this.m_readySize;
                if (this.getLogger().isDebugEnabled()) {
                    long now = System.currentTimeMillis();
                    this.getLogger().debug("Blocked for " + (now - blockStart) + "ms " + "waiting for a Poolable to become available. " + "Thread: " + Thread.currentThread().getName());
                }
            } else {
                ++this.m_size;
                poolable = this.newPoolable();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Created a new " + poolable.getClass().getName() + " from the object factory.");
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Got a " + poolable.getClass().getName() + " from the pool.");
        }
        this.m_getsInstrument.increment();
        if (!this.m_readySizeInstrument.isActive()) return poolable;
        this.m_readySizeInstrument.setValue(this.getReadySize());
        return poolable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Poolable poolable) {
        if (poolable instanceof Recyclable) {
            ((Recyclable)poolable).recycle();
        }
        Object object = this.m_semaphore;
        synchronized (object) {
            if (this.m_size <= this.m_max) {
                if (this.m_disposed) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Put called for a " + poolable.getClass().getName() + " after the pool was disposed.");
                    }
                    this.permanentlyRemovePoolable(poolable);
                } else {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Put a " + poolable.getClass().getName() + " back into the pool.");
                    }
                    this.m_ready.addLast(poolable);
                    ++this.m_readySize;
                    if (this.m_blocking) {
                        this.m_semaphore.notify();
                    }
                }
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("No room to put a " + poolable.getClass().getName() + " back into the pool, so remove it.");
                }
                this.permanentlyRemovePoolable(poolable);
            }
        }
        this.m_putsInstrument.increment();
        if (this.m_readySizeInstrument.isActive()) {
            this.m_readySizeInstrument.setValue(this.getReadySize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.m_disposed = true;
        Object object = this.m_semaphore;
        synchronized (object) {
            Iterator iter = this.m_ready.iterator();
            while (iter.hasNext()) {
                Poolable poolable = (Poolable)iter.next();
                iter.remove();
                --this.m_readySize;
                this.permanentlyRemovePoolable(poolable);
            }
            if (this.m_oldReady != null) {
                Iterator iter2 = this.m_oldReady.iterator();
                while (iter2.hasNext()) {
                    Poolable poolable = (Poolable)iter2.next();
                    iter2.remove();
                    --this.m_oldReadySize;
                    this.permanentlyRemovePoolable(poolable);
                }
            }
            if (this.m_blocking) {
                this.m_semaphore.notifyAll();
            }
            if (this.m_size > 0 && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("There were " + this.m_size + " outstanding objects when the pool was disposed.");
            }
            if (this.m_sizeInstrument.isActive()) {
                this.m_sizeInstrument.setValue(this.getSize());
            }
            if (this.m_readySizeInstrument.isActive()) {
                this.m_readySizeInstrument.setValue(this.getReadySize());
            }
        }
    }

    public void setInstrumentableName(String name) {
        this.m_instrumentableName = name;
    }

    public String getInstrumentableName() {
        return this.m_instrumentableName;
    }

    public Instrument[] getInstruments() {
        return new Instrument[]{this.m_sizeInstrument, this.m_readySizeInstrument, this.m_getsInstrument, this.m_putsInstrument, this.m_blocksInstrument, this.m_createsInstrument, this.m_decommissionsInstrument};
    }

    public Instrumentable[] getChildInstrumentables() {
        return Instrumentable.EMPTY_INSTRUMENTABLE_ARRAY;
    }

    protected void permanentlyRemovePoolable(Poolable poolable) {
        --this.m_size;
        this.removePoolable(poolable);
    }

    public int getSize() {
        return this.m_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadySize() {
        Object object = this.m_semaphore;
        synchronized (object) {
            int n = this.m_readySize + this.m_oldReadySize;
            return n;
        }
    }

    protected Poolable newPoolable() throws Exception {
        Object obj = this.m_factory.newInstance();
        this.m_createsInstrument.increment();
        if (this.m_sizeInstrument.isActive()) {
            this.m_sizeInstrument.setValue(this.getSize());
        }
        return (Poolable)obj;
    }

    protected void removePoolable(Poolable poolable) {
        block3: {
            try {
                this.m_factory.decommission(poolable);
                this.m_decommissionsInstrument.increment();
                if (this.m_sizeInstrument.isActive()) {
                    this.m_sizeInstrument.setValue(this.getSize());
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isDebugEnabled()) break block3;
                this.getLogger().debug("Error decommissioning object", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int trim() {
        if (this.m_oldReady != null) {
            Object object = this.m_semaphore;
            synchronized (object) {
                int n = this.trimInner();
                return n;
            }
        }
        throw new IllegalStateException("This pool is not configured to do trimming.");
    }

    private int trimInner() {
        int trimCount = 0;
        if (this.m_oldReadySize > 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Trimming " + this.m_oldReadySize + " idle objects from pool.");
            }
            trimCount = this.m_oldReadySize;
            Iterator iter = this.m_oldReady.iterator();
            while (iter.hasNext()) {
                Poolable poolable = (Poolable)iter.next();
                iter.remove();
                --this.m_oldReadySize;
                this.permanentlyRemovePoolable(poolable);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Marking " + this.m_readySize + " objects as old in pool.");
        }
        LinkedList tempList = this.m_oldReady;
        this.m_oldReady = this.m_ready;
        this.m_oldReadySize = this.m_readySize;
        this.m_ready = tempList;
        this.m_readySize = 0;
        this.m_lastTrim = System.currentTimeMillis();
        return trimCount;
    }

    static {
        DEFAULT_INSTRUMENTABLE_NAME = DEFAULT_INSTRUMENTABLE_NAME;
        INSTRUMENT_SIZE_NAME = INSTRUMENT_SIZE_NAME;
        INSTRUMENT_READY_SIZE_NAME = INSTRUMENT_READY_SIZE_NAME;
        INSTRUMENT_GETS_NAME = INSTRUMENT_GETS_NAME;
        INSTRUMENT_PUTS_NAME = INSTRUMENT_PUTS_NAME;
        INSTRUMENT_BLOCKS_NAME = INSTRUMENT_BLOCKS_NAME;
        INSTRUMENT_CREATES_NAME = INSTRUMENT_CREATES_NAME;
        INSTRUMENT_DECOMMISSIONS_NAME = INSTRUMENT_DECOMMISSIONS_NAME;
    }
}

