/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.testcase;

import org.apache.avalon.excalibur.testcase.CascadingAssertionFailedError;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class LatchedThreadGroup
extends AbstractLogEnabled {
    private Thread[] m_threads;
    private Object m_semaphore = new Object();
    private int m_startedCount;
    private boolean m_latched;
    private int m_completedCount;
    private int m_getCount;
    private Throwable m_exception;

    public LatchedThreadGroup(Runnable[] runnables) {
        int threadCount = runnables.length;
        this.m_threads = new Thread[threadCount];
        int i = 0;
        while (i < threadCount) {
            this.m_threads[i] = new Runner(runnables[i], "Latched_Thread_" + i);
            ++i;
        }
    }

    public LatchedThreadGroup(Runnable runnable, int threadCount) {
        this.m_threads = new Thread[threadCount];
        int i = 0;
        while (i < threadCount) {
            this.m_threads[i] = new Runner(runnable, "Latched_Thread_" + i);
            ++i;
        }
    }

    protected void resetMemory() {
        System.gc();
        System.gc();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Runtime runtime = Runtime.getRuntime();
        this.getLogger().debug("Memory: " + (runtime.totalMemory() - runtime.freeMemory()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long go() throws Exception {
        int threadCount = this.m_threads.length;
        int i = 0;
        while (i < threadCount) {
            this.m_threads[i].start();
            ++i;
        }
        Object object = this.m_semaphore;
        synchronized (object) {
            while (this.m_startedCount < threadCount) {
                this.m_semaphore.wait();
            }
            this.resetMemory();
            this.m_latched = true;
            this.getLogger().debug("Main thread released the test thread latch.");
            this.m_semaphore.notifyAll();
        }
        long startTime = System.currentTimeMillis();
        Object object2 = this.m_semaphore;
        synchronized (object2) {
            this.getLogger().debug("Waiting for test threads to all complete.");
            while (this.m_completedCount < threadCount) {
                try {
                    this.m_semaphore.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        this.getLogger().debug("All test threads completed.");
        if (this.m_exception != null) {
            throw new CascadingAssertionFailedError("Exception in test thread.", this.m_exception);
        }
        return duration;
    }

    private Logger getInnerLogger() {
        return this.getLogger();
    }

    private class Runner
    extends Thread {
        private Runnable m_runnable;

        protected Runner(Runnable runnable, String name) {
            super(name);
            this.m_runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = LatchedThreadGroup.this.m_semaphore;
                synchronized (object) {
                    LatchedThreadGroup.this.m_startedCount++;
                    LatchedThreadGroup.this.getInnerLogger().debug("Started " + LatchedThreadGroup.this.m_startedCount + " test threads.");
                    if (LatchedThreadGroup.this.m_startedCount >= LatchedThreadGroup.this.m_threads.length) {
                        LatchedThreadGroup.this.m_semaphore.notifyAll();
                    }
                    while (!LatchedThreadGroup.this.m_latched) {
                        try {
                            LatchedThreadGroup.this.m_semaphore.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                try {
                    this.m_runnable.run();
                }
                catch (Throwable t) {
                    Object object2 = LatchedThreadGroup.this.m_semaphore;
                    synchronized (object2) {
                        LatchedThreadGroup.this.getInnerLogger().error("Error in " + Thread.currentThread().getName(), t);
                        if (LatchedThreadGroup.this.m_exception != null) {
                            LatchedThreadGroup.this.m_exception = t;
                        }
                    }
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                Object object = LatchedThreadGroup.this.m_semaphore;
                synchronized (object) {
                    LatchedThreadGroup.this.m_completedCount++;
                    LatchedThreadGroup.this.getInnerLogger().debug(LatchedThreadGroup.this.m_completedCount + " test threads completed.");
                    LatchedThreadGroup.this.m_semaphore.notifyAll();
                }
                throw throwable;
            }
            Object object = LatchedThreadGroup.this.m_semaphore;
            synchronized (object) {
                LatchedThreadGroup.this.m_completedCount++;
                LatchedThreadGroup.this.getInnerLogger().debug(LatchedThreadGroup.this.m_completedCount + " test threads completed.");
                LatchedThreadGroup.this.m_semaphore.notifyAll();
            }
        }
    }
}

