/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.xml;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.xml.EntityResolver;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class JaxpParser
extends AbstractLogEnabled
implements Parser,
ErrorHandler,
Composable,
Parameterizable,
Poolable {
    protected SAXParserFactory factory;
    protected DocumentBuilderFactory docFactory;
    protected XMLReader reader;
    protected DocumentBuilder docBuilder;
    protected ComponentManager manager;
    protected EntityResolver resolver;
    protected boolean nsPrefixes;
    protected boolean reuseParsers;
    protected boolean stopOnWarning;
    protected boolean stopOnRecoverableError;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        if (this.manager.hasComponent(EntityResolver.ROLE)) {
            this.resolver = (EntityResolver)this.manager.lookup(EntityResolver.ROLE);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("JaxpParser: Using EntityResolver: " + this.resolver);
            }
        }
    }

    public void parameterize(Parameters params) throws ParameterException {
        boolean validate = params.getParameterAsBoolean("validate", false);
        this.nsPrefixes = params.getParameterAsBoolean("namespace-prefixes", false);
        this.reuseParsers = params.getParameterAsBoolean("reuse-parsers", true);
        this.stopOnWarning = params.getParameterAsBoolean("stop-on-warning", true);
        this.stopOnRecoverableError = params.getParameterAsBoolean("stop-on-recoverable-error", true);
        String saxParserFactoryName = params.getParameter("sax-parser-factory", "javax.xml.parsers.SAXParserFactory");
        if ("javax.xml.parsers.SAXParserFactory".equals(saxParserFactoryName)) {
            this.factory = SAXParserFactory.newInstance();
        } else {
            try {
                Class factoryClass = this.loadClass(saxParserFactoryName);
                this.factory = (SAXParserFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                throw new ParameterException("Cannot load SAXParserFactory class " + saxParserFactoryName, (Throwable)e);
            }
        }
        this.factory.setNamespaceAware(true);
        this.factory.setValidating(validate);
        String documentBuilderFactoryName = params.getParameter("document-builder-factory", "javax.xml.parsers.DocumentBuilderFactory");
        if ("javax.xml.parsers.DocumentBuilderFactory".equals(documentBuilderFactoryName)) {
            this.docFactory = DocumentBuilderFactory.newInstance();
        } else {
            try {
                Class factoryClass = this.loadClass(documentBuilderFactoryName);
                this.docFactory = (DocumentBuilderFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                throw new ParameterException("Cannot load DocumentBuilderFactory class " + documentBuilderFactoryName, (Throwable)e);
            }
        }
        this.docFactory.setNamespaceAware(true);
        this.docFactory.setValidating(validate);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("JaxpParser: validating: " + validate + ", namespace-prefixes: " + this.nsPrefixes + ", reuse parser: " + this.reuseParsers + ", stop on warning: " + this.stopOnWarning + ", stop on recoverable-error: " + this.stopOnRecoverableError + ", saxParserFactory: " + saxParserFactoryName + ", documentBuilderFactory: " + documentBuilderFactoryName);
        }
    }

    protected Class loadClass(String name) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader.loadClass(name);
    }

    public void parse(InputSource in, ContentHandler consumer) throws SAXException, IOException {
        if (consumer instanceof LexicalHandler) {
            this.parse(in, consumer, (LexicalHandler)((Object)consumer));
        } else {
            this.parse(in, consumer, null);
        }
    }

    public void parse(InputSource in, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException, IOException {
        this.setupXMLReader();
        XMLReader tmpReader = this.reader;
        this.reader = null;
        try {
            if (null != lexicalHandler) {
                tmpReader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
            }
        }
        catch (SAXException e) {
            this.getLogger().warn("SAX2 driver does not support property: 'http://xml.org/sax/properties/lexical-handler'");
        }
        tmpReader.setErrorHandler(this);
        tmpReader.setContentHandler(contentHandler);
        if (null != this.resolver) {
            tmpReader.setEntityResolver(this.resolver);
        }
        tmpReader.parse(in);
        if (this.reuseParsers) {
            this.reader = tmpReader;
        }
    }

    public Document parseDocument(InputSource input) throws SAXException, IOException {
        this.setupDocumentBuilder();
        DocumentBuilder tmpBuilder = this.docBuilder;
        this.docBuilder = null;
        if (null != this.resolver) {
            tmpBuilder.setEntityResolver(this.resolver);
        }
        Document result = tmpBuilder.parse(input);
        if (this.reuseParsers) {
            this.docBuilder = tmpBuilder;
        }
        return result;
    }

    protected void setupXMLReader() throws SAXException {
        if (null == this.reader) {
            try {
                this.reader = this.factory.newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException pce) {
                throw new SAXException("Cannot produce a valid parser", pce);
            }
            if (this.nsPrefixes) {
                try {
                    this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", this.nsPrefixes);
                }
                catch (SAXException e) {
                    this.getLogger().warn("SAX2 XMLReader does not support setting feature: 'http://xml.org/sax/features/namespace-prefixes'");
                }
            }
        }
    }

    protected void setupDocumentBuilder() throws SAXException {
        if (null == this.docBuilder) {
            try {
                this.docBuilder = this.docFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                throw new SAXException("Could not create DocumentBuilder", pce);
            }
        }
    }

    public Document createDocument() throws SAXException {
        this.setupDocumentBuilder();
        return this.docBuilder.newDocument();
    }

    public void error(SAXParseException e) throws SAXException {
        String msg = "Error parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage();
        if (this.stopOnRecoverableError) {
            throw new SAXException(msg, e);
        }
        this.getLogger().error(msg, (Throwable)e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException("Fatal error parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }

    public void warning(SAXParseException e) throws SAXException {
        String msg = "Warning parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage();
        if (this.stopOnWarning) {
            throw new SAXException(msg, e);
        }
        this.getLogger().warn(msg, (Throwable)e);
    }
}

