/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.xml;

import java.io.IOException;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.SingleThreaded;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class XercesParser
extends AbstractLogEnabled
implements Parser,
ErrorHandler,
SingleThreaded {
    final SAXParser parser = new SAXParser();

    public XercesParser() throws SAXException {
        this.parser.setFeature("http://xml.org/sax/features/validation", false);
        this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
        this.parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
    }

    public void parse(InputSource in, ContentHandler consumer) throws SAXException, IOException {
        if (consumer instanceof LexicalHandler) {
            this.parse(in, consumer, (LexicalHandler)((Object)consumer));
        } else {
            this.parse(in, consumer, null);
        }
    }

    public void parse(InputSource in, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException, IOException {
        if (null != lexicalHandler) {
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)lexicalHandler);
        }
        this.parser.setErrorHandler((ErrorHandler)this);
        this.parser.setContentHandler(contentHandler);
        this.parser.parse(in);
    }

    public Document parseDocument(InputSource input) throws SAXException, IOException {
        DOMParser parser = null;
        try {
            parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            parser.parse(input);
        }
        catch (Exception pce) {
            this.getLogger().error("Could not build DocumentBuilder", (Throwable)pce);
            return null;
        }
        return parser.getDocument();
    }

    public Document createDocument() throws SAXException {
        return new DocumentImpl();
    }

    public void error(SAXParseException e) throws SAXException {
        throw new SAXException("Error parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException("Fatal error parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }

    public void warning(SAXParseException e) throws SAXException {
        throw new SAXException("Warning parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }
}

