/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.xml.xslt;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.logger.Logger;

public class TraxErrorHandler
implements ErrorListener {
    private Logger logger = null;

    public TraxErrorHandler(Logger logger) {
        this.logger = logger;
    }

    public void warning(TransformerException exception) throws TransformerException {
        String message = this.getMessage(exception);
        if (this.logger != null) {
            this.logger.warn(message, (Throwable)exception);
        } else {
            System.out.println("WARNING: " + message);
        }
    }

    public void error(TransformerException exception) throws TransformerException {
        String message = this.getMessage(exception);
        if (this.logger != null) {
            this.logger.error(message, (Throwable)exception);
        } else {
            System.out.println("ERROR: " + message);
        }
    }

    public void fatalError(TransformerException exception) throws TransformerException {
        String message = this.getMessage(exception);
        if (this.logger != null) {
            this.logger.fatalError(message, (Throwable)exception);
        } else {
            System.out.println("FATAL-ERROR: " + message);
        }
        throw exception;
    }

    private String getMessage(TransformerException exception) {
        SourceLocator locator = exception.getLocator();
        if (null != locator) {
            String id = locator.getPublicId() != locator.getPublicId() ? locator.getPublicId() : (null != locator.getSystemId() ? locator.getSystemId() : "SystemId Unknown");
            return "Error in TraxTransformer: " + id + "; Line " + locator.getLineNumber() + "; Column " + locator.getColumnNumber() + "; ";
        }
        return "Error in TraxTransformer: " + exception;
    }
}

