/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.xml.xslt;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.excalibur.xml.XMLizable;
import org.apache.avalon.excalibur.xml.xslt.TraxErrorHandler;
import org.apache.avalon.excalibur.xml.xslt.XSLTProcessor;
import org.apache.avalon.excalibur.xml.xslt.XSLTProcessorException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.xmlizer.XMLizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class XSLTProcessorImpl
extends AbstractLogEnabled
implements XSLTProcessor,
Composable,
Disposable,
Parameterizable,
URIResolver {
    protected ComponentManager manager;
    protected Store store;
    protected HashMap factories;
    protected SAXTransformerFactory factory;
    protected boolean useStore = false;
    protected boolean incrementalProcessing = false;
    protected SourceResolver resolver;
    protected TraxErrorHandler errorHandler;
    protected Map includesMap = new HashMap();

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.errorHandler = new TraxErrorHandler(this.getLogger());
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void dispose() {
        if (null != this.manager) {
            this.manager.release((Component)this.store);
            this.store = null;
            this.manager.release((Component)this.resolver);
            this.resolver = null;
        }
        this.errorHandler = null;
        this.manager = null;
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.useStore = params.getParameterAsBoolean("use-store", this.useStore);
        this.incrementalProcessing = params.getParameterAsBoolean("incremental-processing", this.incrementalProcessing);
        this.factory = this.getTransformerFactory(params.getParameter("transformer-factory", null));
        if (this.useStore) {
            try {
                this.store = (Store)this.manager.lookup(Store.TRANSIENT_STORE);
            }
            catch (ComponentException ce) {
                throw new ParameterException("XSLTProcessor: use-store is set to true, but the lookup of the Store failed.", (Throwable)ce);
            }
        }
    }

    public void setTransformerFactory(String classname) {
        this.factory = this.getTransformerFactory(classname);
    }

    public TransformerHandler getTransformerHandler(Source stylesheet) throws XSLTProcessorException {
        return this.getTransformerHandler(stylesheet, null);
    }

    public TransformerHandler getTransformerHandler(Source stylesheet, XMLFilter filter) throws XSLTProcessorException {
        return this.getTransformerHandlerAndValidity(stylesheet, filter).getTransfomerHandler();
    }

    public XSLTProcessor.TransformerHandlerAndValidity getTransformerHandlerAndValidity(Source stylesheet) throws XSLTProcessorException {
        return this.getTransformerHandlerAndValidity(stylesheet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSLTProcessor.TransformerHandlerAndValidity getTransformerHandlerAndValidity(Source stylesheet, XMLFilter filter) throws XSLTProcessorException {
        try {
            XSLTProcessor.TransformerHandlerAndValidity handlerAndValidity;
            block14: {
                String id = stylesheet.getSystemId();
                handlerAndValidity = this.getTemplates(stylesheet, id);
                if (handlerAndValidity == null) {
                    SourceValidity validity;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Creating new Templates for " + id);
                    }
                    TemplatesHandler templatesHandler = this.factory.newTemplatesHandler();
                    templatesHandler.setSystemId(id);
                    if (filter != null) {
                        filter.setContentHandler(templatesHandler);
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Source = " + stylesheet + ", templatesHandler = " + templatesHandler);
                    }
                    if ((validity = stylesheet.getValidity()) != null) {
                        this.includesMap.put(id, new ArrayList());
                    }
                    try {
                        List includes;
                        this.sourceToSAX(stylesheet, filter != null ? (ContentHandler)((Object)filter) : templatesHandler);
                        Templates t = templatesHandler.getTemplates();
                        this.putTemplates(t, stylesheet, id);
                        TransformerHandler handler = this.factory.newTransformerHandler(t);
                        handler.getTransformer().setErrorListener(this.errorHandler);
                        AggregatedValidity aggregated = null;
                        if (validity != null && (includes = (List)this.includesMap.get(id)) != null) {
                            aggregated = new AggregatedValidity();
                            aggregated.add(validity);
                            int i = includes.size() - 1;
                            while (i >= 0) {
                                aggregated.add((SourceValidity)((Object[])includes.get(i))[1]);
                                --i;
                            }
                        }
                        handlerAndValidity = new XSLTProcessor.TransformerHandlerAndValidity(handler, aggregated);
                        Object var13_14 = null;
                        this.includesMap.remove(id);
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        this.includesMap.remove(id);
                        throw throwable;
                    }
                    {
                        break block14;
                    }
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Reusing Templates for " + id);
                }
            }
            return handlerAndValidity;
        }
        catch (SAXException e) {
            if (e.getException() == null) {
                throw new XSLTProcessorException("Exception in creating Transform Handler", e);
            }
            this.getLogger().debug("Got SAXException. Rethrowing cause exception.", (Throwable)e);
            throw new XSLTProcessorException("Exception in creating Transform Handler", e.getException());
        }
        catch (Exception e) {
            throw new XSLTProcessorException("Exception in creating Transform Handler", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sourceToSAX(Source source, ContentHandler handler) throws SAXException, IOException, ComponentException, SourceException {
        if (source instanceof XMLizable) {
            ((XMLizable)((Object)source)).toSAX(handler);
        } else {
            XMLizer xmlizer = null;
            try {
                xmlizer = (XMLizer)this.manager.lookup(XMLizer.ROLE);
                xmlizer.toSAX(source.getInputStream(), source.getMimeType(), source.getSystemId(), handler);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.manager.release((Component)xmlizer);
                throw throwable;
            }
            this.manager.release((Component)xmlizer);
            {
            }
        }
    }

    public void transform(Source source, Source stylesheet, Parameters params, Result result) throws XSLTProcessorException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Transform source = " + source + ", stylesheet = " + stylesheet + ", parameters = " + params + ", result = " + result);
            }
            TransformerHandler handler = this.getTransformerHandler(stylesheet);
            if (params != null) {
                Transformer transformer = handler.getTransformer();
                transformer.clearParameters();
                String[] names = params.getNames();
                int i = names.length - 1;
                while (i >= 0) {
                    transformer.setParameter(names[i], params.getParameter(names[i]));
                    --i;
                }
            }
            handler.setResult(result);
            this.sourceToSAX(source, handler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Transform done");
            }
        }
        catch (SAXException e) {
            if (e.getException() == null) {
                throw new XSLTProcessorException("Error in running Transformation", e);
            }
            this.getLogger().debug("Got SAXException. Rethrowing cause exception.", (Throwable)e);
            throw new XSLTProcessorException("Error in running Transformation", e.getException());
        }
        catch (Exception e) {
            throw new XSLTProcessorException("Error in running Transformation", e);
        }
    }

    private SAXTransformerFactory getTransformerFactory(String factoryName) {
        SAXTransformerFactory _factory;
        if (null == factoryName) {
            _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        } else {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = this.getClass().getClassLoader();
                }
                _factory = (SAXTransformerFactory)loader.loadClass(factoryName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                this.getLogger().error("Cannot find the requested TrAX factory '" + factoryName + "'. Using default TrAX Transformer Factory instead.");
                if (this.factory != null) {
                    return this.factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (ClassCastException cce) {
                this.getLogger().error("The indicated class '" + factoryName + "' is not a TrAX Transformer Factory. Using default TrAX Transformer Factory instead.");
                if (this.factory != null) {
                    return this.factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (Exception e) {
                this.getLogger().error("Error found loading the requested TrAX Transformer Factory '" + factoryName + "'. Using default TrAX Transformer Factory instead.");
                if (this.factory != null) {
                    return this.factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
        }
        _factory.setErrorListener(this.errorHandler);
        _factory.setURIResolver(this);
        if (_factory.getClass().getName().equals("org.apache.xalan.processor.TransformerFactoryImpl")) {
            _factory.setAttribute("http://xml.apache.org/xalan/features/incremental", new Boolean(this.incrementalProcessing));
        }
        return _factory;
    }

    private XSLTProcessor.TransformerHandlerAndValidity getTemplates(Source stylesheet, String id) throws IOException, SourceException, TransformerException {
        boolean isValid;
        SourceValidity newValidity;
        if (!this.useStore) {
            return null;
        }
        String key = id + this.factory.getClass().getName();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("getTemplates: stylesheet " + id);
        }
        if ((newValidity = stylesheet.getValidity()) == null) {
            this.store.remove(key);
            return null;
        }
        Object[] templateAndValidityAndIncludes = (Object[])this.store.get(key);
        if (templateAndValidityAndIncludes == null) {
            return null;
        }
        SourceValidity storedValidity = (SourceValidity)templateAndValidityAndIncludes[1];
        int valid = storedValidity.isValid();
        if (valid == 0) {
            isValid = storedValidity.isValid(newValidity);
        } else {
            boolean bl = isValid = valid == 1;
        }
        if (!isValid) {
            this.store.remove(key);
            return null;
        }
        AggregatedValidity aggregated = null;
        List includes = (List)templateAndValidityAndIncludes[2];
        if (includes != null) {
            aggregated = new AggregatedValidity();
            aggregated.add(storedValidity);
            int i = includes.size() - 1;
            while (i >= 0) {
                Object[] pair = (Object[])includes.get(i);
                storedValidity = (SourceValidity)pair[1];
                aggregated.add(storedValidity);
                valid = storedValidity.isValid();
                isValid = false;
                if (valid == 0) {
                    SourceValidity included = this.resolver.resolveURI((String)pair[0]).getValidity();
                    if (included != null) {
                        isValid = storedValidity.isValid(included);
                    }
                } else {
                    boolean bl = isValid = valid == 1;
                }
                if (!isValid) {
                    this.store.remove(key);
                    return null;
                }
                --i;
            }
        }
        TransformerHandler handler = this.factory.newTransformerHandler((Templates)templateAndValidityAndIncludes[0]);
        handler.getTransformer().setErrorListener(this.errorHandler);
        return new XSLTProcessor.TransformerHandlerAndValidity(handler, aggregated);
    }

    private void putTemplates(Templates templates, Source stylesheet, String id) throws IOException {
        if (!this.useStore) {
            return;
        }
        String key = id + this.factory.getClass().getName();
        SourceValidity validity = stylesheet.getValidity();
        if (null != validity) {
            Object[] templateAndValidityAndIncludes = new Object[]{templates, validity, this.includesMap.get(id)};
            this.store.store(key, templateAndValidityAndIncludes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public javax.xml.transform.Source resolve(String href, String base) throws TransformerException {
        Object included2;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("resolve(href = " + href + ", base = " + base + "); resolver = " + this.resolver);
        }
        Source xslSource = null;
        try {
            try {
                List includes;
                if (base == null || href.indexOf(":") > 1) {
                    xslSource = this.resolver.resolveURI(href);
                } else if (href.length() == 0) {
                    xslSource = this.resolver.resolveURI(base);
                } else if (!base.startsWith("file:")) {
                    int lastPathElementPos = base.lastIndexOf(47);
                    if (lastPathElementPos == -1) {
                        javax.xml.transform.Source source = null;
                        Object var9_12 = null;
                        this.resolver.release(xslSource);
                        return source;
                    }
                    xslSource = this.resolver.resolveURI(base.substring(0, lastPathElementPos) + "/" + href);
                } else {
                    File parent = new File(base.substring(5));
                    File parent2 = new File(parent.getParentFile(), href);
                    xslSource = this.resolver.resolveURI(parent2.toURL().toExternalForm());
                }
                InputSource is = XSLTProcessorImpl.getInputSource(xslSource);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("xslSource = " + xslSource + ", system id = " + xslSource.getSystemId());
                }
                if ((includes = (List)this.includesMap.get(base)) != null) {
                    included2 = xslSource.getValidity();
                    if (included2 != null) {
                        includes.add(new Object[]{xslSource.getSystemId(), xslSource.getValidity()});
                    } else {
                        this.includesMap.remove(base);
                    }
                }
                included2 = new StreamSource(is.getByteStream(), is.getSystemId());
            }
            catch (SourceException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)((Object)e));
                }
                javax.xml.transform.Source includes = null;
                Object var9_14 = null;
                this.resolver.release(xslSource);
                return includes;
            }
            catch (MalformedURLException mue) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)mue);
                }
                javax.xml.transform.Source included2 = null;
                Object var9_15 = null;
                this.resolver.release(xslSource);
                return included2;
            }
            catch (IOException ioe) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)ioe);
                }
                javax.xml.transform.Source source = null;
                Object var9_16 = null;
                this.resolver.release(xslSource);
                return source;
            }
        }
        catch (Throwable throwable) {
            Object var9_17 = null;
            this.resolver.release(xslSource);
            throw throwable;
        }
        Object var9_13 = null;
        this.resolver.release(xslSource);
        return included2;
    }

    private static InputSource getInputSource(Source source) throws IOException, SourceException {
        InputSource newObject = new InputSource(source.getInputStream());
        newObject.setSystemId(source.getSystemId());
        return newObject;
    }
}

