/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.AbstractSource;
import org.apache.excalibur.source.impl.validity.FileTimeStampValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;

public class URLSource
extends AbstractSource
implements Source {
    public static final String HTTP_METHOD = "org.apache.avalon.excalibur.source.Source.http.method";
    public static final String REQUEST_PARAMETERS = "org.apache.avalon.excalibur.source.Source.request.parameters";
    protected final String FILE = "file:";
    protected URL url;
    protected URLConnection connection;
    protected File file;
    protected SourceParameters parameters;
    protected boolean isPost = false;
    protected SourceValidity cachedValidity;
    protected long cachedLastModificationDate;
    private static boolean checkedURLClass;
    private static boolean urlSupportsGetUserInfo;
    private static Method urlGetUserInfo;
    private static Object[] emptyParams;
    static /* synthetic */ Class class$java$net$URL;

    public void init(URL url, Map parameters) throws IOException {
        this.systemId = url.toExternalForm();
        this.file = this.systemId.startsWith("file:") ? new File(this.systemId.substring("file:".length())) : null;
        this.url = url;
        this.gotInfos = false;
        this.isPost = false;
        if (null != parameters) {
            this.parameters = (SourceParameters)parameters.get(REQUEST_PARAMETERS);
            String method = (String)parameters.get(HTTP_METHOD);
            if ("POST".equalsIgnoreCase(method)) {
                this.isPost = true;
            }
        }
        if (null == this.file && null != this.parameters && this.parameters.hasParameters() && !this.isPost) {
            boolean first;
            StringBuffer urlBuffer = new StringBuffer(this.systemId);
            Iterator i = this.parameters.getParameterNames();
            boolean bl = first = this.systemId.indexOf(63) == -1;
            if (first) {
                urlBuffer.append('?');
            }
            while (i.hasNext()) {
                String key = (String)i.next();
                Iterator values = this.parameters.getParameterValues(key);
                while (values.hasNext()) {
                    String value = SourceUtil.encode((String)values.next());
                    if (!first) {
                        urlBuffer.append('&');
                    }
                    first = false;
                    urlBuffer.append(key);
                    urlBuffer.append('=');
                    urlBuffer.append(value);
                }
            }
            this.url = new URL(urlBuffer.toString());
            this.parameters = null;
        }
    }

    protected void getInfos() {
        if (null != this.file) {
            this.lastModificationDate = this.file.lastModified();
            this.contentLength = this.file.length();
        } else if (!this.isPost) {
            try {
                if (null == this.connection) {
                    this.connection = this.url.openConnection();
                    String userInfo = this.getUserInfo();
                    if (this.url.getProtocol().startsWith("http") && userInfo != null) {
                        this.connection.setRequestProperty("Authorization", "Basic " + SourceUtil.encodeBASE64(userInfo));
                    }
                }
                this.lastModificationDate = this.connection.getLastModified();
                this.contentLength = this.connection.getContentLength();
            }
            catch (IOException ignore) {
                super.getInfos();
            }
        } else {
            super.getInfos();
        }
    }

    public InputStream getInputStream() throws IOException, SourceException {
        try {
            this.checkInfos();
            InputStream input = null;
            if (null != this.file) {
                input = new FileInputStream(this.file);
            } else {
                if (this.connection == null) {
                    this.connection = this.url.openConnection();
                    String userInfo = this.getUserInfo();
                    if (this.url.getProtocol().startsWith("http") && userInfo != null) {
                        this.connection.setRequestProperty("Authorization", "Basic " + SourceUtil.encodeBASE64(userInfo));
                    }
                    if (this.connection instanceof HttpURLConnection && this.isPost) {
                        StringBuffer buffer = new StringBuffer(2000);
                        Iterator i = this.parameters.getParameterNames();
                        boolean first = true;
                        while (i.hasNext()) {
                            String key = (String)i.next();
                            Iterator values = this.parameters.getParameterValues(key);
                            while (values.hasNext()) {
                                String value = SourceUtil.encode((String)values.next());
                                if (!first) {
                                    buffer.append('&');
                                }
                                first = false;
                                buffer.append(key.toString());
                                buffer.append('=');
                                buffer.append(value);
                            }
                        }
                        HttpURLConnection httpCon = (HttpURLConnection)this.connection;
                        httpCon.setDoInput(true);
                        if (buffer.length() > 1) {
                            String postString = buffer.toString();
                            httpCon.setRequestMethod("POST");
                            httpCon.setDoOutput(true);
                            httpCon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                            httpCon.setRequestProperty("Content-length", Integer.toString(postString.length()));
                            BufferedOutputStream out = new BufferedOutputStream(httpCon.getOutputStream());
                            ((OutputStream)out).write(postString.getBytes());
                            ((OutputStream)out).close();
                        }
                        input = httpCon.getInputStream();
                        this.connection = null;
                        return input;
                    }
                }
                input = this.connection.getInputStream();
                this.connection = null;
            }
            return input;
        }
        catch (FileNotFoundException fnfe) {
            throw new SourceNotFoundException("Resource not found " + this.systemId);
        }
    }

    protected String getUserInfo() {
        if (checkedURLClass) {
            if (urlSupportsGetUserInfo) {
                try {
                    return (String)urlGetUserInfo.invoke((Object)this.url, emptyParams);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return null;
        }
        try {
            urlGetUserInfo = (class$java$net$URL == null ? (class$java$net$URL = URLSource.class$("java.net.URL")) : class$java$net$URL).getMethod("getUserInfo", null);
            String ui = (String)urlGetUserInfo.invoke((Object)this.url, emptyParams);
            checkedURLClass = true;
            urlSupportsGetUserInfo = true;
            return ui;
        }
        catch (Exception exception) {
            checkedURLClass = true;
            urlSupportsGetUserInfo = false;
            urlGetUserInfo = null;
            return null;
        }
    }

    public SourceValidity getValidity() {
        long lm = this.getLastModified();
        if (lm > 0L) {
            if (lm == this.cachedLastModificationDate) {
                return this.cachedValidity;
            }
            this.cachedLastModificationDate = lm;
            this.cachedValidity = this.file != null ? new FileTimeStampValidity(this.file, lm) : new TimeStampValidity(lm);
            return this.cachedValidity;
        }
        return null;
    }

    public void discardValidity() {
        this.connection = null;
        super.discardValidity();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HTTP_METHOD = HTTP_METHOD;
        REQUEST_PARAMETERS = REQUEST_PARAMETERS;
        checkedURLClass = false;
        urlSupportsGetUserInfo = false;
        urlGetUserInfo = null;
        emptyParams = new Object[0];
    }
}

