/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl.validity;

import java.io.File;
import org.apache.excalibur.source.SourceValidity;

public final class FileTimeStampValidity
implements SourceValidity {
    private long timeStamp;
    private File file;

    public FileTimeStampValidity(String filename) {
        this(new File(filename));
    }

    public FileTimeStampValidity(File file) {
        this(file, file.lastModified());
    }

    public FileTimeStampValidity(File file, long timeStamp) {
        this.file = file;
        this.timeStamp = timeStamp;
    }

    public int isValid() {
        return this.file.lastModified() == this.timeStamp ? 1 : -1;
    }

    public boolean isValid(SourceValidity newValidity) {
        if (newValidity instanceof FileTimeStampValidity) {
            return this.timeStamp == ((FileTimeStampValidity)newValidity).getTimeStamp();
        }
        return false;
    }

    public File getFile() {
        return this.file;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String toString() {
        return "FileTimeStampValidity: " + this.file.getPath() + ": " + this.timeStamp;
    }
}

