/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.util;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.activity.Suspendable;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.Recontextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.service.Serviceable;

public final class ComponentStateValidator {
    private static final String WRITE_FAIL = "Value is already bound";
    private static final long LOG_ENABLED = 1L;
    private static final long LOGGABLE = 2L;
    private static final long CONTEXTUALIZABLE = 4L;
    private static final long COMPOSABLE = 8L;
    private static final long SERVICEABLE = 16L;
    private static final long CONFIGURABLE = 32L;
    private static final long PARAMETERIZABLE = 64L;
    private static final long INITIALIZABLE = 128L;
    private static final long STARTABLE = 256L;
    private static final long SUSPENDABLE = 4096L;
    private static final long RECONTEXTUALIZABLE = 8192L;
    private static final long RECOMPOSABLE = 16384L;
    private static final long RECONFIGURABLE = 32768L;
    private static final long DISPOSABLE = 0x100000L;
    private static final long ENABLE_LOGGING = 1L;
    private static final long SET_LOGGER = 2L;
    private static final long CONTEXTUALIZE = 4L;
    private static final long SERVICE = 8L;
    private static final long COMPOSE = 16L;
    private static final long CONFIGURE = 32L;
    private static final long PARAMETERIZE = 64L;
    private static final long INITIALIZE = 128L;
    private static final long START = 256L;
    private static final long INIT_COMPLETE = 1024L;
    private static final long SUSPEND = 4096L;
    private static final long RECONTEXTUALIZE = 8192L;
    private static final long RECOMPOSE = 16384L;
    private static final long RECONFIGURE = 32768L;
    private static final long RESUME = 65536L;
    private static final long STOP = 0x100000L;
    private static final long DISPOSE = 0x200000L;
    private static final long INIT_MASK = 511L;
    private final long m_interfaces;
    private final long m_methods;
    private long m_state;
    private boolean m_active;
    private final Object m_object;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$LogEnabled;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$Loggable;
    static /* synthetic */ Class class$org$apache$avalon$framework$context$Contextualizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$service$Serviceable;
    static /* synthetic */ Class class$org$apache$avalon$framework$component$Composable;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Configurable;
    static /* synthetic */ Class class$org$apache$avalon$framework$parameters$Parameterizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Initializable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Startable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Suspendable;
    static /* synthetic */ Class class$org$apache$avalon$framework$context$Recontextualizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$component$Recomposable;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Reconfigurable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Disposable;

    public ComponentStateValidator(Object object) {
        this.m_object = object;
        long methods = 0L;
        long interfaces = 0L;
        if (object instanceof LogEnabled) {
            interfaces |= 1L;
            methods |= 1L;
        }
        if (object instanceof Loggable) {
            interfaces |= 2L;
            methods |= 2L;
        }
        if (object instanceof Contextualizable) {
            interfaces |= 4L;
            methods |= 4L;
        }
        if (object instanceof Serviceable) {
            interfaces |= 0x10L;
            methods |= 8L;
        }
        if (object instanceof Composable) {
            if ((interfaces & 0x10L) > 0L) {
                throw new IllegalStateException("Cannot implement Composable and Serviceable together");
            }
            interfaces |= 8L;
            methods |= 0x10L;
        }
        if (object instanceof Configurable) {
            interfaces |= 0x20L;
            methods |= 0x20L;
        }
        if (object instanceof Parameterizable) {
            interfaces |= 0x40L;
            methods |= 0x40L;
        }
        if (object instanceof Initializable) {
            interfaces |= 0x80L;
            methods |= 0x80L;
        }
        if (object instanceof Startable) {
            interfaces |= 0x100L;
            methods |= 0x100100L;
        }
        if (object instanceof Suspendable) {
            interfaces |= 0x1000L;
            methods |= 0x11000L;
        }
        if (object instanceof Recontextualizable) {
            interfaces |= 0x2000L;
            methods |= 0x2000L;
        }
        if (object instanceof Recomposable) {
            interfaces |= 0x4000L;
            methods |= 0x4000L;
        }
        if (object instanceof Reconfigurable) {
            interfaces |= 0x8000L;
            methods |= 0x8000L;
        }
        if (object instanceof Disposable) {
            interfaces |= 0x100000L;
            methods |= 0x200000L;
        }
        this.m_methods = methods;
        this.m_interfaces = interfaces;
        this.generalCheckInitComplete();
    }

    private String getInterfaceName(long interfaceId) {
        if (interfaceId == 1L) {
            return (class$org$apache$avalon$framework$logger$LogEnabled == null ? (class$org$apache$avalon$framework$logger$LogEnabled = ComponentStateValidator.class$("org.apache.avalon.framework.logger.LogEnabled")) : class$org$apache$avalon$framework$logger$LogEnabled).getName();
        }
        if (interfaceId == 2L) {
            return (class$org$apache$avalon$framework$logger$Loggable == null ? (class$org$apache$avalon$framework$logger$Loggable = ComponentStateValidator.class$("org.apache.avalon.framework.logger.Loggable")) : class$org$apache$avalon$framework$logger$Loggable).getName();
        }
        if (interfaceId == 4L) {
            return (class$org$apache$avalon$framework$context$Contextualizable == null ? (class$org$apache$avalon$framework$context$Contextualizable = ComponentStateValidator.class$("org.apache.avalon.framework.context.Contextualizable")) : class$org$apache$avalon$framework$context$Contextualizable).getName();
        }
        if (interfaceId == 16L) {
            return (class$org$apache$avalon$framework$service$Serviceable == null ? (class$org$apache$avalon$framework$service$Serviceable = ComponentStateValidator.class$("org.apache.avalon.framework.service.Serviceable")) : class$org$apache$avalon$framework$service$Serviceable).getName();
        }
        if (interfaceId == 8L) {
            return (class$org$apache$avalon$framework$component$Composable == null ? (class$org$apache$avalon$framework$component$Composable = ComponentStateValidator.class$("org.apache.avalon.framework.component.Composable")) : class$org$apache$avalon$framework$component$Composable).getName();
        }
        if (interfaceId == 32L) {
            return (class$org$apache$avalon$framework$configuration$Configurable == null ? (class$org$apache$avalon$framework$configuration$Configurable = ComponentStateValidator.class$("org.apache.avalon.framework.configuration.Configurable")) : class$org$apache$avalon$framework$configuration$Configurable).getName();
        }
        if (interfaceId == 64L) {
            return (class$org$apache$avalon$framework$parameters$Parameterizable == null ? (class$org$apache$avalon$framework$parameters$Parameterizable = ComponentStateValidator.class$("org.apache.avalon.framework.parameters.Parameterizable")) : class$org$apache$avalon$framework$parameters$Parameterizable).getName();
        }
        if (interfaceId == 128L) {
            return (class$org$apache$avalon$framework$activity$Initializable == null ? (class$org$apache$avalon$framework$activity$Initializable = ComponentStateValidator.class$("org.apache.avalon.framework.activity.Initializable")) : class$org$apache$avalon$framework$activity$Initializable).getName();
        }
        if (interfaceId == 256L) {
            return (class$org$apache$avalon$framework$activity$Startable == null ? (class$org$apache$avalon$framework$activity$Startable = ComponentStateValidator.class$("org.apache.avalon.framework.activity.Startable")) : class$org$apache$avalon$framework$activity$Startable).getName();
        }
        if (interfaceId == 4096L) {
            return (class$org$apache$avalon$framework$activity$Suspendable == null ? (class$org$apache$avalon$framework$activity$Suspendable = ComponentStateValidator.class$("org.apache.avalon.framework.activity.Suspendable")) : class$org$apache$avalon$framework$activity$Suspendable).getName();
        }
        if (interfaceId == 8192L) {
            return (class$org$apache$avalon$framework$context$Recontextualizable == null ? (class$org$apache$avalon$framework$context$Recontextualizable = ComponentStateValidator.class$("org.apache.avalon.framework.context.Recontextualizable")) : class$org$apache$avalon$framework$context$Recontextualizable).getName();
        }
        if (interfaceId == 16384L) {
            return (class$org$apache$avalon$framework$component$Recomposable == null ? (class$org$apache$avalon$framework$component$Recomposable = ComponentStateValidator.class$("org.apache.avalon.framework.component.Recomposable")) : class$org$apache$avalon$framework$component$Recomposable).getName();
        }
        if (interfaceId == 32768L) {
            return (class$org$apache$avalon$framework$configuration$Reconfigurable == null ? (class$org$apache$avalon$framework$configuration$Reconfigurable = ComponentStateValidator.class$("org.apache.avalon.framework.configuration.Reconfigurable")) : class$org$apache$avalon$framework$configuration$Reconfigurable).getName();
        }
        if (interfaceId == 0x100000L) {
            return (class$org$apache$avalon$framework$activity$Disposable == null ? (class$org$apache$avalon$framework$activity$Disposable = ComponentStateValidator.class$("org.apache.avalon.framework.activity.Disposable")) : class$org$apache$avalon$framework$activity$Disposable).getName();
        }
        throw new IllegalStateException("Unknown Interface Id " + interfaceId);
    }

    private String getMethodName(long methodId) {
        if (methodId == 1L) {
            return "enableLogging()";
        }
        if (methodId == 2L) {
            return "setLogger()";
        }
        if (methodId == 4L) {
            return "contextualize()";
        }
        if (methodId == 8L) {
            return "service()";
        }
        if (methodId == 16L) {
            return "compose()";
        }
        if (methodId == 32L) {
            return "configure()";
        }
        if (methodId == 64L) {
            return "parameterize()";
        }
        if (methodId == 128L) {
            return "initialize()";
        }
        if (methodId == 256L) {
            return "start()";
        }
        if (methodId == 4096L) {
            return "suspend()";
        }
        if (methodId == 8192L) {
            return "recontextualize()";
        }
        if (methodId == 16384L) {
            return "recompose()";
        }
        if (methodId == 32768L) {
            return "reconfigure()";
        }
        if (methodId == 65536L) {
            return "resume()";
        }
        if (methodId == 0x100000L) {
            return "stop()";
        }
        if (methodId == 0x200000L) {
            return "dispose()";
        }
        throw new IllegalStateException("Unknown Method Id " + methodId);
    }

    private String getLastMethod(long state) {
        int i = 31;
        while (i >= 0) {
            long methodId = 1 << i;
            if ((state & methodId) != 0L) {
                return this.getMethodName(methodId);
            }
            --i;
        }
        throw new IllegalStateException("No last state method found for state " + state);
    }

    private void generalCheckInitComplete() {
        if (this.m_state == (this.m_methods & 0x1FFL)) {
            this.m_active = true;
        }
    }

    private void generalCheckInit(String message, long interfaceId, long methodId) {
        if ((this.m_interfaces & interfaceId) == 0L) {
            if (message == null) {
                throw new IllegalStateException(this.m_object.getClass().getName() + " does not implement " + this.getInterfaceName(interfaceId) + ".");
            }
            throw new IllegalStateException(message);
        }
        if ((this.m_state & methodId) > 0L) {
            if (message == null) {
                throw new IllegalStateException(this.getMethodName(methodId) + " already called.");
            }
            throw new IllegalStateException(message);
        }
        if (this.m_state > methodId) {
            if (message == null) {
                throw new IllegalStateException(this.getMethodName(methodId) + " can not be called after " + this.getLastMethod(this.m_state) + ".");
            }
            throw new IllegalStateException(message);
        }
        if ((this.m_state & methodId - 1L) != (this.m_methods & methodId - 1L)) {
            if (message == null) {
                throw new IllegalStateException(this.getMethodName(methodId) + " called out of order. " + this.getLastMethod(this.m_methods & methodId - 1L) + " must be called first.");
            }
            throw new IllegalStateException(message);
        }
        this.m_state |= methodId;
        this.generalCheckInitComplete();
    }

    private void generalCheckActive(String message, long interfaceId, long methodId) {
        if ((this.m_interfaces & interfaceId) == 0L) {
            if (message == null) {
                throw new IllegalStateException(this.m_object.getClass().getName() + " does not implement " + this.getInterfaceName(interfaceId) + ".");
            }
            throw new IllegalStateException(message);
        }
        if (!this.m_active) {
            if (this.m_state < 1024L) {
                if (message == null) {
                    throw new IllegalStateException(this.getMethodName(methodId) + " called before component was made active. " + this.getLastMethod(this.m_methods & 0x3FFL) + " must be called first.");
                }
                throw new IllegalStateException(message);
            }
            if (message == null) {
                throw new IllegalStateException(this.getMethodName(methodId) + " called after component was made inactive.  Cannot call after " + this.getLastMethod(this.m_state) + ".");
            }
            throw new IllegalStateException(message);
        }
    }

    private void generalCheckDest(String message, long interfaceId, long methodId) {
        if ((this.m_interfaces & interfaceId) == 0L) {
            if (message == null) {
                throw new IllegalStateException(this.m_object.getClass().getName() + " does not implement " + this.getInterfaceName(interfaceId) + ".");
            }
            throw new IllegalStateException(message);
        }
        if (this.m_state > methodId) {
            if (message == null) {
                throw new IllegalStateException(this.getMethodName(methodId) + " can not be called after " + this.getLastMethod(this.m_state) + ".");
            }
            throw new IllegalStateException(message);
        }
        this.m_state |= methodId;
        this.m_active = false;
    }

    public void checkLogEnabled() {
        this.checkLogEnabled(null);
    }

    public void checkLogEnabled(String message) {
        this.generalCheckInit(message, 1L, 1L);
    }

    public void checkLoggable() {
        this.checkLogEnabled(null);
    }

    public void checkLoggable(String message) {
        this.generalCheckInit(message, 2L, 2L);
    }

    public void checkContextualized() {
        this.checkContextualized(null);
    }

    public void checkContextualized(String message) {
        this.generalCheckInit(message, 4L, 4L);
    }

    public void checkServiced() {
        this.checkServiced(null);
    }

    public void checkServiced(String message) {
        this.generalCheckInit(message, 16L, 8L);
    }

    public void checkComposed() {
        this.checkComposed(null);
    }

    public void checkComposed(String message) {
        this.generalCheckInit(message, 8L, 16L);
    }

    public void checkConfigured() {
        this.checkConfigured(null);
    }

    public void checkConfigured(String message) {
        this.generalCheckInit(message, 32L, 32L);
    }

    public void checkParameterized() {
        this.checkParameterized(null);
    }

    public void checkParameterized(String message) {
        this.generalCheckInit(message, 64L, 64L);
    }

    public void checkInitialized() {
        this.checkInitialized(null);
    }

    public void checkInitialized(String message) {
        this.generalCheckInit(message, 128L, 128L);
    }

    public void checkStarted() {
        this.checkStarted(null);
    }

    public void checkStarted(String message) {
        this.generalCheckInit(message, 256L, 256L);
    }

    public void checkSuspended() {
        this.checkSuspended(null);
    }

    public void checkSuspended(String message) {
        this.generalCheckActive(message, 4096L, 4096L);
    }

    public void checkResumed() {
        this.checkResumed(null);
    }

    public void checkResumed(String message) {
        this.generalCheckActive(message, 4096L, 65536L);
    }

    public void checkStopped() {
        this.checkStopped(null);
    }

    public void checkStopped(String message) {
        this.generalCheckDest(message, 256L, 0x100000L);
    }

    public void checkDisposed() {
        this.checkDisposed(null);
    }

    public void checkDisposed(String message) {
        this.generalCheckDest(message, 0x100000L, 0x200000L);
    }

    public void checkActive() {
        this.checkActive(null);
    }

    public void checkActive(String message) {
        if (this.isActive()) {
            return;
        }
        if (this.m_state < 1024L) {
            if (message == null) {
                throw new IllegalStateException("Component not in the active state. " + this.getLastMethod(this.m_methods & 0x3FFL) + " was not called.");
            }
            throw new IllegalStateException(message);
        }
        if (message == null) {
            throw new IllegalStateException("Component not in the active state because " + this.getLastMethod(this.m_state) + " was called.");
        }
        throw new IllegalStateException(message);
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void checkNotAssigned(Object object) {
        this.checkNotAssigned(object, WRITE_FAIL);
    }

    public void checkNotAssigned(Object object, String message) {
        if (null != object) {
            throw new IllegalStateException(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        WRITE_FAIL = WRITE_FAIL;
        LOG_ENABLED = 1L;
        LOGGABLE = 2L;
        CONTEXTUALIZABLE = 4L;
        COMPOSABLE = 8L;
        SERVICEABLE = 16L;
        CONFIGURABLE = 32L;
        PARAMETERIZABLE = 64L;
        INITIALIZABLE = 128L;
        STARTABLE = 256L;
        SUSPENDABLE = 4096L;
        RECONTEXTUALIZABLE = 8192L;
        RECOMPOSABLE = 16384L;
        RECONFIGURABLE = 32768L;
        DISPOSABLE = 0x100000L;
        ENABLE_LOGGING = 1L;
        SET_LOGGER = 2L;
        CONTEXTUALIZE = 4L;
        SERVICE = 8L;
        COMPOSE = 16L;
        CONFIGURE = 32L;
        PARAMETERIZE = 64L;
        INITIALIZE = 128L;
        START = 256L;
        INIT_COMPLETE = 1024L;
        SUSPEND = 4096L;
        RECONTEXTUALIZE = 8192L;
        RECOMPOSE = 16384L;
        RECONFIGURE = 32768L;
        RESUME = 65536L;
        STOP = 0x100000L;
        DISPOSE = 0x200000L;
        INIT_MASK = 511L;
    }
}

