/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xmlizer.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.xmlizer.XMLizer;
import org.w3c.tidy.Tidy;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HTMLXMLizer
extends AbstractLogEnabled
implements XMLizer,
ThreadSafe,
Composable {
    protected ComponentManager manager;
    protected static Properties format;

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toSAX(InputStream stream, String mimeType, String systemID, ContentHandler handler) throws SAXException, IOException, ComponentException {
        if (null == stream) {
            throw new ComponentException("Stream must not be null.");
        }
        if (null == handler) {
            throw new ComponentException("Handler must not be null.");
        }
        if (null == mimeType) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No mime-type for xmlizing " + systemID + ", guessing text/html");
            }
        } else if (!mimeType.equalsIgnoreCase("text/html") && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Mime-type " + mimeType + "not supported for xmlizing " + systemID + ", guessing text/html");
        }
        Tidy xhtmlconvert = new Tidy();
        xhtmlconvert.setXmlOut(true);
        xhtmlconvert.setXHTML(true);
        xhtmlconvert.setShowWarnings(false);
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperties(format);
            transformer.transform(new DOMSource(xhtmlconvert.parseDOM(stream, null)), new StreamResult(writer));
        }
        catch (TransformerException te) {
            throw new SAXException("Exception during transformation.", te);
        }
        InputSource inputSource = new InputSource(new StringReader(writer.toString()));
        if (null != systemID) {
            inputSource.setSystemId(systemID);
        }
        Parser parser = null;
        try {
            parser = (Parser)this.manager.lookup(Parser.ROLE);
            parser.parse(inputSource, handler);
            Object var10_10 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (parser == null) throw throwable;
            this.manager.release((Component)parser);
            throw throwable;
        }
        this.manager.release((Component)parser);
    }

    static {
        Properties format = new Properties();
        format.put("method", "xml");
        format.put("omit-xml-declaration", "no");
        format.put("indent", "yes");
    }
}

