/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd.models;

import org.apache.xerces.impl.dtd.models.ContentModelValidator;
import org.apache.xerces.xni.QName;

public class SimpleContentModel
implements ContentModelValidator {
    public static final short CHOICE = -1;
    public static final short SEQUENCE = -1;
    private QName fFirstChild = new QName();
    private QName fSecondChild = new QName();
    private int fOperator;

    public SimpleContentModel(short s, QName qName, QName qName2) {
        this.fFirstChild.setValues(qName);
        if (qName2 != null) {
            this.fSecondChild.setValues(qName2);
        } else {
            this.fSecondChild.clear();
        }
        this.fOperator = s;
    }

    public QName[] getAllowedSubElements() {
        if (this.fOperator == 4 || this.fOperator == 5) {
            QName[] qNameArray = new QName[]{this.fFirstChild, this.fSecondChild};
            return qNameArray;
        }
        QName[] qNameArray = new QName[]{this.fFirstChild};
        return qNameArray;
    }

    public int validate(QName[] qNameArray, int n, int n2) {
        switch (this.fOperator) {
            case 0: {
                if (n2 == 0) {
                    return 0;
                }
                if (qNameArray[n].rawname == null) {
                    return 0;
                }
                if (!qNameArray[n].rawname.equals(this.fFirstChild.rawname)) {
                    return 0;
                }
                if (n2 <= 1) break;
                return 1;
            }
            case 1: {
                if (n2 == 1) {
                    if (qNameArray[n].rawname == null) {
                        return 0;
                    }
                    if (!qNameArray[n].rawname.equals(this.fFirstChild.rawname)) {
                        return 0;
                    }
                }
                if (n2 <= 1) break;
                return 1;
            }
            case 2: {
                if (n2 <= 0) break;
                int n3 = 0;
                while (n3 < n2) {
                    if (qNameArray[n + n3].rawname == null) {
                        return n3;
                    }
                    if (!qNameArray[n + n3].rawname.equals(this.fFirstChild.rawname)) {
                        return n3;
                    }
                    ++n3;
                }
                break;
            }
            case 3: {
                if (n2 == 0) {
                    return 0;
                }
                int n4 = 0;
                while (n4 < n2) {
                    if (qNameArray[n + n4].rawname == null) {
                        return n4;
                    }
                    if (!qNameArray[n + n4].rawname.equals(this.fFirstChild.rawname)) {
                        return n4;
                    }
                    ++n4;
                }
                break;
            }
            case 4: {
                if (n2 == 0) {
                    return 0;
                }
                if (qNameArray[n].rawname == null) {
                    return 0;
                }
                if (!qNameArray[n].rawname.equals(this.fFirstChild.rawname) && !qNameArray[n].rawname.equals(this.fSecondChild.rawname)) {
                    return 0;
                }
                if (n2 <= 1) break;
                return 1;
            }
            case 5: {
                if (n2 == 0) {
                    return 0;
                }
                if (qNameArray[n].rawname == null) {
                    return 0;
                }
                if (n2 == 2) {
                    if (!qNameArray[n].rawname.equals(this.fFirstChild.rawname)) {
                        return 0;
                    }
                    if (qNameArray[n + 1].rawname == null) {
                        return 1;
                    }
                    if (qNameArray[n + 1].rawname.equals(this.fSecondChild.rawname)) break;
                    return 1;
                }
                if (n2 > 2) {
                    return 2;
                }
                return n2;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        return -1;
    }

    public QName[] whatCanGoNext(QName[] qNameArray, int n, int n2) {
        if (qNameArray.length > 1) {
            return null;
        }
        this.validate(qNameArray, n, n2);
        switch (this.fOperator) {
            case 0: {
                if (n2 < 1) {
                    QName[] qNameArray2 = new QName[]{this.fFirstChild};
                    return qNameArray2;
                }
                return null;
            }
            case 1: {
                if (n2 < 1) {
                    QName[] qNameArray3 = new QName[]{this.fFirstChild};
                    return qNameArray3;
                }
                return null;
            }
            case 2: {
                if (n2 > 0) {
                    int n3 = 0;
                    while (n3 < n2) {
                        if (qNameArray[n + n3].rawname != this.fFirstChild.rawname) {
                            return null;
                        }
                        ++n3;
                    }
                }
                QName[] qNameArray4 = new QName[]{this.fFirstChild};
                return qNameArray4;
            }
            case 3: {
                int n4 = 0;
                while (n4 < n2) {
                    if (qNameArray[n + n4].rawname != this.fFirstChild.rawname) {
                        return null;
                    }
                    ++n4;
                }
                QName[] qNameArray5 = new QName[]{this.fFirstChild};
                return qNameArray5;
            }
            case 4: {
                if (qNameArray[n].rawname != this.fFirstChild.rawname && qNameArray[n].rawname != this.fSecondChild.rawname) {
                    return null;
                }
                if (n2 > 0) {
                    return null;
                }
                QName[] qNameArray6 = new QName[]{this.fFirstChild, this.fSecondChild};
                return qNameArray6;
            }
            case 5: {
                if (n2 == 2) {
                    if (qNameArray[n].rawname != this.fFirstChild.rawname) {
                        return null;
                    }
                    if (qNameArray[n + 1].rawname != this.fSecondChild.rawname) {
                        return null;
                    }
                } else if (n2 > 2) {
                    return null;
                }
                if (n2 == 1) {
                    QName[] qNameArray7 = new QName[]{this.fSecondChild};
                    return qNameArray7;
                }
                QName[] qNameArray8 = new QName[]{this.fFirstChild, this.fSecondChild};
                return qNameArray8;
            }
        }
        QName[] qNameArray9 = new QName[]{this.fSecondChild};
        return qNameArray9;
    }
}

