/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.util.Locale;
import org.apache.xerces.impl.msg.XMLMessageFormatter;
import org.apache.xerces.util.MessageFormatter;

public class UTF8Reader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final boolean DEBUG_READ = false;
    protected InputStream fInputStream;
    protected byte[] fBuffer;
    protected int fOffset;
    private int fSurrogate = -1;
    private MessageFormatter fFormatter = null;
    private Locale fLocale = null;

    public UTF8Reader(InputStream inputStream) {
        this(inputStream, 2048, new XMLMessageFormatter(), Locale.getDefault());
    }

    public UTF8Reader(InputStream inputStream, MessageFormatter messageFormatter, Locale locale) {
        this(inputStream, 2048, messageFormatter, locale);
    }

    public UTF8Reader(InputStream inputStream, int n, MessageFormatter messageFormatter, Locale locale) {
        this.fInputStream = inputStream;
        this.fBuffer = new byte[n];
        this.fFormatter = messageFormatter;
        this.fLocale = locale;
    }

    public int read() throws IOException {
        int n = this.fSurrogate;
        if (this.fSurrogate == -1) {
            int n2;
            int n3 = 0;
            int n4 = n2 = n3 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n3++] & 0xFF;
            if (n2 == -1) {
                return -1;
            }
            if (n2 < 128) {
                n = (char)n2;
            } else if ((n2 & 0xE0) == 192) {
                int n5;
                int n6 = n5 = n3 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n3++] & 0xFF;
                if (n5 == -1) {
                    this.expectedByte(2, 2);
                }
                if ((n5 & 0xC0) != 128) {
                    this.invalidByte(2, 2, n5);
                }
                n = n2 << 6 & 0x7C0 | n5 & 0x3F;
            } else if ((n2 & 0xF0) == 224) {
                int n7;
                int n8;
                int n9 = n8 = n3 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n3++] & 0xFF;
                if (n8 == -1) {
                    this.expectedByte(2, 3);
                }
                if ((n8 & 0xC0) != 128) {
                    this.invalidByte(2, 3, n8);
                }
                int n10 = n7 = n3 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n3++] & 0xFF;
                if (n7 == -1) {
                    this.expectedByte(3, 3);
                }
                if ((n7 & 0xC0) != 128) {
                    this.invalidByte(3, 3, n7);
                }
                n = n2 << 12 & 0xF000 | n8 << 6 & 0xFC0 | n7 & 0x3F;
            } else if ((n2 & 0xF8) == 240) {
                int n11;
                int n12;
                int n13;
                int n14;
                int n15 = n14 = n3 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n3++] & 0xFF;
                if (n14 == -1) {
                    this.expectedByte(2, 4);
                }
                if ((n14 & 0xC0) != 128) {
                    this.invalidByte(2, 3, n14);
                }
                int n16 = n13 = n3 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n3++] & 0xFF;
                if (n13 == -1) {
                    this.expectedByte(3, 4);
                }
                if ((n13 & 0xC0) != 128) {
                    this.invalidByte(3, 3, n13);
                }
                int n17 = n12 = n3 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n3++] & 0xFF;
                if (n12 == -1) {
                    this.expectedByte(4, 4);
                }
                if ((n12 & 0xC0) != 128) {
                    this.invalidByte(4, 4, n12);
                }
                if ((n11 = n2 << 2 & 0x1C | n14 >> 4 & 3) > 16) {
                    this.invalidSurrogate(n11);
                }
                int n18 = n11 - 1;
                int n19 = 0xD800 | n18 << 6 & 0x3C0 | n14 << 2 & 0x3C | n13 >> 4 & 3;
                int n20 = 0xDC00 | n13 << 6 & 0x3C0 | n12 & 0x3F;
                n = n19;
                this.fSurrogate = n20;
            } else {
                this.invalidByte(1, 1, n2);
            }
        } else {
            this.fSurrogate = -1;
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        if (this.fSurrogate != -1) {
            cArray[n + 1] = (char)this.fSurrogate;
            this.fSurrogate = -1;
            --n2;
            ++n3;
        }
        int n4 = 0;
        if (this.fOffset == 0) {
            if (n2 > this.fBuffer.length) {
                n2 = this.fBuffer.length;
            }
            if ((n4 = this.fInputStream.read(this.fBuffer, 0, n2)) == -1) {
                return -1;
            }
            n4 += n3 - n;
        } else {
            n4 = this.fOffset;
            this.fOffset = 0;
        }
        int n5 = n4;
        for (int i = 0; i < n5; ++i) {
            int n6;
            int n7;
            int n8;
            int n9 = this.fBuffer[i] & 0xFF;
            if (n9 < 128) {
                cArray[n3++] = (char)n9;
                continue;
            }
            if ((n9 & 0xE0) == 192) {
                n8 = -1;
                if (++i < n5) {
                    n8 = this.fBuffer[i] & 0xFF;
                } else {
                    n8 = this.fInputStream.read();
                    if (n8 == -1) {
                        if (n3 > n) {
                            this.fBuffer[0] = (byte)n9;
                            this.fOffset = 1;
                            return n3 - n;
                        }
                        this.expectedByte(2, 2);
                    }
                    ++n4;
                }
                if ((n8 & 0xC0) != 128) {
                    if (n3 > n) {
                        this.fBuffer[0] = (byte)n9;
                        this.fBuffer[1] = (byte)n8;
                        this.fOffset = 2;
                        return n3 - n;
                    }
                    this.invalidByte(2, 2, n8);
                }
                n7 = n9 << 6 & 0x7C0 | n8 & 0x3F;
                cArray[n3++] = (char)n7;
                --n4;
                continue;
            }
            if ((n9 & 0xF0) == 224) {
                n8 = -1;
                if (++i < n5) {
                    n8 = this.fBuffer[i] & 0xFF;
                } else {
                    n8 = this.fInputStream.read();
                    if (n8 == -1) {
                        if (n3 > n) {
                            this.fBuffer[0] = (byte)n9;
                            this.fOffset = 1;
                            return n3 - n;
                        }
                        this.expectedByte(2, 3);
                    }
                    ++n4;
                }
                if ((n8 & 0xC0) != 128) {
                    if (n3 > n) {
                        this.fBuffer[0] = (byte)n9;
                        this.fBuffer[1] = (byte)n8;
                        this.fOffset = 2;
                        return n3 - n;
                    }
                    this.invalidByte(2, 3, n8);
                }
                n7 = -1;
                if (++i < n5) {
                    n7 = this.fBuffer[i] & 0xFF;
                } else {
                    n7 = this.fInputStream.read();
                    if (n7 == -1) {
                        if (n3 > n) {
                            this.fBuffer[0] = (byte)n9;
                            this.fBuffer[1] = (byte)n8;
                            this.fOffset = 2;
                            return n3 - n;
                        }
                        this.expectedByte(3, 3);
                    }
                    ++n4;
                }
                if ((n7 & 0xC0) != 128) {
                    if (n3 > n) {
                        this.fBuffer[0] = (byte)n9;
                        this.fBuffer[1] = (byte)n8;
                        this.fBuffer[2] = (byte)n7;
                        this.fOffset = 3;
                        return n3 - n;
                    }
                    this.invalidByte(3, 3, n7);
                }
                n6 = n9 << 12 & 0xF000 | n8 << 6 & 0xFC0 | n7 & 0x3F;
                cArray[n3++] = (char)n6;
                n4 -= 2;
                continue;
            }
            if ((n9 & 0xF8) == 240) {
                int n10;
                n8 = -1;
                if (++i < n5) {
                    n8 = this.fBuffer[i] & 0xFF;
                } else {
                    n8 = this.fInputStream.read();
                    if (n8 == -1) {
                        if (n3 > n) {
                            this.fBuffer[0] = (byte)n9;
                            this.fOffset = 1;
                            return n3 - n;
                        }
                        this.expectedByte(2, 4);
                    }
                    ++n4;
                }
                if ((n8 & 0xC0) != 128) {
                    if (n3 > n) {
                        this.fBuffer[0] = (byte)n9;
                        this.fBuffer[1] = (byte)n8;
                        this.fOffset = 2;
                        return n3 - n;
                    }
                    this.invalidByte(2, 4, n8);
                }
                n7 = -1;
                if (++i < n5) {
                    n7 = this.fBuffer[i] & 0xFF;
                } else {
                    n7 = this.fInputStream.read();
                    if (n7 == -1) {
                        if (n3 > n) {
                            this.fBuffer[0] = (byte)n9;
                            this.fBuffer[1] = (byte)n8;
                            this.fOffset = 2;
                            return n3 - n;
                        }
                        this.expectedByte(3, 4);
                    }
                    ++n4;
                }
                if ((n7 & 0xC0) != 128) {
                    if (n3 > n) {
                        this.fBuffer[0] = (byte)n9;
                        this.fBuffer[1] = (byte)n8;
                        this.fBuffer[2] = (byte)n7;
                        this.fOffset = 3;
                        return n3 - n;
                    }
                    this.invalidByte(3, 4, n7);
                }
                n6 = -1;
                if (++i < n5) {
                    n6 = this.fBuffer[i] & 0xFF;
                } else {
                    n6 = this.fInputStream.read();
                    if (n6 == -1) {
                        if (n3 > n) {
                            this.fBuffer[0] = (byte)n9;
                            this.fBuffer[1] = (byte)n8;
                            this.fBuffer[2] = (byte)n7;
                            this.fOffset = 3;
                            return n3 - n;
                        }
                        this.expectedByte(4, 4);
                    }
                    ++n4;
                }
                if ((n6 & 0xC0) != 128) {
                    if (n3 > n) {
                        this.fBuffer[0] = (byte)n9;
                        this.fBuffer[1] = (byte)n8;
                        this.fBuffer[2] = (byte)n7;
                        this.fBuffer[3] = (byte)n6;
                        this.fOffset = 4;
                        return n3 - n;
                    }
                    this.invalidByte(4, 4, n7);
                }
                if ((n10 = n9 << 2 & 0x1C | n8 >> 4 & 3) > 16) {
                    this.invalidSurrogate(n10);
                }
                int n11 = n10 - 1;
                int n12 = n8 & 0xF;
                int n13 = n7 & 0x3F;
                int n14 = n6 & 0x3F;
                int n15 = 0xD800 | n11 << 6 & 0x3C0 | n12 << 2 | n13 >> 4;
                int n16 = 0xDC00 | n13 << 6 & 0x3C0 | n14;
                cArray[n3++] = (char)n15;
                cArray[n3++] = (char)n16;
                n4 -= 2;
                continue;
            }
            if (n3 > n) {
                this.fBuffer[0] = (byte)n9;
                this.fOffset = 1;
                return n3 - n;
            }
            this.invalidByte(1, 1, n9);
        }
        return n4;
    }

    public long skip(long l) throws IOException {
        int n;
        int n2;
        long l2 = l;
        char[] cArray = new char[this.fBuffer.length];
        while ((n2 = this.read(cArray, 0, n = (long)cArray.length < l2 ? cArray.length : (int)l2)) > 0 && (l2 -= (long)n2) > 0L) {
        }
        long l3 = l - l2;
        return l3;
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) throws IOException {
        throw new IOException(this.fFormatter.formatMessage(this.fLocale, "OperationNotSupported", new Object[]{"mark()", "UTF-8"}));
    }

    public void reset() throws IOException {
        this.fOffset = 0;
        this.fSurrogate = -1;
    }

    public void close() throws IOException {
        this.fInputStream.close();
    }

    private void expectedByte(int n, int n2) throws UTFDataFormatException {
        String string = this.fFormatter.formatMessage(this.fLocale, "ExpectedByte", new Object[]{Integer.toString(n), Integer.toString(n2)});
        throw new UTFDataFormatException(string);
    }

    private void invalidByte(int n, int n2, int n3) throws UTFDataFormatException {
        String string = this.fFormatter.formatMessage(this.fLocale, "InvalidByte", new Object[]{Integer.toString(n), Integer.toString(n2)});
        throw new UTFDataFormatException(string);
    }

    private void invalidSurrogate(int n) throws UTFDataFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("high surrogate bits in UTF-8 sequence must not exceed 0x10 but found 0x");
        String string = this.fFormatter.formatMessage(this.fLocale, "InvalidHighSurrogate", new Object[]{Integer.toHexString(n)});
        throw new UTFDataFormatException(string);
    }
}

