/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.psvi.StringList;
import org.apache.xerces.impl.xs.psvi.XSAttributeDeclaration;
import org.apache.xerces.impl.xs.psvi.XSAttributeGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSElementDeclaration;
import org.apache.xerces.impl.xs.psvi.XSModel;
import org.apache.xerces.impl.xs.psvi.XSModelGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSNamedMap;
import org.apache.xerces.impl.xs.psvi.XSNamespaceItemList;
import org.apache.xerces.impl.xs.psvi.XSNotationDeclaration;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.util.NSItemListImpl;
import org.apache.xerces.impl.xs.util.StringListImpl;
import org.apache.xerces.impl.xs.util.XSNamedMap4Types;
import org.apache.xerces.impl.xs.util.XSNamedMapImpl;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.util.XMLSymbols;

public class XSModelImpl
implements XSModel {
    private static final short MAX_COMP_IDX = 14;
    private static final boolean[] GLOBAL_COMP = new boolean[]{false, true, true, true, false, true, true, false, false, false, false, true, false, true, true};
    private int fGrammarCount;
    private String[] fNamespaces;
    private SchemaGrammar[] fGrammarList;
    private SymbolHash fGrammarMap;
    private XSNamedMap[] fGlobalComponents;
    private XSNamedMap[][] fNSComponents;
    private SymbolHash[] fTables;

    public XSModelImpl(SchemaGrammar[] schemaGrammarArray) {
        int n;
        int n2 = schemaGrammarArray.length;
        this.fNamespaces = new String[Math.max(n2 + 1, 5)];
        this.fGrammarList = new SchemaGrammar[Math.max(n2 + 1, 5)];
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            this.fNamespaces[i] = schemaGrammarArray[i].getTargetNamespace();
            this.fGrammarList[i] = schemaGrammarArray[i];
            if (this.fNamespaces[i] != SchemaSymbols.URI_SCHEMAFORSCHEMA) continue;
            bl = true;
        }
        if (!bl) {
            this.fNamespaces[n2] = SchemaSymbols.URI_SCHEMAFORSCHEMA;
            this.fGrammarList[n2++] = SchemaGrammar.SG_SchemaNS;
        }
        for (n = 0; n < n2; ++n) {
            int n3;
            SchemaGrammar schemaGrammar = this.fGrammarList[n];
            Vector vector = schemaGrammar.getImportedGrammars();
            int n4 = n3 = vector == null ? -1 : vector.size() - 1;
            while (n3 >= 0) {
                int n5;
                SchemaGrammar schemaGrammar2 = (SchemaGrammar)vector.elementAt(n3);
                for (n5 = 0; n5 < n2 && schemaGrammar2 != this.fGrammarList[n5]; ++n5) {
                }
                if (n5 == n2) {
                    if (n2 == this.fGrammarList.length) {
                        String[] stringArray = new String[n2 * 2];
                        System.arraycopy(this.fNamespaces, 0, stringArray, 0, n2);
                        this.fNamespaces = stringArray;
                        SchemaGrammar[] schemaGrammarArray2 = new SchemaGrammar[n2 * 2];
                        System.arraycopy(this.fGrammarList, 0, schemaGrammarArray2, 0, n2);
                        this.fGrammarList = schemaGrammarArray2;
                    }
                    this.fNamespaces[n2] = schemaGrammar2.getTargetNamespace();
                    this.fGrammarList[n2] = schemaGrammar2;
                    ++n2;
                }
                --n3;
            }
        }
        this.fGrammarMap = new SymbolHash(n2 * 2);
        for (n = 0; n < n2; ++n) {
            this.fGrammarMap.put(XSModelImpl.null2EmptyString(this.fNamespaces[n]), this.fGrammarList[n]);
        }
        this.fGrammarCount = n2;
        this.fGlobalComponents = new XSNamedMap[15];
        this.fNSComponents = new XSNamedMap[n2][15];
        this.fTables = new SymbolHash[this.fGrammarCount];
    }

    public StringList getNamespaces() {
        return new StringListImpl(this.fNamespaces, this.fGrammarCount);
    }

    public XSNamespaceItemList getNamespaceItems() {
        return new NSItemListImpl(this.fGrammarList, this.fGrammarCount);
    }

    public synchronized XSNamedMap getComponents(short s) {
        if (s <= 0 || s > 14 || !GLOBAL_COMP[s]) {
            return null;
        }
        if (this.fGlobalComponents[s] == null) {
            block8: for (int i = 0; i < this.fGrammarCount; ++i) {
                switch (s) {
                    case 3: 
                    case 13: 
                    case 14: {
                        this.fTables[i] = this.fGrammarList[i].fGlobalTypeDecls;
                        continue block8;
                    }
                    case 1: {
                        this.fTables[i] = this.fGrammarList[i].fGlobalAttrDecls;
                        continue block8;
                    }
                    case 2: {
                        this.fTables[i] = this.fGrammarList[i].fGlobalElemDecls;
                        continue block8;
                    }
                    case 5: {
                        this.fTables[i] = this.fGrammarList[i].fGlobalAttrGrpDecls;
                        continue block8;
                    }
                    case 6: {
                        this.fTables[i] = this.fGrammarList[i].fGlobalGroupDecls;
                        continue block8;
                    }
                    case 11: {
                        this.fTables[i] = this.fGrammarList[i].fGlobalNotationDecls;
                    }
                }
            }
            this.fGlobalComponents[s] = s == 13 || s == 14 ? new XSNamedMap4Types(this.fNamespaces, this.fTables, this.fGrammarCount, s) : new XSNamedMapImpl(this.fNamespaces, this.fTables, this.fGrammarCount);
        }
        return this.fGlobalComponents[s];
    }

    public synchronized XSNamedMap getComponentsByNamespace(short s, String string) {
        int n;
        if (s <= 0 || s > 14 || !GLOBAL_COMP[s]) {
            return null;
        }
        for (n = 0; n < this.fGrammarCount && this.fNamespaces[n] != string; ++n) {
        }
        if (n == this.fGrammarCount) {
            return null;
        }
        if (this.fNSComponents[n][s] == null) {
            SymbolHash symbolHash = null;
            switch (s) {
                case 3: 
                case 13: 
                case 14: {
                    symbolHash = this.fGrammarList[n].fGlobalTypeDecls;
                    break;
                }
                case 1: {
                    symbolHash = this.fGrammarList[n].fGlobalAttrDecls;
                    break;
                }
                case 2: {
                    symbolHash = this.fGrammarList[n].fGlobalElemDecls;
                    break;
                }
                case 5: {
                    symbolHash = this.fGrammarList[n].fGlobalAttrGrpDecls;
                    break;
                }
                case 6: {
                    symbolHash = this.fGrammarList[n].fGlobalGroupDecls;
                    break;
                }
                case 11: {
                    symbolHash = this.fGrammarList[n].fGlobalNotationDecls;
                }
            }
            this.fNSComponents[n][s] = s == 13 || s == 14 ? new XSNamedMap4Types(string, symbolHash, s) : new XSNamedMapImpl(string, symbolHash);
        }
        return this.fNSComponents[n][s];
    }

    public XSTypeDefinition getTypeDefinition(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSTypeDefinition)schemaGrammar.fGlobalTypeDecls.get(string);
    }

    public XSAttributeDeclaration getAttributeDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSAttributeDeclaration)schemaGrammar.fGlobalAttrDecls.get(string);
    }

    public XSElementDeclaration getElementDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSElementDeclaration)schemaGrammar.fGlobalElemDecls.get(string);
    }

    public XSAttributeGroupDefinition getAttributeGroup(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSAttributeGroupDefinition)schemaGrammar.fGlobalAttrGrpDecls.get(string);
    }

    public XSModelGroupDefinition getModelGroupDefinition(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSModelGroupDefinition)schemaGrammar.fGlobalGroupDecls.get(string);
    }

    public XSNotationDeclaration getNotationDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSNotationDeclaration)schemaGrammar.fGlobalNotationDecls.get(string);
    }

    public XSObjectList getAnnotations() {
        return null;
    }

    private static final String null2EmptyString(String string) {
        return string == null ? XMLSymbols.EMPTY_STRING : string;
    }
}

