/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

public class XML11Char {
    public static final byte[] XML11CHARS;
    public static final int MASK_XML11_VALID = 1;
    public static final int MASK_XML11_SPACE = 2;
    public static final int MASK_XML11_NAME_START = 4;
    public static final int MASK_XML11_NAME = 8;
    public static final int MASK_XML11_CONTROL = 16;
    public static final int MASK_XML11_CONTENT = 32;
    public static final int MASK_XML11_NCNAME_START = 64;
    public static final int MASK_XML11_NCNAME = 128;

    public static boolean isXML11Space(int n) {
        return n < 65536 && (XML11CHARS[n] & 2) != 0;
    }

    public static boolean isXML11Valid(int n) {
        return n < 65536 && (XML11CHARS[n] & 1) != 0 || 65536 <= n && n <= 0x10FFFF;
    }

    public static boolean isXML11Invalid(int n) {
        return !XML11Char.isXML11Valid(n);
    }

    public static boolean isXML11ValidLiteral(int n) {
        return n < 65536 && (XML11CHARS[n] & 1) != 0 && (XML11CHARS[n] & 0x10) == 0 || 65536 <= n && n <= 0x10FFFF;
    }

    public static boolean isXML11Content(int n) {
        return n < 65536 && (XML11CHARS[n] & 0x20) != 0 || 65536 <= n && n <= 0x10FFFF;
    }

    public static boolean isXML11NameStart(int n) {
        return n < 65536 && (XML11CHARS[n] & 4) != 0 || 65536 <= n && n < 983040;
    }

    public static boolean isXML11Name(int n) {
        return n < 65536 && (XML11CHARS[n] & 8) != 0 || n >= 65536 && n < 983040;
    }

    public static boolean isXML11NCNameStart(int n) {
        return n < 65536 && (XML11CHARS[n] & 0x40) != 0 || 65536 <= n && n < 983040;
    }

    public static boolean isXML11NCName(int n) {
        return n < 65536 && (XML11CHARS[n] & 0x80) != 0 || 65536 <= n && n < 983040;
    }

    public static boolean isXML11ValidName(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!XML11Char.isXML11NameStart(c)) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (XML11Char.isXML11Name(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isXML11ValidNCName(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!XML11Char.isXML11NCNameStart(c)) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (XML11Char.isXML11NCName(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isXML11ValidNmtoken(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (XML11Char.isXML11Name(c)) continue;
            return false;
        }
        return true;
    }

    static {
        int n;
        int n2;
        XML11CHARS = new byte[65536];
        int[] nArray = new int[]{33, 126, 160, 8231, 8233, 55295, 57344, 65533};
        int[] nArray2 = new int[]{9, 10, 13, 32, 133, 8232};
        int[] nArray3 = new int[]{1, 8, 11, 12, 14, 31, 127, 132, 134, 159};
        int[] nArray4 = new int[]{58, 58, 65, 90, 95, 95, 97, 122, 192, 767, 880, 893, 895, 8191, 8204, 8205, 8304, 8591, 11264, 12271, 12289, 55295, 63744, 65533};
        int[] nArray5 = new int[]{45, 45, 46, 46, 48, 57, 183, 183, 768, 879, 8255, 8256};
        int[] nArray6 = new int[]{60, 38, 10, 13, 93};
        for (n2 = 0; n2 < nArray.length; n2 += 2) {
            n = nArray[n2];
            while (n <= nArray[n2 + 1]) {
                int n3 = n++;
                XML11CHARS[n3] = (byte)(XML11CHARS[n3] | 0x21);
            }
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            int n4 = nArray2[n2];
            XML11CHARS[n4] = (byte)(XML11CHARS[n4] | 0x23);
        }
        for (n2 = 0; n2 < nArray3.length; n2 += 2) {
            n = nArray3[n2];
            while (n <= nArray3[n2 + 1]) {
                int n5 = n++;
                XML11CHARS[n5] = (byte)(XML11CHARS[n5] | 0x11);
            }
        }
        for (n2 = 0; n2 < nArray4.length; n2 += 2) {
            n = nArray4[n2];
            while (n <= nArray4[n2 + 1]) {
                int n6 = n++;
                XML11CHARS[n6] = (byte)(XML11CHARS[n6] | 0xCC);
            }
        }
        for (n2 = 0; n2 < nArray5.length; n2 += 2) {
            n = nArray5[n2];
            while (n <= nArray5[n2 + 1]) {
                int n7 = n++;
                XML11CHARS[n7] = (byte)(XML11CHARS[n7] | 0x88);
            }
        }
        XML11CHARS[58] = (byte)(XML11CHARS[58] & 0xFFFFFF3F);
        for (n2 = 0; n2 < nArray6.length; ++n2) {
            int n8 = nArray6[n2];
            XML11CHARS[n8] = (byte)(XML11CHARS[n8] & 0xFFFFFFDF);
        }
    }
}

