/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.csiro.svg.dom.BasicShape;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGAnimatedStringImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGElementImpl;
import org.csiro.svg.dom.SVGGraphic;
import org.csiro.svg.dom.SVGImageElementImpl;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGMatrixImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.csiro.svg.dom.SVGUseElementImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGTransformable;
import org.w3c.dom.svg.SVGUseElement;

public class SVGAElementImpl
extends SVGGraphic
implements SVGAElement,
Drawable {
    protected SVGAnimatedString href;
    protected SVGAnimatedString target;
    boolean display = true;
    float opacity = 1.0f;
    Shape clipShape = null;
    AffineTransform thisTransform = null;

    public SVGAElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "a");
    }

    public SVGAElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "a");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGAElementImpl sVGAElementImpl = new SVGAElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedStringImpl)this.getHref()).getAnimations();
        Vector vector2 = ((SVGAnimatedStringImpl)this.getTarget()).getAnimations();
        Vector vector3 = ((SVGAnimatedTransformListImpl)this.getTransform()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGAElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGAElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGAElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGAElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGAElementImpl;
    }

    public String getXlinkType() {
        return this.getAttribute("xlink:type");
    }

    public void setXlinkType(String string) throws DOMException {
        this.setAttribute("xlink:type", string);
    }

    public String getXlinkRole() {
        return this.getAttribute("xlink:role");
    }

    public void setXlinkRole(String string) throws DOMException {
        this.setAttribute("xlink:role", string);
    }

    public String getXlinkArcRole() {
        return this.getAttribute("xlink:arcrole");
    }

    public void setXlinkArcRole(String string) throws DOMException {
        this.setAttribute("xlink:arcrole", string);
    }

    public String getXlinkTitle() {
        return this.getAttribute("xlink:title");
    }

    public void setXlinkTitle(String string) throws DOMException {
        this.setAttribute("xlink:title", string);
    }

    public String getXlinkShow() {
        return this.getAttribute("xlink:show");
    }

    public void setXlinkShow(String string) throws DOMException {
        this.setAttribute("xlink:show", string);
    }

    public String getXlinkActuate() {
        return this.getAttribute("xlink:actuate");
    }

    public void setXlinkActuate(String string) throws DOMException {
        this.setAttribute("xlink:actuate", string);
    }

    public SVGAnimatedString getHref() {
        if (this.href == null) {
            this.href = new SVGAnimatedStringImpl("", this);
        }
        return this.href;
    }

    public SVGAnimatedString getTarget() {
        if (this.target == null) {
            this.target = new SVGAnimatedStringImpl("", this);
        }
        return this.target;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("xlink:href")) {
            return this.getHref().getBaseVal();
        }
        if (string.equalsIgnoreCase("target")) {
            return this.getTarget().getBaseVal();
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("xlink:href")) {
            attr.setValue(this.getHref().getBaseVal());
        } else if (string.equalsIgnoreCase("target")) {
            attr.setValue(this.getTarget().getBaseVal());
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        if (string.equalsIgnoreCase("xlink:href")) {
            this.getHref().setBaseVal(string2);
        } else if (string.equalsIgnoreCase("target")) {
            this.getTarget().setBaseVal(string2);
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        String string = attr.getName();
        String string2 = attr.getValue();
        if (string.equalsIgnoreCase("xlink:href")) {
            this.getHref().setBaseVal(string2);
        } else if (string.equalsIgnoreCase("target")) {
            this.getTarget().setBaseVal(string2);
        }
        return super.setAttributeNode(attr);
    }

    public void draw(Graphics2D graphics2D, boolean bl) {
        Object object;
        if (bl || this.thisTransform == null) {
            this.refreshData();
            this.display = this.getDisplay();
            this.opacity = this.getOpacity();
            object = this.getClippingPath();
            this.clipShape = null;
            if (object != null) {
                this.clipShape = ((SVGClipPathElementImpl)object).getClippingShape(this);
            }
            this.thisTransform = ((SVGTransformListImpl)this.getTransform().getAnimVal()).getAffineTransform();
        }
        if (this.display && this.opacity > 0.0f) {
            object = graphics2D.getTransform();
            Shape shape = graphics2D.getClip();
            graphics2D.transform(this.thisTransform);
            if (this.clipShape != null) {
                graphics2D.clip(this.clipShape);
            }
            if (this.opacity < 1.0f) {
                SVGSVGElement sVGSVGElement = this.getOwnerDoc().getRootElement();
                float f = sVGSVGElement.getCurrentScale();
                SVGPoint sVGPoint = sVGSVGElement.getCurrentTranslate();
                if (sVGPoint == null) {
                    sVGPoint = new SVGPointImpl();
                }
                Shape shape2 = this.getCompositeShape();
                AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
                Shape shape3 = affineTransform.createTransformedShape(shape2);
                Rectangle2D rectangle2D = shape3.getBounds2D();
                double d = rectangle2D.getWidth() / 5.0;
                double d2 = rectangle2D.getHeight() / 5.0;
                rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d2);
                int n = (int)(rectangle2D.getWidth() * (double)f);
                int n2 = (int)(rectangle2D.getHeight() * (double)f);
                if (n > 0 && n2 > 0) {
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
                    Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D2.setRenderingHints(renderingHints);
                    if (f != 1.0f) {
                        graphics2D2.scale(f, f);
                    }
                    graphics2D2.translate(-rectangle2D.getX(), -rectangle2D.getY());
                    graphics2D2.transform(affineTransform);
                    this.drawChildren(graphics2D2, bl);
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
                    graphics2D.setComposite(alphaComposite);
                    AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY());
                    affineTransform2.scale(1.0f / f, 1.0f / f);
                    try {
                        affineTransform2.preConcatenate(affineTransform.createInverse());
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    graphics2D.drawImage(bufferedImage, affineTransform2, null);
                    graphics2D.setComposite(composite);
                    bufferedImage.flush();
                }
            } else {
                this.drawChildren(graphics2D, bl);
            }
            graphics2D.setTransform((AffineTransform)object);
            graphics2D.setClip(shape);
        }
    }

    private void drawChildren(Graphics2D graphics2D, boolean bl) {
        int n;
        Vector<Node> vector = new Vector<Node>();
        if (this.hasChildNodes()) {
            NodeList nodeList = this.getChildNodes();
            n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node instanceof Drawable) {
                    vector.add(node);
                }
                ++n2;
            }
        }
        int n3 = vector.size();
        n = 0;
        while (n < n3) {
            Drawable drawable = (Drawable)vector.elementAt(n);
            drawable.draw(graphics2D, bl);
            ++n;
        }
    }

    public SVGRect getBBox() {
        Shape shape = this.getCompositeShape();
        Rectangle2D rectangle2D = shape.getBounds2D();
        SVGRectImpl sVGRectImpl = new SVGRectImpl(rectangle2D);
        return sVGRectImpl;
    }

    Shape getCompositeShape() {
        GeneralPath generalPath = new GeneralPath();
        if (this.hasChildNodes()) {
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                AffineTransform affineTransform;
                Object object;
                Node node = nodeList.item(n2);
                Shape shape = null;
                if (node instanceof BasicShape) {
                    shape = ((BasicShape)((Object)node)).getShape();
                } else if (node instanceof SVGGElementImpl) {
                    shape = ((SVGGElementImpl)node).getCompositeShape();
                } else if (node instanceof SVGAElementImpl) {
                    shape = ((SVGAElementImpl)node).getCompositeShape();
                } else if (node instanceof SVGImageElementImpl) {
                    object = ((SVGImageElement)node).getBBox();
                    shape = new Rectangle2D.Float(object.getX(), object.getY(), object.getWidth(), object.getHeight());
                } else if (node instanceof SVGUseElementImpl) {
                    object = ((SVGUseElement)node).getBBox();
                    shape = new Rectangle2D.Float(object.getX(), object.getY(), object.getWidth(), object.getHeight());
                } else if (node instanceof SVGSVGElementImpl) {
                    AffineTransform affineTransform2;
                    object = (SVGSVGElement)node;
                    affineTransform = ((SVGMatrixImpl)this.getCTM()).getAffineTransform();
                    try {
                        affineTransform2 = affineTransform.createInverse();
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        affineTransform2 = null;
                    }
                    float f = ((SVGLengthImpl)((Object)object.getX())).getTransformedLength(affineTransform2);
                    float f2 = ((SVGLengthImpl)((Object)object.getY())).getTransformedLength(affineTransform2);
                    float f3 = ((SVGLengthImpl)((Object)object.getWidth())).getTransformedLength(affineTransform2);
                    float f4 = ((SVGLengthImpl)((Object)object.getHeight())).getTransformedLength(affineTransform2);
                    shape = new Rectangle2D.Float(f, f2, f3, f4);
                }
                if (node instanceof SVGTransformable) {
                    object = ((SVGTransformable)((Object)node)).getTransform();
                    affineTransform = ((SVGTransformListImpl)object.getAnimVal()).getAffineTransform();
                    shape = affineTransform.createTransformedShape(shape);
                }
                if (shape != null) {
                    generalPath.append(shape, false);
                }
                ++n2;
            }
        }
        return generalPath;
    }

    public Vector getElementsThatContain(double d, double d2) {
        Vector<Node> vector = new Vector<Node>();
        if (this.hasChildNodes()) {
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node instanceof BasicShape && node instanceof Drawable) {
                    boolean bl = ((Drawable)((Object)node)).contains(d, d2);
                    if (bl) {
                        vector.addElement(node);
                    }
                } else if (node instanceof SVGImageElementImpl) {
                    boolean bl = ((SVGImageElementImpl)node).contains(d, d2);
                    if (bl) {
                        vector.addElement(node);
                    }
                } else if (node instanceof SVGUseElementImpl) {
                    boolean bl = ((SVGUseElementImpl)node).contains(d, d2);
                    if (bl) {
                        vector.addElement(node);
                    }
                } else if (node instanceof SVGSVGElementImpl) {
                    Vector vector2 = ((SVGSVGElementImpl)node).getElementsThatContain(d, d2);
                    vector.addAll(vector2);
                } else if (node instanceof SVGGElementImpl) {
                    Vector vector3 = ((SVGGElementImpl)node).getElementsThatContain(d, d2);
                    vector.addAll(vector3);
                } else if (node instanceof SVGAElementImpl) {
                    Vector vector4 = ((SVGAElementImpl)node).getElementsThatContain(d, d2);
                    vector.addAll(vector4);
                }
                ++n2;
            }
        }
        if (vector.size() > 0) {
            vector.insertElementAt(this, 0);
        }
        return vector;
    }

    public boolean contains(double d, double d2) {
        if (this.hasChildNodes()) {
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                boolean bl;
                Node node = nodeList.item(n2);
                if (node instanceof Drawable && (bl = ((Drawable)((Object)node)).contains(d, d2))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public double boundingArea() {
        Shape shape = this.getCompositeShape();
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        return rectangle2D.getWidth() * rectangle2D.getHeight();
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("xlink:href")) {
            ((SVGAnimatedValue)((Object)this.getHref())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("target")) {
            ((SVGAnimatedValue)((Object)this.getTarget())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

