/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import org.csiro.svg.dom.SVGExceptionImpl;
import org.w3c.dom.svg.SVGAngle;
import org.w3c.dom.svg.SVGException;

public class SVGAngleImpl
implements SVGAngle {
    short unitType;
    float value;
    float valueInSpecifiedUnits;
    String valueAsString;
    float animatedValue;

    public SVGAngleImpl() {
        this.unitType = (short)2;
        this.setValue(0.0f);
    }

    public SVGAngleImpl(float f) {
        this.unitType = (short)2;
        this.setValue(f);
    }

    public SVGAngleImpl(String string) {
        this.setCSSText(string);
    }

    public SVGAngleImpl(SVGAngle sVGAngle) {
        this.setCSSText(sVGAngle.getValueAsString());
    }

    public short getUnitType() {
        return this.unitType;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float f) {
        this.value = f;
        this.valueInSpecifiedUnits = this.convertFromDegrees(f, this.unitType);
        this.valueAsString = String.valueOf(this.valueInSpecifiedUnits);
    }

    public float getValueInSpecifiedUnits() {
        return this.valueInSpecifiedUnits;
    }

    public void setValueInSpecifiedUnits(float f) {
        this.valueInSpecifiedUnits = f;
        this.valueAsString = String.valueOf(f);
        this.value = this.convertToDegrees(f, this.unitType);
    }

    public String getValueAsString() {
        return this.valueAsString;
    }

    public void setValueAsString(String string) {
        this.valueAsString = string;
        this.valueInSpecifiedUnits = Float.parseFloat(string);
        this.value = this.convertToDegrees(this.valueInSpecifiedUnits, this.unitType);
    }

    public void newValueSpecifiedUnits(short s, float f) throws SVGException {
        this.checkUnitType(s);
        this.unitType = s;
        this.setValueInSpecifiedUnits(f);
    }

    public void convertToSpecifiedUnits(short s) throws SVGException {
        this.checkUnitType(s);
        this.unitType = s;
        this.setValue(this.value);
    }

    private void checkUnitType(short s) throws SVGException {
        if (s != 2 && s != 4 && s != 3 && s != 1) {
            throw new SVGExceptionImpl(0, "Invalid unit type for SVGAngle");
        }
    }

    private float convertToDegrees(float f, short s) {
        if (s == 2 || s == 1) {
            return f;
        }
        if (s == 3) {
            return (float)Math.toDegrees(f);
        }
        if (s == 4) {
            return (float)((double)f * 9.0 / 10.0);
        }
        return f;
    }

    private float convertFromDegrees(float f, short s) {
        if (s == 2 || s == 1) {
            return f;
        }
        if (s == 3) {
            return (float)Math.toRadians(f);
        }
        if (s == 4) {
            return (float)((double)f * 10.0 / 9.0);
        }
        return f;
    }

    void setCSSText(String string) {
        String string2 = string.trim();
        int n = -1;
        int n2 = 0;
        while (n2 < string2.length()) {
            if (!Character.isDigit(string2.charAt(n2)) && string2.charAt(n2) != '.' && string2.charAt(n2) != '-' && string2.charAt(n2) != '+') {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            this.value = Float.parseFloat(string2);
            this.unitType = 1;
            this.valueAsString = string2;
            this.valueInSpecifiedUnits = this.value;
        } else {
            String string3 = string2.substring(n);
            this.unitType = SVGAngleImpl.getUnitTypeConst(string3);
            this.valueAsString = string2.substring(0, n);
            this.valueInSpecifiedUnits = Float.parseFloat(this.valueAsString);
            this.value = this.convertToDegrees(this.valueInSpecifiedUnits, this.unitType);
        }
    }

    String getCSSText() {
        return this.valueAsString + SVGAngleImpl.getUnitText(this.unitType);
    }

    private static String getUnitText(short s) {
        switch (s) {
            case 2: {
                return "deg";
            }
            case 4: {
                return "grad";
            }
            case 3: {
                return "rad";
            }
            case 0: {
                return "";
            }
            case 1: {
                return "";
            }
        }
        return "";
    }

    private static short getUnitTypeConst(String string) {
        if (string == null) {
            return 1;
        }
        if (string.equalsIgnoreCase("deg")) {
            return 2;
        }
        if (string.equalsIgnoreCase("grad")) {
            return 4;
        }
        if (string.equalsIgnoreCase("rad")) {
            return 3;
        }
        if (string.equalsIgnoreCase("")) {
            return 1;
        }
        System.out.println("unit type: " + string + ", not a valid svg angle unit");
        return 0;
    }
}

