/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.util.StringTokenizer;
import java.util.Vector;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoCubicAbsImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGStringListImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimationElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGStringList;

public abstract class SVGAnimationElementImpl
extends SVGElementImpl
implements SVGAnimationElement {
    protected SVGStringListImpl requiredFeatures;
    protected SVGStringListImpl requiredExtensions;
    protected SVGStringListImpl systemLanguage;
    protected SVGAnimatedBoolean externalResourcesRequired;
    protected boolean active = false;
    protected boolean finished = false;
    protected float startTime;
    protected float endTime;
    private SVGElementImpl target;
    Object lastCurrentValue = null;
    protected Vector times = null;
    protected Vector vals = null;
    protected Vector splines = null;

    public SVGAnimationElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element, String string) {
        super(sVGDocumentImpl, element, string);
    }

    public SVGAnimationElementImpl(SVGDocumentImpl sVGDocumentImpl, String string) {
        super(sVGDocumentImpl, string);
    }

    public SVGStringList getRequiredFeatures() {
        return this.requiredFeatures;
    }

    public SVGStringList getRequiredExtensions() {
        return this.requiredExtensions;
    }

    public SVGStringList getSystemLanguage() {
        return this.systemLanguage;
    }

    public boolean hasExtension(String string) {
        return string.equalsIgnoreCase("svg");
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return this.externalResourcesRequired;
    }

    public boolean beginElement() throws DOMException {
        String string = this.getAttribute("restart");
        if (this.active && string.equalsIgnoreCase("whenNotActive")) {
            return false;
        }
        if (string.equalsIgnoreCase("never") && (this.active || this.finished)) {
            return false;
        }
        this.startTime = this.getOwnerSVGElement().getCurrentTime();
        this.active = true;
        this.finished = false;
        return true;
    }

    public boolean beginElementAt(float f) throws DOMException {
        String string = this.getAttribute("restart");
        if (this.active && string.equalsIgnoreCase("whenNotActive")) {
            return false;
        }
        if (string.equalsIgnoreCase("never") && (this.active || this.finished)) {
            return false;
        }
        this.startTime = f < 0.0f ? this.getOwnerSVGElement().getCurrentTime() : this.getOwnerSVGElement().getCurrentTime() + f;
        return true;
    }

    public boolean endElement() throws DOMException {
        if (!this.active) {
            return false;
        }
        String string = this.getAttribute("end");
        if (!string.equalsIgnoreCase("indefinite") && string.length() != 0) {
            return false;
        }
        this.active = false;
        this.finished = true;
        this.endTime = this.getOwnerSVGElement().getCurrentTime();
        return true;
    }

    public boolean endElementAt(float f) throws DOMException {
        if (!this.active) {
            return false;
        }
        String string = this.getAttribute("end");
        if (!string.equalsIgnoreCase("indefinite") && string.length() != 0) {
            return false;
        }
        this.endTime = f < 0.0f ? this.getOwnerSVGElement().getCurrentTime() : this.getOwnerSVGElement().getCurrentTime() + f;
        return true;
    }

    public boolean finished() {
        return this.finished;
    }

    public SVGElement getTargetElement() {
        if (this.target == null) {
            String string = this.getAttribute("xlink:href");
            if (string.length() > 0) {
                int n = string.indexOf(35);
                if (n != -1) {
                    String string2 = string.substring(n + 1, string.length());
                    this.target = (SVGElementImpl)this.getOwnerDoc().getElementById(string2);
                }
            } else {
                this.target = (SVGElementImpl)this.getParentNode();
            }
        }
        return this.target;
    }

    public float getStartTime() {
        if (this.getAttribute("begin").equalsIgnoreCase("indefinite")) {
            if (this.active) {
                return this.startTime;
            }
            return Float.MAX_VALUE;
        }
        return this.getBeginTime();
    }

    public float getCurrentTime() {
        if (this.getAttribute("begin").equalsIgnoreCase("indefinite")) {
            return this.getOwnerSVGElement().getCurrentTime() - this.startTime;
        }
        return this.getOwnerSVGElement().getCurrentTime();
    }

    public float getSimpleDuration() throws DOMException {
        float f = this.getDuration();
        if (f < 0.0f) {
            throw new DOMException(9, "Simple duration is not defined for this animation element");
        }
        return f;
    }

    String getAttributeName() {
        return this.getAttribute("attributeName");
    }

    String getAttributeType() {
        String string = this.getAttribute("attributeType");
        if (string.length() > 0) {
            return string;
        }
        return "auto";
    }

    float getBeginTime() {
        String string = this.getAttribute("begin");
        if (!string.equalsIgnoreCase("indefinite") && string.length() > 0) {
            return this.getClockSecs(string);
        }
        return 0.0f;
    }

    float getDuration() {
        String string = this.getAttribute("dur");
        if (string.equalsIgnoreCase("indefinite") || string.length() == 0) {
            return -1.0f;
        }
        float f = this.getClockSecs(string);
        if (f == 0.0f) {
            return -1.0f;
        }
        return f;
    }

    float getEndTime() {
        String string = this.getAttribute("end");
        if (string.equalsIgnoreCase("indefinite") || string.length() == 0) {
            return -1.0f;
        }
        float f = this.getClockSecs(string);
        if (f == 0.0f) {
            return -1.0f;
        }
        return f;
    }

    float getRepeatCount() {
        String string = this.getAttribute("repeatCount");
        if (string.equalsIgnoreCase("indefinite")) {
            return -1.0f;
        }
        if (string.length() == 0) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    float getRepeatDuration() {
        String string = this.getAttribute("repeatDur");
        if (string.equalsIgnoreCase("indefinite")) {
            return -1.0f;
        }
        if (string.length() == 0) {
            return 0.0f;
        }
        return this.getClockSecs(string);
    }

    boolean fillFreeze() {
        String string = this.getAttribute("fill");
        return !string.equalsIgnoreCase("remove") && string.length() != 0;
    }

    protected float getClockSecs(String string) {
        try {
            if (string.indexOf(":") != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                int n = stringTokenizer.countTokens();
                if (n == 3) {
                    int n2 = Integer.parseInt(stringTokenizer.nextToken());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    float f = Float.parseFloat(stringTokenizer.nextToken());
                    return (float)(n2 * 3600 + n3 * 60) + f;
                }
                if (n == 2) {
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    float f = Float.parseFloat(stringTokenizer.nextToken());
                    return (float)(n4 * 60) + f;
                }
                System.out.println("Invalid clock value: " + string + ", will use the default value 0");
                return 0.0f;
            }
            if (string.indexOf("h") != -1) {
                float f = Float.parseFloat(string.substring(0, string.indexOf("h")));
                return f * 3600.0f;
            }
            if (string.indexOf("min") != -1) {
                float f = Float.parseFloat(string.substring(0, string.indexOf("min")));
                return f * 60.0f;
            }
            if (string.indexOf("ms") != -1) {
                float f = Float.parseFloat(string.substring(0, string.indexOf("ms")));
                return (float)((double)f / 1000.0);
            }
            if (string.indexOf("s") != -1) {
                float f = Float.parseFloat(string.substring(0, string.indexOf("s")));
                return f;
            }
            float f = Float.parseFloat(string);
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("cannot decode time: " + string);
            return 0.0f;
        }
    }

    public abstract Object getCurrentValue(short var1);

    protected float getNumRepeats(float f) {
        String string = this.getAttribute("repeatCount");
        String string2 = this.getAttribute("repeatDur");
        if (!(string.length() <= 0 && string2.length() <= 0 || string.equalsIgnoreCase("indefinite") || string2.equalsIgnoreCase("indefinite"))) {
            if (string.length() > 0 && string2.length() == 0) {
                return Float.parseFloat(string);
            }
            if (string.length() == 0 && string2.length() > 0) {
                return this.getClockSecs(string2) / f;
            }
            return Math.min(Float.parseFloat(string), this.getClockSecs(string2) / f);
        }
        return 1.0f;
    }

    protected boolean getRepeatForever() {
        return this.getAttribute("repeatCount").equalsIgnoreCase("indefinite") || this.getAttribute("repeatDur").equalsIgnoreCase("indefinite");
    }

    protected float checkStatus(float f, float f2, float f3, float f4, boolean bl) {
        if (f < f2) {
            this.active = false;
            return -1.0f;
        }
        if (f >= f2 && (bl || f < f2 + f3 * f4)) {
            this.active = true;
            int n = (int)Math.floor((f - f2) / f3);
            return (f - f2 - (float)n * f3) / f3;
        }
        this.active = false;
        this.finished = true;
        if (this.getAttribute("fill").equalsIgnoreCase("remove")) {
            return -1.0f;
        }
        f = f2 + f3 * f4;
        int n = (int)Math.floor((f - f2) / f3);
        if ((float)n == f4) {
            --n;
        }
        return (f - f2 - (float)n * f3) / f3;
    }

    protected void setupTimeValueVectors(String string, String string2) {
        Object object;
        this.times = new Vector();
        this.vals = new Vector();
        String string3 = this.getAttribute("keyTimes");
        if (string3.length() == 0) {
            float f;
            if (string.equalsIgnoreCase("paced")) {
                object = new StringTokenizer(string2, ";");
                int n = ((StringTokenizer)object).countTokens();
                f = 0.0f;
                int n2 = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    if (n2 == 0 || n2 == n - 1) {
                        this.times.addElement(new Float(f));
                        f = 1.0f;
                        this.vals.addElement(((StringTokenizer)object).nextToken());
                    } else {
                        ((StringTokenizer)object).nextToken();
                    }
                    ++n2;
                }
            } else {
                object = new StringTokenizer(string2, ";");
                int n = ((StringTokenizer)object).countTokens();
                f = (float)(1.0 / (double)(n - 1));
                float f2 = 0.0f;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.times.addElement(new Float(f2));
                    f2 += f;
                    this.vals.addElement(((StringTokenizer)object).nextToken());
                }
            }
        } else {
            object = new StringTokenizer(string3, ";");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (((StringTokenizer)object).hasMoreTokens() && stringTokenizer.hasMoreTokens()) {
                this.times.addElement(new Float(((StringTokenizer)object).nextToken()));
                this.vals.addElement(stringTokenizer.nextToken());
            }
        }
        if (string.equals("spline") && this.getAttribute("keySplines").length() > 0) {
            this.splines = new Vector();
            object = this.getAttribute("keySplines");
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ", ");
                if (stringTokenizer2.countTokens() != 4) continue;
                float f = Float.parseFloat(stringTokenizer2.nextToken());
                float f3 = Float.parseFloat(stringTokenizer2.nextToken());
                float f4 = Float.parseFloat(stringTokenizer2.nextToken());
                float f5 = Float.parseFloat(stringTokenizer2.nextToken());
                SVGPathSegCurvetoCubicAbsImpl sVGPathSegCurvetoCubicAbsImpl = new SVGPathSegCurvetoCubicAbsImpl(1.0f, 1.0f, f, f3, f4, f5);
                this.splines.addElement(sVGPathSegCurvetoCubicAbsImpl);
            }
        }
    }

    protected float getSplineValueAt(int n, float f) {
        SVGPathSegCurvetoCubicAbsImpl sVGPathSegCurvetoCubicAbsImpl = (SVGPathSegCurvetoCubicAbsImpl)this.splines.elementAt(n);
        return sVGPathSegCurvetoCubicAbsImpl.getYAt(f, new SVGPointImpl(0.0f, 0.0f));
    }
}

