/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.csiro.svg.dom.BasicShape;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGGraphic;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGMatrixImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGTexturePaint;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGCircleElementImpl
extends SVGGraphic
implements SVGCircleElement,
Drawable,
BasicShape {
    protected SVGAnimatedLength cx;
    protected SVGAnimatedLength cy;
    protected SVGAnimatedLength r;
    boolean visible = true;
    boolean display = true;
    float opacity = 1.0f;
    Shape clipShape = null;
    Shape shape = null;
    BasicStroke stroke = null;
    Paint fillPaint = null;
    Paint linePaint = null;
    AffineTransform thisTransform = null;

    public SVGCircleElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "circle");
        super.setAttribute("cx", this.getCx().getBaseVal().getValueAsString());
        super.setAttribute("cy", this.getCy().getBaseVal().getValueAsString());
        super.setAttribute("r", this.getR().getBaseVal().getValueAsString());
    }

    public SVGCircleElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "circle");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGCircleElementImpl sVGCircleElementImpl = new SVGCircleElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthImpl)this.getCx()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthImpl)this.getCy()).getAnimations();
        Vector vector3 = ((SVGAnimatedLengthImpl)this.getR()).getAnimations();
        Vector vector4 = ((SVGAnimatedTransformListImpl)this.getTransform()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGCircleElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGCircleElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGCircleElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGCircleElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGCircleElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGCircleElementImpl;
    }

    public SVGAnimatedLength getCx() {
        if (this.cx == null) {
            this.cx = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 0), this);
        }
        return this.cx;
    }

    public SVGAnimatedLength getCy() {
        if (this.cy == null) {
            this.cy = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 1), this);
        }
        return this.cy;
    }

    public SVGAnimatedLength getR() {
        if (this.r == null) {
            this.r = new SVGAnimatedLengthImpl(new SVGLengthImpl(0.0f, (SVGElement)this, 2), this);
        }
        return this.r;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("cx")) {
            return this.getCx().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("cy")) {
            return this.getCy().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("r")) {
            return this.getR().getBaseVal().getValueAsString();
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("cx")) {
            attr.setValue(this.getCx().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("cy")) {
            attr.setValue(this.getCy().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("r")) {
            attr.setValue(this.getR().getBaseVal().getValueAsString());
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        this.setAttributeValue(string, string2);
        super.setAttribute(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("cx")) {
            this.getCx().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("cy")) {
            this.getCy().getBaseVal().setValueAsString(string2);
        } else if (string.equalsIgnoreCase("r")) {
            this.getR().getBaseVal().setValueAsString(string2);
        }
    }

    private Shape createShape(AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        try {
            affineTransform2 = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            affineTransform2 = null;
        }
        float f = ((SVGLengthImpl)this.getCx().getAnimVal()).getTransformedLength(affineTransform2);
        float f2 = ((SVGLengthImpl)this.getCy().getAnimVal()).getTransformedLength(affineTransform2);
        float f3 = ((SVGLengthImpl)this.getR().getAnimVal()).getTransformedLength(affineTransform2);
        Ellipse2D.Float float_ = new Ellipse2D.Float(f - f3, f2 - f3, 2.0f * f3, 2.0f * f3);
        return float_;
    }

    public void draw(Graphics2D graphics2D, boolean bl) {
        Object object;
        if (bl || this.shape == null) {
            this.refreshData();
            this.visible = this.getVisibility();
            this.display = this.getDisplay();
            this.opacity = this.getOpacity();
            object = this.getClippingPath();
            this.clipShape = null;
            if (object != null) {
                this.clipShape = ((SVGClipPathElementImpl)object).getClippingShape(this);
            }
            this.thisTransform = new AffineTransform();
            if (this.transform != null) {
                this.thisTransform = ((SVGTransformListImpl)this.transform.getAnimVal()).getAffineTransform();
            }
            this.shape = this.createShape(((SVGMatrixImpl)this.getCTM()).getAffineTransform());
            this.stroke = this.getStroke();
            this.fillPaint = this.getFillPaint();
            this.linePaint = this.getLinePaint();
        } else {
            if (this.fillPaint != null && this.fillPaint instanceof SVGTexturePaint && ((SVGTexturePaint)this.fillPaint).getTextureType() == 2) {
                this.fillPaint = this.getFillPaint();
            }
            if (this.linePaint != null && this.linePaint instanceof SVGTexturePaint && ((SVGTexturePaint)this.linePaint).getTextureType() == 2) {
                this.linePaint = this.getLinePaint();
            }
        }
        if (this.visible && this.display && this.opacity > 0.0f) {
            object = graphics2D.getTransform();
            Shape shape = graphics2D.getClip();
            if (this.thisTransform != null) {
                graphics2D.transform(this.thisTransform);
            }
            if (this.clipShape != null) {
                graphics2D.clip(this.clipShape);
            }
            if (this.opacity < 1.0f) {
                SVGSVGElement sVGSVGElement = this.getOwnerDoc().getRootElement();
                float f = sVGSVGElement.getCurrentScale();
                SVGPoint sVGPoint = sVGSVGElement.getCurrentTranslate();
                if (sVGPoint == null) {
                    sVGPoint = new SVGPointImpl();
                }
                Shape shape2 = this.getShape();
                AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
                Shape shape3 = affineTransform.createTransformedShape(shape2);
                Rectangle2D rectangle2D = shape3.getBounds2D();
                double d = rectangle2D.getWidth() / 5.0;
                double d2 = rectangle2D.getHeight() / 5.0;
                rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d2);
                int n = (int)(rectangle2D.getWidth() * (double)f);
                int n2 = (int)(rectangle2D.getHeight() * (double)f);
                if (n > 0 && n2 > 0) {
                    Object object2;
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
                    Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D2.setRenderingHints(renderingHints);
                    if (f != 1.0f) {
                        graphics2D2.scale(f, f);
                    }
                    graphics2D2.translate(-rectangle2D.getX(), -rectangle2D.getY());
                    graphics2D2.transform(affineTransform);
                    graphics2D2.setStroke(this.stroke);
                    if (this.fillPaint != null) {
                        graphics2D2.setPaint(this.fillPaint);
                        graphics2D2.fill(shape2);
                    }
                    if (this.linePaint != null) {
                        graphics2D2.setPaint(this.linePaint);
                        graphics2D2.draw(shape2);
                    }
                    if (this.highlighted) {
                        graphics2D2.setPaint(Color.yellow);
                        object2 = this.getBBox();
                        graphics2D2.draw(new Rectangle2D.Float(object2.getX(), object2.getY(), object2.getWidth(), object2.getHeight()));
                    }
                    object2 = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
                    graphics2D.setComposite(alphaComposite);
                    AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY());
                    affineTransform2.scale(1.0f / f, 1.0f / f);
                    try {
                        affineTransform2.preConcatenate(affineTransform.createInverse());
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    graphics2D.drawImage(bufferedImage, affineTransform2, null);
                    graphics2D.setComposite((Composite)object2);
                    bufferedImage.flush();
                }
            } else {
                graphics2D.setStroke(this.stroke);
                if (this.fillPaint != null) {
                    graphics2D.setPaint(this.fillPaint);
                    graphics2D.fill(this.shape);
                }
                if (this.linePaint != null) {
                    graphics2D.setPaint(this.linePaint);
                    graphics2D.draw(this.shape);
                }
                if (this.highlighted) {
                    graphics2D.setPaint(Color.yellow);
                    SVGRect sVGRect = this.getBBox();
                    graphics2D.draw(new Rectangle2D.Float(sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight()));
                }
            }
            graphics2D.setTransform((AffineTransform)object);
            graphics2D.setClip(shape);
        }
    }

    public Shape getShape() {
        if (this.shape == null) {
            AffineTransform affineTransform = ((SVGMatrixImpl)this.getCTM()).getAffineTransform();
            return this.createShape(affineTransform);
        }
        return this.shape;
    }

    public SVGRect getBBox() {
        Shape shape = this.getShape();
        Rectangle2D rectangle2D = shape.getBounds2D();
        SVGRectImpl sVGRectImpl = new SVGRectImpl(rectangle2D);
        return sVGRectImpl;
    }

    public boolean contains(double d, double d2) {
        Shape shape = this.getShape();
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2.contains(d, d2);
    }

    public double boundingArea() {
        Shape shape = this.getShape();
        AffineTransform affineTransform = ((SVGMatrixImpl)this.getScreenCTM()).getAffineTransform();
        Shape shape2 = affineTransform.createTransformedShape(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        return rectangle2D.getWidth() * rectangle2D.getHeight();
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("cx")) {
            ((SVGAnimatedValue)((Object)this.getCx())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("cy")) {
            ((SVGAnimatedValue)((Object)this.getCy())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("r")) {
            ((SVGAnimatedValue)((Object)this.getR())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

