/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import org.csiro.svg.dom.BasicShape;
import org.csiro.svg.dom.SVGAnimatedBooleanImpl;
import org.csiro.svg.dom.SVGAnimatedEnumerationImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.dom.SVGStringListImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.csiro.svg.dom.SVGTransformableImpl;
import org.csiro.svg.dom.SVGUseElementImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGClipPathElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGStringList;
import org.w3c.dom.svg.SVGTransformable;

public class SVGClipPathElementImpl
extends SVGTransformableImpl
implements SVGClipPathElement {
    protected SVGAnimatedEnumeration clipPathUnits;
    protected SVGAnimatedBoolean externalResourcesRequired;
    private static Vector clipPathUnitStrings;
    private static Vector clipPathUnitValues;
    protected SVGStringListImpl requiredFeatures;
    protected SVGStringListImpl requiredExtensions;
    protected SVGStringListImpl systemLanguage;

    public SVGClipPathElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "clipPath");
    }

    public SVGClipPathElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "clipPath");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGClipPathElementImpl sVGClipPathElementImpl = new SVGClipPathElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedTransformListImpl)this.getTransform()).getAnimations();
        Vector vector2 = ((SVGAnimatedEnumerationImpl)this.getClipPathUnits()).getAnimations();
        Vector vector3 = ((SVGAnimatedBooleanImpl)this.getExternalResourcesRequired()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGClipPathElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGClipPathElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGClipPathElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGClipPathElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGClipPathElementImpl;
    }

    public SVGAnimatedEnumeration getClipPathUnits() {
        if (this.clipPathUnits == null) {
            if (clipPathUnitStrings == null) {
                this.initClipPathUnitVectors();
            }
            this.clipPathUnits = new SVGAnimatedEnumerationImpl(1, this, clipPathUnitStrings, clipPathUnitValues);
        }
        return this.clipPathUnits;
    }

    private void initClipPathUnitVectors() {
        if (clipPathUnitStrings == null) {
            clipPathUnitStrings = new Vector();
            clipPathUnitStrings.addElement("userSpaceOnUse");
            clipPathUnitStrings.addElement("objectBoundingBox");
        }
        if (clipPathUnitValues == null) {
            clipPathUnitValues = new Vector();
            clipPathUnitValues.addElement(new Short(1));
            clipPathUnitValues.addElement(new Short(2));
            clipPathUnitValues.addElement(new Short(0));
        }
    }

    public SVGStringList getRequiredFeatures() {
        return this.requiredFeatures;
    }

    public SVGStringList getRequiredExtensions() {
        return this.requiredExtensions;
    }

    public SVGStringList getSystemLanguage() {
        return this.systemLanguage;
    }

    public boolean hasExtension(String string) {
        return string.equalsIgnoreCase("svg");
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        if (this.externalResourcesRequired == null) {
            this.externalResourcesRequired = new SVGAnimatedBooleanImpl(false, this);
        }
        return this.externalResourcesRequired;
    }

    public String getXMLlang() {
        return this.getAttribute("xml:lang");
    }

    public void setXMLlang(String string) {
        if (string != null) {
            this.setAttribute("xml:lang", string);
        } else {
            this.removeAttribute("xml:lang");
        }
    }

    public String getXMLspace() {
        return this.getAttribute("xml:space");
    }

    public void setXMLspace(String string) {
        if (string != null) {
            this.setAttribute("xml:space", string);
        } else {
            this.removeAttribute("xml:space");
        }
    }

    public SVGRect getBBox() {
        Shape shape = this.getClippingShape(this.getOwnerDoc().getRootElement());
        Rectangle2D rectangle2D = shape.getBounds2D();
        SVGRectImpl sVGRectImpl = new SVGRectImpl(rectangle2D);
        return sVGRectImpl;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("clipPathUnits")) {
            if (this.getClipPathUnits().getBaseVal() == 2) {
                return "objectBoundingBox";
            }
            return "userSpaceOnUse";
        }
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                return "true";
            }
            return "false";
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("clipPathUnits")) {
            if (this.getClipPathUnits().getBaseVal() == 2) {
                attr.setValue("objectBoundingBox");
            } else {
                attr.setValue("userSpaceOnUse");
            }
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                attr.setValue("true");
            } else {
                attr.setValue("false");
            }
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("clipPathUnits")) {
            if (string2.equalsIgnoreCase("userSpaceOnUse")) {
                this.getClipPathUnits().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("objectBoundingBox")) {
                this.getClipPathUnits().setBaseVal((short)2);
            } else {
                System.out.println("invalid value '" + string2 + "' for clipPathUnits attribute, setting to default 'userSpaceOnUse'");
                this.getClipPathUnits().setBaseVal((short)1);
            }
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (string2.equalsIgnoreCase("true")) {
                this.getExternalResourcesRequired().setBaseVal(true);
            } else {
                this.getExternalResourcesRequired().setBaseVal(false);
            }
        }
    }

    public Shape getClippingShape(SVGElement sVGElement) {
        Shape shape;
        Object object;
        Object object2;
        Object object3;
        Area area = null;
        AffineTransform affineTransform = null;
        affineTransform = this.transform != null ? ((SVGTransformListImpl)this.transform.getAnimVal()).getAffineTransform() : new AffineTransform();
        if (this.hasChildNodes()) {
            object3 = this.getChildNodes();
            int n = object3.getLength();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                Object object4;
                Cloneable cloneable;
                Object object5;
                Object object6;
                Object object7;
                object2 = object3.item(n2);
                if (object2 instanceof BasicShape) {
                    object = ((BasicShape)object2).getShape();
                    if (object != null) {
                        AffineTransform affineTransform2 = affineTransform;
                        if (object2 instanceof SVGTransformable && (object7 = (SVGAnimatedTransformListImpl)((SVGTransformable)object2).getTransform()) != null) {
                            affineTransform2.concatenate(((SVGTransformListImpl)((SVGAnimatedTransformListImpl)object7).getAnimVal()).getAffineTransform());
                        }
                        object7 = new GeneralPath((Shape)object);
                        ((Path2D.Float)object7).transform(affineTransform2);
                        object6 = ((SVGStylableImpl)object2).getClipRule();
                        object5 = ((SVGStylableImpl)object2).getClippingPath();
                        if (((String)object6).equals("evenodd")) {
                            ((Path2D)object7).setWindingRule(0);
                        } else {
                            ((Path2D)object7).setWindingRule(1);
                        }
                        cloneable = new Area((Shape)object7);
                        if (object5 != null && (object4 = ((SVGClipPathElementImpl)object5).getClippingShape(sVGElement)) != null) {
                            if (cloneable == null) {
                                cloneable = new Area((Shape)object4);
                            } else {
                                ((Area)cloneable).intersect(new Area((Shape)object4));
                            }
                        }
                        if (area == null) {
                            area = cloneable;
                        } else {
                            area.add((Area)cloneable);
                        }
                    }
                } else if (object2 instanceof SVGUseElementImpl && ((String)(object = ((SVGUseElementImpl)object2).getHref().getAnimVal())).length() > 0 && (n3 = ((String)object).indexOf(35)) != -1) {
                    object7 = ((String)object).substring(n3 + 1).trim();
                    object6 = this.getOwnerDoc().getElementById((String)object7);
                    if (object6 != null && object6 instanceof BasicShape) {
                        object5 = ((BasicShape)object6).getShape();
                        if (object5 != null) {
                            Shape shape2;
                            cloneable = affineTransform;
                            if (object6 instanceof SVGTransformable && (object4 = (SVGTransformListImpl)((SVGTransformable)object6).getTransform().getAnimVal()) != null) {
                                ((AffineTransform)cloneable).concatenate(((SVGTransformListImpl)object4).getAffineTransform());
                            }
                            object4 = new GeneralPath((Shape)object5);
                            ((Path2D.Float)object4).transform((AffineTransform)cloneable);
                            String string = ((SVGStylableImpl)object2).getClipRule();
                            SVGClipPathElementImpl sVGClipPathElementImpl = ((SVGStylableImpl)object2).getClippingPath();
                            if (string.equals("evenodd")) {
                                ((Path2D)object4).setWindingRule(0);
                            } else {
                                ((Path2D)object4).setWindingRule(1);
                            }
                            Area area2 = new Area((Shape)object4);
                            if (sVGClipPathElementImpl != null && (shape2 = sVGClipPathElementImpl.getClippingShape(sVGElement)) != null) {
                                if (area2 == null) {
                                    area2 = new Area(shape2);
                                } else {
                                    area2.intersect(new Area(shape2));
                                }
                            }
                            if (area == null) {
                                area = area2;
                            } else {
                                area.add(area2);
                            }
                        }
                    } else {
                        System.out.println("ClipPath Error: <use> element in clipPath can only reference path, text or\nvector graphic shape elements");
                    }
                }
                ++n2;
            }
        }
        object3 = this.getClippingPath();
        String string = this.getClipRule();
        if (object3 != null && (shape = ((SVGClipPathElementImpl)object3).getClippingShape(sVGElement)) != null) {
            if (area == null) {
                area = new Area(shape);
            } else {
                area.intersect(new Area(shape));
            }
        }
        if (area != null) {
            Shape shape3 = area;
            if (this.getClipPathUnits().getAnimVal() == 2) {
                object2 = null;
                if (sVGElement instanceof SVGTransformable) {
                    object2 = (SVGRectImpl)((SVGTransformable)((Object)sVGElement)).getBBox();
                } else if (sVGElement instanceof SVGSVGElementImpl) {
                    object2 = (SVGRectImpl)((SVGSVGElementImpl)sVGElement).getBBox();
                }
                if (object2 != null) {
                    object = AffineTransform.getTranslateInstance(((SVGRectImpl)object2).getX(), ((SVGRectImpl)object2).getY());
                    ((AffineTransform)object).scale(((SVGRectImpl)object2).getWidth(), ((SVGRectImpl)object2).getHeight());
                    shape3 = ((AffineTransform)object).createTransformedShape(shape3);
                    return shape3;
                }
            }
        }
        return area;
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("clipPathUnits")) {
            ((SVGAnimatedValue)((Object)this.getClipPathUnits())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("externalResourcesRequired")) {
            ((SVGAnimatedValue)((Object)this.getExternalResourcesRequired())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

