/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import com.steadystate.css.parser.CSSOMParser;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.csiro.svg.dom.RGBColorImpl;
import org.csiro.svg.dom.SVGColorDecoder;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.svg.SVGColor;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGICCColor;

public class SVGColorImpl
implements SVGColor {
    protected short colorType;
    protected RGBColor rgbColor;
    protected SVGICCColor iccColor;
    private static SVGColorDecoder colorDecoder = new SVGColorDecoder();

    public SVGColorImpl() {
        this.colorType = 0;
    }

    public SVGColorImpl(String string) {
        this.setCssText(string);
    }

    public String getCssText() {
        if (this.colorType == 1) {
            return "rgb(" + this.rgbColor.getRed().getCssText() + ", " + this.rgbColor.getGreen().getCssText() + ", " + this.rgbColor.getBlue().getCssText() + ")";
        }
        if (this.colorType == 2) {
            return this.iccColor.getColorProfile();
        }
        return "";
    }

    public void setCssText(String string) throws DOMException {
        CSSOMParser cSSOMParser = new CSSOMParser();
        CSSValue cSSValue = null;
        try {
            cSSValue = cSSOMParser.parsePropertyValue(new InputSource((Reader)new StringReader(string)));
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return;
        }
        if (cSSValue != null && cSSValue.getCssValueType() == 1) {
            if (((CSSPrimitiveValue)cSSValue).getPrimitiveType() == 25) {
                this.rgbColor = new RGBColorImpl(cSSValue);
                this.colorType = 1;
            } else {
                Color color = SVGColorImpl.getColor(string);
                String string2 = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
                CSSOMParser cSSOMParser2 = new CSSOMParser();
                CSSValue cSSValue2 = null;
                try {
                    cSSValue2 = cSSOMParser2.parsePropertyValue(new InputSource((Reader)new StringReader(string2)));
                    this.rgbColor = new RGBColorImpl(cSSValue2);
                    this.colorType = 1;
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                }
            }
        }
    }

    public short getCssValueType() {
        return 3;
    }

    public short getColorType() {
        return this.colorType;
    }

    public RGBColor getRGBColor() {
        return this.rgbColor;
    }

    public SVGICCColor getICCColor() {
        return this.iccColor;
    }

    public void setRGBColor(String string) throws SVGException {
        this.setCssText(string);
    }

    public void setRGBColorICCColor(String string, String string2) throws SVGException {
        this.setCssText(string);
    }

    public void setColor(short s, String string, String string2) throws SVGException {
    }

    private static Color getColor(String string) {
        Color color = colorDecoder.getColor(string);
        if (color == null) {
            System.out.println("cannot decode colour: " + string);
            return Color.black;
        }
        return color;
    }

    public Color getColor() {
        if (this.colorType == 1) {
            return ((RGBColorImpl)((Object)this.rgbColor)).getColor();
        }
        return null;
    }
}

