/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ICC_ProfileRGB;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.io.FileInputStream;
import java.util.Vector;
import org.csiro.svg.dom.SVGAnimatedStringImpl;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGColorProfileElement;

public class SVGColorProfileElementImpl
extends SVGElementImpl
implements SVGColorProfileElement {
    protected short renderingIntent;
    protected String name;
    protected String local;
    protected SVGAnimatedString href;
    private static Vector filterUnitStrings;
    private static Vector filterUnitValues;
    ICC_Profile newProfile = null;
    ColorSpace newSpace = null;
    ColorSpace defaultSpace = null;
    Canvas tmpComponent = null;

    public SVGColorProfileElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "color-profile");
    }

    public SVGColorProfileElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "color-profile");
    }

    public SVGElementImpl cloneElement() {
        SVGColorProfileElementImpl sVGColorProfileElementImpl = new SVGColorProfileElementImpl(this.getOwnerDoc(), this);
        return sVGColorProfileElementImpl;
    }

    public short getRenderingIntent() {
        return this.renderingIntent;
    }

    public void setRenderingIntent(short s) throws DOMException {
        throw new DOMException(1, "Read only");
    }

    public String getLocal() {
        return this.local;
    }

    public void setLocal(String string) throws DOMException {
        throw new DOMException(1, "Read only");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws DOMException {
        throw new DOMException(1, "Read only");
    }

    public String getXMLlang() {
        return this.getAttribute("xml:lang");
    }

    public void setXMLlang(String string) {
        if (string != null) {
            super.setAttribute("xml:lang", string);
        } else {
            this.removeAttribute("xml:lang");
        }
    }

    public String getXMLspace() {
        return this.getAttribute("xml:space");
    }

    public void setXMLspace(String string) {
        if (string != null) {
            super.setAttribute("xml:space", string);
        } else {
            this.removeAttribute("xml:space");
        }
    }

    public String getXlinkType() {
        return this.getAttribute("xlink:type");
    }

    public void setXlinkType(String string) throws DOMException {
        this.setAttribute("xlink:type", string);
    }

    public String getXlinkRole() {
        return this.getAttribute("xlink:role");
    }

    public void setXlinkRole(String string) throws DOMException {
        this.setAttribute("xlink:role", string);
    }

    public String getXlinkArcRole() {
        return this.getAttribute("xlink:arcrole");
    }

    public void setXlinkArcRole(String string) throws DOMException {
        this.setAttribute("xlink:arcrole", string);
    }

    public String getXlinkTitle() {
        return this.getAttribute("xlink:title");
    }

    public void setXlinkTitle(String string) throws DOMException {
        this.setAttribute("xlink:title", string);
    }

    public String getXlinkShow() {
        return this.getAttribute("xlink:show");
    }

    public void setXlinkShow(String string) throws DOMException {
        this.setAttribute("xlink:show", string);
    }

    public String getXlinkActuate() {
        return this.getAttribute("xlink:actuate");
    }

    public void setXlinkActuate(String string) throws DOMException {
        this.setAttribute("xlink:actuate", string);
    }

    public SVGAnimatedString getHref() {
        if (this.href == null) {
            this.href = new SVGAnimatedStringImpl("", this);
        }
        return this.href;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (string.equalsIgnoreCase("local")) {
            return this.getLocal();
        }
        if (string.equalsIgnoreCase("rendering-intent")) {
            return new Short(this.getRenderingIntent()).toString();
        }
        if (string.equalsIgnoreCase("xlink:href")) {
            return this.getHref().getBaseVal();
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("name")) {
            attr.setValue(this.getName());
        } else if (string.equalsIgnoreCase("local")) {
            attr.setValue(this.getLocal());
        } else if (string.equalsIgnoreCase("rendering-intent")) {
            attr.setValue(this.getAttribute("rendering-intent"));
        } else if (string.equalsIgnoreCase("xlink:href")) {
            attr.setValue(this.getHref().getBaseVal());
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        if (string.equalsIgnoreCase("name")) {
            this.name = string2;
        } else if (string.equalsIgnoreCase("local")) {
            this.local = string2;
        } else if (!string.equalsIgnoreCase("rendering-intent") && string.equalsIgnoreCase("xlink:href")) {
            this.getHref().setBaseVal(string2);
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        String string = attr.getName();
        String string2 = attr.getValue();
        if (string.equalsIgnoreCase("name")) {
            this.name = string2;
        } else if (string.equalsIgnoreCase("local")) {
            this.local = string2;
        } else if (string.equalsIgnoreCase("rendering-intent")) {
            this.renderingIntent = Short.parseShort(string2);
        } else if (string.equalsIgnoreCase("xlink:href")) {
            this.getHref().setBaseVal(string2);
        }
        return super.setAttributeNode(attr);
    }

    protected boolean loadProfile() {
        block15: {
            try {
                int n;
                this.newProfile = ICC_Profile.getInstance(new FileInputStream(this.getHref().getBaseVal()));
                System.out.println("Profile: " + this.newProfile);
                if (!(this.newProfile instanceof ICC_ProfileRGB)) break block15;
                ICC_ProfileRGB iCC_ProfileRGB = (ICC_ProfileRGB)this.newProfile;
                System.out.println("Matrix == ");
                float[][] fArray = iCC_ProfileRGB.getMatrix();
                int n2 = 0;
                while (n2 < 3) {
                    n = 0;
                    while (n < 3) {
                        System.out.println(n2 + " " + n + " " + fArray[n2][n]);
                        ++n;
                    }
                    ++n2;
                }
                n = 0;
                while (n < 3) {
                    int n3 = 0;
                    switch (n) {
                        case 0: {
                            n3 = 0;
                            break;
                        }
                        case 1: {
                            n3 = 1;
                            break;
                        }
                        case 2: {
                            n3 = 2;
                        }
                    }
                    try {
                        float f = iCC_ProfileRGB.getGamma(n3);
                        System.out.println("Gamma: " + f);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        short[] sArray = iCC_ProfileRGB.getTRC(n3);
                        System.out.print("Curve:");
                        int n4 = 0;
                        while (n4 < sArray.length) {
                            System.out.print(" " + (double)(sArray[n4] & 0xFFFF) / 65535.0);
                            ++n4;
                        }
                        System.out.println();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                System.out.println("\n    File not found error: " + this.getHref().getBaseVal() + "\n");
                return false;
            }
        }
        return true;
    }

    public Image applyProfile(Image image) {
        Object object;
        if (!this.loadProfile()) {
            return null;
        }
        this.tmpComponent = new Canvas();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(this.tmpComponent), image.getHeight(this.tmpComponent), 3);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.drawImage(image, 0, 0, this.tmpComponent);
        graphics2D.dispose();
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        ColorModel colorModel2 = colorModel;
        if (!(colorModel instanceof ComponentColorModel)) {
            System.out.println("Convert to ComponentColorModel");
            colorModel2 = new ComponentColorModel(colorModel.getColorSpace(), colorModel.getComponentSize(), false, false, 3, 0);
            object = colorModel2.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
            bufferedImage = new BufferedImage(colorModel2, (WritableRaster)object, colorModel2.isAlphaPremultiplied(), null);
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.drawImage(image, 0, 0, this.tmpComponent);
            graphics2D.dispose();
            colorModel = colorModel2;
        }
        this.newSpace = new ICC_ColorSpace(this.newProfile);
        object = new ComponentColorModel(this.newSpace, colorModel.getComponentSize(), colorModel.hasAlpha(), colorModel.isAlphaPremultiplied(), 3, 0);
        System.out.println("Before new BI");
        BufferedImage bufferedImage2 = new BufferedImage((ColorModel)object, bufferedImage.getRaster(), ((ColorModel)object).isAlphaPremultiplied(), null);
        System.out.println("After new BI");
        return bufferedImage2;
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
    }
}

