/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.csiro.svg.dom.SVGAElementImpl;
import org.csiro.svg.dom.SVGAnimateColorElementImpl;
import org.csiro.svg.dom.SVGAnimateElementImpl;
import org.csiro.svg.dom.SVGAnimateMotionElementImpl;
import org.csiro.svg.dom.SVGAnimateTransformElementImpl;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGCircleElementImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGCursorElementImpl;
import org.csiro.svg.dom.SVGDefinitionSrcElementImpl;
import org.csiro.svg.dom.SVGDefsElementImpl;
import org.csiro.svg.dom.SVGDescElementImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGEllipseElementImpl;
import org.csiro.svg.dom.SVGFEBlendElementImpl;
import org.csiro.svg.dom.SVGFEColorMatrixElementImpl;
import org.csiro.svg.dom.SVGFECompositeElementImpl;
import org.csiro.svg.dom.SVGFilterElementImpl;
import org.csiro.svg.dom.SVGFontElementImpl;
import org.csiro.svg.dom.SVGFontFaceElementImpl;
import org.csiro.svg.dom.SVGFontFaceFormatElementImpl;
import org.csiro.svg.dom.SVGFontFaceNameElementImpl;
import org.csiro.svg.dom.SVGFontFaceSrcElementImpl;
import org.csiro.svg.dom.SVGFontFaceUriElementImpl;
import org.csiro.svg.dom.SVGGElementImpl;
import org.csiro.svg.dom.SVGGlyphElementImpl;
import org.csiro.svg.dom.SVGHKernElementImpl;
import org.csiro.svg.dom.SVGImageElementImpl;
import org.csiro.svg.dom.SVGLineElementImpl;
import org.csiro.svg.dom.SVGLinearGradientElementImpl;
import org.csiro.svg.dom.SVGMarkerElementImpl;
import org.csiro.svg.dom.SVGMissingGlyphElementImpl;
import org.csiro.svg.dom.SVGPathElementImpl;
import org.csiro.svg.dom.SVGPatternElementImpl;
import org.csiro.svg.dom.SVGPolygonElementImpl;
import org.csiro.svg.dom.SVGPolylineElementImpl;
import org.csiro.svg.dom.SVGRadialGradientElementImpl;
import org.csiro.svg.dom.SVGRectElementImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.dom.SVGScriptElementImpl;
import org.csiro.svg.dom.SVGSetElementImpl;
import org.csiro.svg.dom.SVGStopElementImpl;
import org.csiro.svg.dom.SVGStyleElementImpl;
import org.csiro.svg.dom.SVGSymbolElementImpl;
import org.csiro.svg.dom.SVGTextElementImpl;
import org.csiro.svg.dom.SVGTitleElementImpl;
import org.csiro.svg.dom.SVGUseElementImpl;
import org.csiro.svg.dom.SVGVKernElementImpl;
import org.csiro.svg.dom.SVGViewElementImpl;
import org.csiro.svg.dom.events.EventFactory;
import org.csiro.svg.dom.events.ScriptTimerListener;
import org.csiro.svg.dom.events.TimeFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGTitleElement;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class SVGDocumentImpl
extends DocumentImpl
implements SVGDocument,
DocumentView {
    protected String title = null;
    protected String referrer = "";
    protected String domain = null;
    protected String url = null;
    private boolean beginTimeSet = false;
    private double beginTime;
    private boolean animated = false;
    private boolean changed = false;
    protected Scriptable scope;
    int count = 0;
    AbstractView defaultView = null;

    public void setChanged() {
        this.changed = true;
    }

    double getBeginTime() {
        return this.beginTime;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public Scriptable getScope() {
        return this.scope;
    }

    protected void setScope(Scriptable scriptable) {
        this.scope = scriptable;
    }

    protected void initialiseScriptEngine() {
        Context context = Context.enter();
        this.setScope(context.initStandardObjects((ScriptableObject)new ImporterTopLevel()));
        Context.exit();
    }

    protected void finalizeScriptEngine() {
        Context.exit();
    }

    public void exposeToScriptEngine(String string, Object object, Context context) {
        System.out.println("SVGDocumentImpl about to expose '" + string + "' to script engine as " + object.toString());
        Scriptable scriptable = Context.toObject((Object)object, (Scriptable)this.getScope());
        this.getScope().put(string, this.getScope(), (Object)scriptable);
    }

    public SVGDocumentImpl() {
    }

    public SVGDocumentImpl(Document document) {
        this.initialiseScriptEngine();
        Element element = document.getDocumentElement();
        element.normalize();
        SVGSVGElementImpl sVGSVGElementImpl = new SVGSVGElementImpl(this, element);
        this.appendChild(sVGSVGElementImpl);
        if (sVGSVGElementImpl.getElementsByTagName("script").getLength() > 0) {
            Context context = Context.enter();
            this.exposeToScriptEngine("document", this, context);
            this.exposeToScriptEngine("timer", new TimeFactory(new ScriptTimerListener(this)), context);
            Context.exit();
        }
    }

    public void finalize() {
        this.finalizeScriptEngine();
    }

    public String getTitle() {
        SVGSVGElementImpl sVGSVGElementImpl = (SVGSVGElementImpl)this.getRootElement();
        if (sVGSVGElementImpl != null && sVGSVGElementImpl.hasChildNodes()) {
            NodeList nodeList = sVGSVGElementImpl.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node instanceof SVGTitleElement) {
                    SVGTitleElement sVGTitleElement = (SVGTitleElement)node;
                    String string = "";
                    if (sVGTitleElement.hasChildNodes()) {
                        NodeList nodeList2 = sVGTitleElement.getChildNodes();
                        int n3 = nodeList2.getLength();
                        int n4 = 0;
                        while (n4 < n3) {
                            Node node2 = nodeList2.item(n4);
                            if (node2.getNodeType() == 3) {
                                string = string + node2.getNodeValue();
                            }
                            ++n4;
                        }
                    }
                    return string;
                }
                ++n2;
            }
        }
        return "";
    }

    public void setTitle(String string) {
        SVGSVGElementImpl sVGSVGElementImpl = (SVGSVGElementImpl)this.getRootElement();
        if (sVGSVGElementImpl != null) {
            Object object;
            if (sVGSVGElementImpl.hasChildNodes()) {
                object = sVGSVGElementImpl.getChildNodes();
                int n = object.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Node node = object.item(n2);
                    if (node instanceof SVGTitleElement) {
                        sVGSVGElementImpl.removeChild(node);
                    }
                    ++n2;
                }
            }
            object = new SVGTitleElementImpl(this);
            Text text = this.createTextNode(string);
            ((SVGElementImpl)object).appendChild(text);
            if (sVGSVGElementImpl.getFirstChild() != null) {
                sVGSVGElementImpl.insertBefore((Node)object, sVGSVGElementImpl.getFirstChild());
            } else {
                sVGSVGElementImpl.appendChild((Node)object);
            }
        }
    }

    public String getReferrer() {
        return this.referrer;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public SVGSVGElement getRootElement() {
        return (SVGSVGElement)this.getDocumentElement();
    }

    public void setRootElement(SVGSVGElement sVGSVGElement) {
        if (sVGSVGElement != this.getRootElement()) {
            this.appendChild(sVGSVGElement);
        }
    }

    public Element getElementById(String string) {
        SVGSVGElement sVGSVGElement = this.getRootElement();
        if (sVGSVGElement == null) {
            return null;
        }
        return sVGSVGElement.getElementById(string);
    }

    public Vector getElementsThatContain(double d, double d2) {
        SVGSVGElementImpl sVGSVGElementImpl = (SVGSVGElementImpl)this.getRootElement();
        if (sVGSVGElementImpl != null) {
            return sVGSVGElementImpl.getElementsThatContain(d, d2);
        }
        return new Vector();
    }

    public Event createEvent(String string) throws DOMException {
        return EventFactory.createEvent(string);
    }

    public void draw(Graphics2D graphics2D) {
        Object object;
        Object object2;
        if (!this.beginTimeSet) {
            object2 = Calendar.getInstance();
            this.beginTime = (double)((Calendar)object2).getTime().getTime() / 1000.0;
            this.beginTimeSet = true;
            this.attachAnimations();
        }
        if ((object2 = (SVGSVGElementImpl)this.getRootElement()) != null) {
            object = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHints((Map<?, ?>)object);
            ((SVGSVGElementImpl)object2).draw(graphics2D, this.changed);
        }
        if (this.animated && !this.animationsFinished()) {
            this.changed = true;
            object = this.createEvent("UIEvent");
            object.initEvent("onchange", false, false);
            this.getRootElement().dispatchEvent((Event)object);
        } else {
            this.changed = false;
        }
    }

    public AbstractView getDefaultView() {
        return this.defaultView;
    }

    public void setDefaultView(AbstractView abstractView) {
        this.defaultView = abstractView;
    }

    public Element createElement(String string) throws DOMException {
        System.out.println("SVG Createelement: " + string);
        if (string == null) {
            throw new DOMException(5, "createElement failed, invalid tag name");
        }
        if (string.equals("svg")) {
            return new SVGSVGElementImpl(this);
        }
        if (string.equals("g")) {
            return new SVGGElementImpl(this);
        }
        if (string.equals("path")) {
            return new SVGPathElementImpl(this);
        }
        if (string.equals("rect")) {
            return new SVGRectElementImpl(this);
        }
        if (string.equals("circle")) {
            return new SVGCircleElementImpl(this);
        }
        if (string.equals("ellipse")) {
            return new SVGEllipseElementImpl(this);
        }
        if (string.equals("line")) {
            return new SVGLineElementImpl(this);
        }
        if (string.equals("polyline")) {
            return new SVGPolylineElementImpl(this);
        }
        if (string.equals("polygon")) {
            return new SVGPolygonElementImpl(this);
        }
        if (string.equals("text")) {
            return new SVGTextElementImpl(this);
        }
        if (string.equals("image")) {
            return new SVGImageElementImpl(this);
        }
        if (string.equals("a")) {
            return new SVGAElementImpl(this);
        }
        if (string.equals("defs")) {
            return new SVGDefsElementImpl(this);
        }
        if (string.equals("use")) {
            return new SVGUseElementImpl(this);
        }
        if (string.equals("symbol")) {
            return new SVGSymbolElementImpl(this);
        }
        if (string.equals("marker")) {
            return new SVGMarkerElementImpl(this);
        }
        if (string.equals("pattern")) {
            return new SVGPatternElementImpl(this);
        }
        if (string.equals("stop")) {
            return new SVGStopElementImpl(this);
        }
        if (string.equals("linearGradient")) {
            return new SVGLinearGradientElementImpl(this);
        }
        if (string.equals("radialGradient")) {
            return new SVGRadialGradientElementImpl(this);
        }
        if (string.equals("clipPath")) {
            return new SVGClipPathElementImpl(this);
        }
        if (string.equals("title")) {
            return new SVGTitleElementImpl(this);
        }
        if (string.equals("desc")) {
            return new SVGDescElementImpl(this);
        }
        if (string.equals("script")) {
            return new SVGScriptElementImpl(this);
        }
        if (string.equals("style")) {
            return new SVGStyleElementImpl(this);
        }
        if (string.equals("font")) {
            return new SVGFontElementImpl(this);
        }
        if (string.equals("missing-glyph")) {
            return new SVGMissingGlyphElementImpl(this);
        }
        if (string.equals("glyph")) {
            return new SVGGlyphElementImpl(this);
        }
        if (string.equals("font-face")) {
            return new SVGFontFaceElementImpl(this);
        }
        if (string.equals("font-face-src")) {
            return new SVGFontFaceSrcElementImpl(this);
        }
        if (string.equals("font-face-uri")) {
            return new SVGFontFaceUriElementImpl(this);
        }
        if (string.equals("font-face-name")) {
            return new SVGFontFaceNameElementImpl(this);
        }
        if (string.equals("font-face-format")) {
            return new SVGFontFaceFormatElementImpl(this);
        }
        if (string.equals("definition-src")) {
            return new SVGDefinitionSrcElementImpl(this);
        }
        if (string.equals("hkern")) {
            return new SVGHKernElementImpl(this);
        }
        if (string.equals("vkern")) {
            return new SVGVKernElementImpl(this);
        }
        if (string.equals("animate")) {
            return new SVGAnimateElementImpl(this);
        }
        if (string.equals("animateTransform")) {
            return new SVGAnimateTransformElementImpl(this);
        }
        if (string.equals("animateColor")) {
            return new SVGAnimateColorElementImpl(this);
        }
        if (string.equals("animateMotion")) {
            return new SVGAnimateMotionElementImpl(this);
        }
        if (string.equals("set")) {
            return new SVGSetElementImpl(this);
        }
        if (string.equals("cursor")) {
            return new SVGCursorElementImpl(this);
        }
        if (string.equals("view")) {
            return new SVGViewElementImpl(this);
        }
        if (string.equals("filter")) {
            return new SVGFilterElementImpl(this);
        }
        if (string.equals("feBlend")) {
            return new SVGFEBlendElementImpl(this);
        }
        if (string.equals("feColorMatrix")) {
            return new SVGFEColorMatrixElementImpl(this);
        }
        if (string.equals("feComposite")) {
            return new SVGFECompositeElementImpl(this);
        }
        return super.createElement(string);
    }

    private Vector getAnimationElements() {
        Vector<Node> vector = new Vector<Node>();
        NodeList nodeList = this.getRootElement().getElementsByTagName("animate");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(nodeList.item(n2));
            ++n2;
        }
        NodeList nodeList2 = this.getRootElement().getElementsByTagName("animateTransform");
        int n3 = nodeList2.getLength();
        int n4 = 0;
        while (n4 < n3) {
            vector.addElement(nodeList2.item(n4));
            ++n4;
        }
        NodeList nodeList3 = this.getRootElement().getElementsByTagName("set");
        int n5 = nodeList3.getLength();
        int n6 = 0;
        while (n6 < n5) {
            vector.addElement(nodeList3.item(n6));
            ++n6;
        }
        NodeList nodeList4 = this.getRootElement().getElementsByTagName("animateColor");
        int n7 = nodeList4.getLength();
        int n8 = 0;
        while (n8 < n7) {
            vector.addElement(nodeList4.item(n8));
            ++n8;
        }
        NodeList nodeList5 = this.getRootElement().getElementsByTagName("animateMotion");
        int n9 = nodeList5.getLength();
        int n10 = 0;
        while (n10 < n9) {
            vector.addElement(nodeList5.item(n10));
            ++n10;
        }
        return vector;
    }

    private void attachAnimations() {
        Vector vector = this.getAnimationElements();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SVGAnimationElementImpl sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n2);
            SVGElementImpl sVGElementImpl = (SVGElementImpl)sVGAnimationElementImpl.getTargetElement();
            if (sVGElementImpl != null) {
                sVGElementImpl.attachAnimation(sVGAnimationElementImpl);
            }
            ++n2;
        }
        if (n > 0) {
            this.animated = true;
        }
    }

    public boolean animationsFinished() {
        if (!this.animated) {
            return true;
        }
        Vector vector = this.getAnimationElements();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SVGAnimationElementImpl sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n2);
            if (!sVGAnimationElementImpl.finished()) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

