/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.csiro.svg.dom.SVGAElementImpl;
import org.csiro.svg.dom.SVGAnimateColorElementImpl;
import org.csiro.svg.dom.SVGAnimateElementImpl;
import org.csiro.svg.dom.SVGAnimateMotionElementImpl;
import org.csiro.svg.dom.SVGAnimateTransformElementImpl;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGCircleElementImpl;
import org.csiro.svg.dom.SVGClipPathElementImpl;
import org.csiro.svg.dom.SVGColorProfileElementImpl;
import org.csiro.svg.dom.SVGCursorElementImpl;
import org.csiro.svg.dom.SVGDefinitionSrcElementImpl;
import org.csiro.svg.dom.SVGDefsElementImpl;
import org.csiro.svg.dom.SVGDescElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGEllipseElementImpl;
import org.csiro.svg.dom.SVGFEBlendElementImpl;
import org.csiro.svg.dom.SVGFEColorMatrixElementImpl;
import org.csiro.svg.dom.SVGFECompositeElementImpl;
import org.csiro.svg.dom.SVGFilterElementImpl;
import org.csiro.svg.dom.SVGFontElementImpl;
import org.csiro.svg.dom.SVGFontFaceElementImpl;
import org.csiro.svg.dom.SVGFontFaceFormatElementImpl;
import org.csiro.svg.dom.SVGFontFaceNameElementImpl;
import org.csiro.svg.dom.SVGFontFaceSrcElementImpl;
import org.csiro.svg.dom.SVGFontFaceUriElementImpl;
import org.csiro.svg.dom.SVGGElementImpl;
import org.csiro.svg.dom.SVGGlyphElementImpl;
import org.csiro.svg.dom.SVGHKernElementImpl;
import org.csiro.svg.dom.SVGImageElementImpl;
import org.csiro.svg.dom.SVGLineElementImpl;
import org.csiro.svg.dom.SVGLinearGradientElementImpl;
import org.csiro.svg.dom.SVGMarkerElementImpl;
import org.csiro.svg.dom.SVGMissingGlyphElementImpl;
import org.csiro.svg.dom.SVGPathElementImpl;
import org.csiro.svg.dom.SVGPatternElementImpl;
import org.csiro.svg.dom.SVGPolygonElementImpl;
import org.csiro.svg.dom.SVGPolylineElementImpl;
import org.csiro.svg.dom.SVGRadialGradientElementImpl;
import org.csiro.svg.dom.SVGRectElementImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.dom.SVGScriptElementImpl;
import org.csiro.svg.dom.SVGSetElementImpl;
import org.csiro.svg.dom.SVGStopElementImpl;
import org.csiro.svg.dom.SVGStyleElementImpl;
import org.csiro.svg.dom.SVGSymbolElementImpl;
import org.csiro.svg.dom.SVGTextElementImpl;
import org.csiro.svg.dom.SVGTitleElementImpl;
import org.csiro.svg.dom.SVGUseElementImpl;
import org.csiro.svg.dom.SVGVKernElementImpl;
import org.csiro.svg.dom.SVGViewElementImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGSymbolElement;

public abstract class SVGElementImpl
extends ElementNSImpl
implements SVGElement {
    SVGDocumentImpl ownerDoc = null;

    public SVGElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element, String string) {
        this(sVGDocumentImpl, string);
        this.copyElement(element);
    }

    public SVGElementImpl(SVGDocumentImpl sVGDocumentImpl, String string) {
        super((CoreDocumentImpl)sVGDocumentImpl, string);
        this.setOwnerDoc(sVGDocumentImpl);
    }

    protected SVGElementImpl(SVGDocumentImpl sVGDocumentImpl, String string, String string2) {
        super((CoreDocumentImpl)sVGDocumentImpl, string, string2);
        this.setOwnerDoc(sVGDocumentImpl);
    }

    public abstract SVGElementImpl cloneElement();

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
    }

    protected SVGDocumentImpl getOwnerDoc() {
        return this.ownerDoc;
    }

    protected void setOwnerDoc(SVGDocumentImpl sVGDocumentImpl) {
        this.ownerDoc = sVGDocumentImpl;
    }

    public String getXMLbase() {
        return this.getAttribute("xml:base");
    }

    public void setXMLbase(String string) throws DOMException {
        this.setAttribute("xml:base", string);
    }

    public String getId() {
        return this.getAttribute("id");
    }

    public void setId(String string) {
        if (string != null && string.length() > 0) {
            this.setAttribute("id", string);
        } else {
            this.removeAttribute("id");
        }
        this.getOwnerDoc().setChanged();
    }

    public SVGSVGElement getOwnerSVGElement() {
        if (this.getParentNode() == this.ownerDoc) {
            return null;
        }
        Node node = this.getParentNode();
        while (node != null && !(node instanceof SVGSVGElement)) {
            node = node.getParentNode();
        }
        return (SVGSVGElement)node;
    }

    public SVGElement getViewportElement() {
        if (this.getParentNode() == this.ownerDoc) {
            return null;
        }
        Node node = this.getParentNode();
        while (node != null && !(node instanceof SVGSVGElement) && !(node instanceof SVGSymbolElement)) {
            node = node.getParentNode();
        }
        return (SVGElement)node;
    }

    protected void copyElement(Element element) {
        this.copyAttributes(element);
        this.copyCreateChildren(element);
    }

    protected void copyCreateChildren(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        SVGDocumentImpl sVGDocumentImpl = this.getOwnerDoc();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                String string = element2.getTagName();
                SVGElementImpl sVGElementImpl = this.createSVGElement(string, element2, sVGDocumentImpl);
                if (sVGElementImpl != null) {
                    this.appendChild(sVGElementImpl);
                } else {
                    if (!string.equals("mpath")) {
                        System.out.println("element: <" + string + "> not supported yet");
                    }
                    this.appendChild(this.cloneNode(element2, sVGDocumentImpl));
                }
            } else if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                this.appendChild(this.cloneNode(node, sVGDocumentImpl));
            }
            ++n2;
        }
    }

    protected SVGElementImpl createSVGElement(String string, Element element, SVGDocumentImpl sVGDocumentImpl) {
        SVGElementImpl sVGElementImpl = null;
        if (string.equals("svg")) {
            sVGElementImpl = new SVGSVGElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("g")) {
            sVGElementImpl = new SVGGElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("path")) {
            sVGElementImpl = new SVGPathElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("rect")) {
            sVGElementImpl = new SVGRectElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("circle")) {
            sVGElementImpl = new SVGCircleElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("ellipse")) {
            sVGElementImpl = new SVGEllipseElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("line")) {
            sVGElementImpl = new SVGLineElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("polyline")) {
            sVGElementImpl = new SVGPolylineElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("polygon")) {
            sVGElementImpl = new SVGPolygonElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("text")) {
            sVGElementImpl = new SVGTextElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("image")) {
            sVGElementImpl = new SVGImageElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("a")) {
            sVGElementImpl = new SVGAElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("defs")) {
            sVGElementImpl = new SVGDefsElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("use")) {
            sVGElementImpl = new SVGUseElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("symbol")) {
            sVGElementImpl = new SVGSymbolElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("marker")) {
            sVGElementImpl = new SVGMarkerElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("pattern")) {
            sVGElementImpl = new SVGPatternElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("stop")) {
            sVGElementImpl = new SVGStopElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("linearGradient")) {
            sVGElementImpl = new SVGLinearGradientElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("radialGradient")) {
            sVGElementImpl = new SVGRadialGradientElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("clipPath")) {
            sVGElementImpl = new SVGClipPathElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("title")) {
            sVGElementImpl = new SVGTitleElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("desc")) {
            sVGElementImpl = new SVGDescElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("script")) {
            sVGElementImpl = new SVGScriptElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("style")) {
            sVGElementImpl = new SVGStyleElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("font")) {
            sVGElementImpl = new SVGFontElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("missing-glyph")) {
            sVGElementImpl = new SVGMissingGlyphElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("glyph")) {
            sVGElementImpl = new SVGGlyphElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("font-face")) {
            sVGElementImpl = new SVGFontFaceElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("font-face-src")) {
            sVGElementImpl = new SVGFontFaceSrcElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("font-face-uri")) {
            sVGElementImpl = new SVGFontFaceUriElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("font-face-name")) {
            sVGElementImpl = new SVGFontFaceNameElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("font-face-format")) {
            sVGElementImpl = new SVGFontFaceFormatElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("definition-src")) {
            sVGElementImpl = new SVGDefinitionSrcElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("hkern")) {
            sVGElementImpl = new SVGHKernElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("vkern")) {
            sVGElementImpl = new SVGVKernElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("animate")) {
            sVGElementImpl = new SVGAnimateElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("animateTransform")) {
            sVGElementImpl = new SVGAnimateTransformElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("animateColor")) {
            sVGElementImpl = new SVGAnimateColorElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("animateMotion")) {
            sVGElementImpl = new SVGAnimateMotionElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("set")) {
            sVGElementImpl = new SVGSetElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("cursor")) {
            sVGElementImpl = new SVGCursorElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("view")) {
            sVGElementImpl = new SVGViewElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("filter")) {
            sVGElementImpl = new SVGFilterElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("feBlend")) {
            sVGElementImpl = new SVGFEBlendElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("feColorMatrix")) {
            sVGElementImpl = new SVGFEColorMatrixElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("feComposite")) {
            sVGElementImpl = new SVGFECompositeElementImpl(sVGDocumentImpl, element);
        } else if (string.equals("color-profile")) {
            sVGElementImpl = new SVGColorProfileElementImpl(sVGDocumentImpl, element);
        }
        return sVGElementImpl;
    }

    protected void copyAttributes(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        Node node = null;
        int n2 = 0;
        while (n2 < n) {
            node = namedNodeMap.item(n2);
            if (node instanceof Attr) {
                this.setAttribute(node.getNodeName(), node.getNodeValue());
            } else {
                System.out.println("Bad Attribute in copyAttributes - should check node type rather than use instanceof");
            }
            ++n2;
        }
    }

    protected Node cloneNode(Node node, Document document) {
        Node node2 = null;
        if (node.getNodeType() == 1) {
            node2 = document.createElementNS(node.getNamespaceURI(), node.getNodeName());
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            Node node3 = null;
            int n2 = 0;
            while (n2 < n) {
                node3 = namedNodeMap.item(n2);
                if (node3 instanceof Attr) {
                    node2.setAttribute(node3.getNodeName(), node3.getNodeValue());
                }
                ++n2;
            }
            NodeList nodeList = node.getChildNodes();
            int n3 = nodeList.getLength();
            int n4 = 0;
            while (n4 < n3) {
                Node node4 = nodeList.item(n4);
                if (node4.getNodeType() == 3) {
                    if (node4.getNodeValue().trim().length() > 0) {
                        node2.appendChild(this.cloneNode(node4, document));
                    }
                } else if (node4.getNodeType() == 1 || node4.getNodeType() == 4) {
                    node2.appendChild(this.cloneNode(node4, document));
                }
                ++n4;
            }
        } else if (node.getNodeType() == 3) {
            node2 = document.createTextNode(((Text)node).getNodeValue());
        } else if (node.getNodeType() == 4) {
            node2 = document.createCDATASection(((CDATASection)node).getNodeValue());
        }
        return node2;
    }

    public NamedNodeMap getAttributes() {
        NamedNodeMap namedNodeMap = super.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            String string = this.getAttribute(attr.getName());
            attr.setValue(string);
            ++n2;
        }
        return namedNodeMap;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.getOwnerDoc().setChanged();
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.getOwnerDoc().setChanged();
        return super.setAttributeNode(attr);
    }

    public void removeAttribute(String string) {
        super.removeAttribute(string);
        this.getOwnerDoc().setChanged();
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        this.getOwnerDoc().setChanged();
        return super.removeAttributeNode(attr);
    }

    public Node appendChild(Node node) {
        this.getOwnerDoc().setChanged();
        return super.appendChild(node);
    }

    public Node insertBefore(Node node, Node node2) {
        this.getOwnerDoc().setChanged();
        return super.insertBefore(node, node2);
    }

    public Node removeChild(Node node) {
        this.getOwnerDoc().setChanged();
        return super.removeChild(node);
    }

    public Node replaceChild(Node node, Node node2) {
        this.getOwnerDoc().setChanged();
        return super.replaceChild(node, node2);
    }
}

