/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.util.StringTokenizer;
import java.util.Vector;
import org.csiro.svg.dom.SVGAnimatedEnumerationImpl;
import org.csiro.svg.dom.SVGAnimatedIntegerImpl;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedNumberImpl;
import org.csiro.svg.dom.SVGAnimatedStringImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGFilterElementImpl;
import org.csiro.svg.dom.SVGFilterPrimitive;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedInteger;
import org.w3c.dom.svg.SVGAnimatedNumber;
import org.w3c.dom.svg.SVGFETurbulenceElement;

public class SVGFETurbulenceElementImpl
extends SVGFilterPrimitive
implements SVGFETurbulenceElement {
    protected SVGAnimatedEnumeration stitchTiles;
    protected SVGAnimatedNumber baseFrequencyX;
    protected SVGAnimatedNumber baseFrequencyY;
    protected SVGAnimatedNumber seed;
    protected SVGAnimatedInteger numOctaves;
    protected SVGAnimatedEnumeration type;
    private static Vector stStrings;
    private static Vector stValues;
    private static Vector typeStrings;
    private static Vector typeValues;
    private static int RAND_m;
    private static int RAND_a;
    private static int RAND_q;
    private static int RAND_r;
    private static int BSize;
    private static int BM;
    private static int PerlinN;
    private static int NP;
    private static int NM;
    int[] uLatticeSelector = new int[BSize + BSize + 2];
    static double[][][] fGradient;

    public SVGFETurbulenceElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "feTurbulence");
    }

    public SVGFETurbulenceElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "feTurbulence");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGFETurbulenceElementImpl sVGFETurbulenceElementImpl = new SVGFETurbulenceElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthImpl)this.getX()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthImpl)this.getY()).getAnimations();
        Vector vector3 = ((SVGAnimatedLengthImpl)this.getWidth()).getAnimations();
        Vector vector4 = ((SVGAnimatedLengthImpl)this.getHeight()).getAnimations();
        Vector vector5 = ((SVGAnimatedStringImpl)this.getResult()).getAnimations();
        Vector vector6 = ((SVGAnimatedNumberImpl)this.getBaseFrequencyX()).getAnimations();
        Vector vector7 = ((SVGAnimatedNumberImpl)this.getBaseFrequencyY()).getAnimations();
        Vector vector8 = ((SVGAnimatedIntegerImpl)this.getNumOctaves()).getAnimations();
        Vector vector9 = ((SVGAnimatedNumberImpl)this.getSeed()).getAnimations();
        Vector vector10 = ((SVGAnimatedEnumerationImpl)this.getStitchTiles()).getAnimations();
        Vector vector11 = ((SVGAnimatedEnumerationImpl)this.getType()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGFETurbulenceElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGFETurbulenceElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGFETurbulenceElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGFETurbulenceElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector5 != null) {
            n = 0;
            while (n < vector5.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector5.elementAt(n);
                sVGFETurbulenceElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector6 != null) {
            n = 0;
            while (n < vector6.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector6.elementAt(n);
                sVGFETurbulenceElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector7 != null) {
            n = 0;
            while (n < vector7.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector7.elementAt(n);
                sVGFETurbulenceElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector8 != null) {
            n = 0;
            while (n < vector8.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector8.elementAt(n);
                sVGFETurbulenceElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector9 != null) {
            n = 0;
            while (n < vector9.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector9.elementAt(n);
                sVGFETurbulenceElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector10 != null) {
            n = 0;
            while (n < vector10.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector10.elementAt(n);
                sVGFETurbulenceElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector11 != null) {
            n = 0;
            while (n < vector11.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector11.elementAt(n);
                sVGFETurbulenceElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        return sVGFETurbulenceElementImpl;
    }

    public SVGAnimatedEnumeration getStitchTiles() {
        if (this.stitchTiles == null) {
            if (stStrings == null) {
                this.initStVectors();
            }
            this.stitchTiles = new SVGAnimatedEnumerationImpl(2, this, stStrings, stValues);
        }
        return this.stitchTiles;
    }

    private void initStVectors() {
        if (stStrings == null) {
            stStrings = new Vector();
            stStrings.addElement("stitch");
            stStrings.addElement("noStitch");
        }
        if (stValues == null) {
            stValues = new Vector();
            stValues.addElement(new Short(1));
            stValues.addElement(new Short(2));
            stValues.addElement(new Short(0));
        }
    }

    public SVGAnimatedEnumeration getType() {
        if (this.type == null) {
            if (typeStrings == null) {
                this.initTypeVectors();
            }
            this.type = new SVGAnimatedEnumerationImpl(2, this, typeStrings, typeValues);
        }
        return this.type;
    }

    private void initTypeVectors() {
        if (typeStrings == null) {
            typeStrings = new Vector();
            typeStrings.addElement("fractalNoise");
            typeStrings.addElement("turbulence");
        }
        if (typeValues == null) {
            typeValues = new Vector();
            typeValues.addElement(new Short(1));
            typeValues.addElement(new Short(2));
            typeValues.addElement(new Short(0));
        }
    }

    public SVGAnimatedNumber getBaseFrequencyX() {
        if (this.baseFrequencyX == null) {
            this.baseFrequencyX = new SVGAnimatedNumberImpl(0.0f, this);
        }
        return this.baseFrequencyX;
    }

    public SVGAnimatedNumber getBaseFrequencyY() {
        if (this.baseFrequencyY == null) {
            this.baseFrequencyY = new SVGAnimatedNumberImpl(0.0f, this);
        }
        return this.baseFrequencyY;
    }

    public SVGAnimatedNumber getSeed() {
        if (this.seed == null) {
            this.seed = new SVGAnimatedNumberImpl(0.0f, this);
        }
        return this.seed;
    }

    public SVGAnimatedInteger getNumOctaves() {
        if (this.numOctaves == null) {
            this.numOctaves = new SVGAnimatedIntegerImpl(0, this);
        }
        return this.numOctaves;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("baseFrequency")) {
            return this.getBaseFrequencyX().getBaseVal() + " " + this.getBaseFrequencyY().getBaseVal();
        }
        if (string.equalsIgnoreCase("numOctaves")) {
            return "" + this.getNumOctaves().getBaseVal();
        }
        if (string.equalsIgnoreCase("seed")) {
            return "" + this.getSeed().getBaseVal();
        }
        if (string.equalsIgnoreCase("type")) {
            if (this.getType().getBaseVal() == 1) {
                return "fractalNoise";
            }
            return "turbulence";
        }
        if (string.equalsIgnoreCase("stitchTiles")) {
            if (this.getStitchTiles().getBaseVal() == 1) {
                return "stitch";
            }
            return "noStitch";
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("baseFrequency")) {
            attr.setValue(this.getBaseFrequencyX().getBaseVal() + " " + this.getBaseFrequencyY().getBaseVal());
        } else if (string.equalsIgnoreCase("numOctaves")) {
            attr.setValue("" + this.getNumOctaves().getBaseVal());
        } else if (string.equalsIgnoreCase("seed")) {
            attr.setValue("" + this.getSeed().getBaseVal());
        } else if (string.equalsIgnoreCase("type")) {
            if (this.getType().getBaseVal() == 1) {
                attr.setValue("fractalNoise");
            } else {
                attr.setValue("turbulence");
            }
        } else if (string.equalsIgnoreCase("stitchTiles")) {
            if (this.getStitchTiles().getBaseVal() == 1) {
                attr.setValue("stitch");
            } else {
                attr.setValue("noStitch");
            }
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        if (string.equalsIgnoreCase("baseFrequency")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            if (stringTokenizer.countTokens() == 1) {
                this.getBaseFrequencyX().setBaseVal(Float.parseFloat(stringTokenizer.nextToken()));
                this.getBaseFrequencyY().setBaseVal(this.getBaseFrequencyX().getBaseVal());
            } else if (stringTokenizer.countTokens() == 2) {
                this.getBaseFrequencyX().setBaseVal(Float.parseFloat(stringTokenizer.nextToken()));
                this.getBaseFrequencyY().setBaseVal(Float.parseFloat(stringTokenizer.nextToken()));
            }
        } else if (string.equalsIgnoreCase("numOctaves")) {
            this.getNumOctaves().setBaseVal(Integer.parseInt(string2));
        } else if (string.equalsIgnoreCase("seed")) {
            this.getSeed().setBaseVal(Float.parseFloat(string2));
        } else if (string.equalsIgnoreCase("type")) {
            if (string2.equalsIgnoreCase("fractalNoise")) {
                this.getType().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("turbulence")) {
                this.getType().setBaseVal((short)2);
            } else {
                System.out.println("invalid value '" + string2 + "' for type attribute, setting to default 'turbulence'");
                this.getType().setBaseVal((short)2);
                super.setAttribute("type", "turbulence");
            }
        } else if (string.equalsIgnoreCase("stitchTiles")) {
            if (string2.equalsIgnoreCase("stitch")) {
                this.getStitchTiles().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("noStitch")) {
                this.getStitchTiles().setBaseVal((short)2);
            } else {
                System.out.println("invalid value '" + string2 + "' for stitchTiles attribute, setting to default 'noStitch'");
                this.getType().setBaseVal((short)2);
                super.setAttribute("stitchTiles", "noStitch");
            }
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        String string = attr.getName();
        String string2 = attr.getValue();
        if (string.equalsIgnoreCase("baseFrequency")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            if (stringTokenizer.countTokens() == 1) {
                this.getBaseFrequencyX().setBaseVal(Float.parseFloat(stringTokenizer.nextToken()));
                this.getBaseFrequencyY().setBaseVal(this.getBaseFrequencyX().getBaseVal());
            } else if (stringTokenizer.countTokens() == 2) {
                this.getBaseFrequencyX().setBaseVal(Float.parseFloat(stringTokenizer.nextToken()));
                this.getBaseFrequencyY().setBaseVal(Float.parseFloat(stringTokenizer.nextToken()));
            }
        } else if (string.equalsIgnoreCase("numOctaves")) {
            this.getNumOctaves().setBaseVal(Integer.parseInt(string2));
        } else if (string.equalsIgnoreCase("seed")) {
            this.getSeed().setBaseVal(Float.parseFloat(string2));
        } else if (string.equalsIgnoreCase("type")) {
            if (string2.equalsIgnoreCase("fractalNoise")) {
                this.getType().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("turbulence")) {
                this.getType().setBaseVal((short)2);
            } else {
                System.out.println("invalid value '" + string2 + "' for type attribute, setting to default 'turbulence'");
                this.getType().setBaseVal((short)2);
                super.setAttribute("type", "turbulence");
            }
        } else if (string.equalsIgnoreCase("stitchTiles")) {
            if (string2.equalsIgnoreCase("stitch")) {
                this.getStitchTiles().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("noStitch")) {
                this.getStitchTiles().setBaseVal((short)2);
            } else {
                System.out.println("invalid value '" + string2 + "' for stitchTiles attribute, setting to default 'noStitch'");
                this.getType().setBaseVal((short)2);
                super.setAttribute("stitchTiles", "noStitch");
            }
        }
        return super.setAttributeNode(attr);
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("baseFrequencyX")) {
            ((SVGAnimatedValue)((Object)this.getBaseFrequencyX())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("baseFrequencyY")) {
            ((SVGAnimatedValue)((Object)this.getBaseFrequencyY())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("type")) {
            ((SVGAnimatedValue)((Object)this.getType())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("seed")) {
            ((SVGAnimatedValue)((Object)this.getSeed())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("numOctaves")) {
            ((SVGAnimatedValue)((Object)this.getNumOctaves())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("stitchTiles")) {
            ((SVGAnimatedValue)((Object)this.getStitchTiles())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }

    public void drawPrimitive(SVGFilterElementImpl sVGFilterElementImpl) {
        System.out.println("Initialising");
        this.init(0);
        System.out.println("done");
        System.out.println("turbulenced!");
    }

    private int setup_seed(int n) {
        if (n <= 0) {
            n = -(n % (RAND_m - 1)) + 1;
        }
        if (n > RAND_m - 1) {
            n = RAND_m - 1;
        }
        return n;
    }

    private int random(int n) {
        int n2 = RAND_a * (n % RAND_q) - RAND_r * (n / RAND_q);
        if (n2 <= 0) {
            n2 += RAND_m;
        }
        return n2;
    }

    private void init(int n) {
        int n2;
        if (fGradient == null) {
            fGradient = new double[4][BSize + BSize + 2][2];
        }
        int n3 = 0;
        n = this.setup_seed(n);
        int n4 = 0;
        while (n4 < 4) {
            n3 = 0;
            while (n3 < BSize) {
                this.uLatticeSelector[n3] = n3;
                n2 = 0;
                while (n2 < 2) {
                    n = this.random(n);
                    SVGFETurbulenceElementImpl.fGradient[n4][n3][n2] = (double)(n % (BSize + BSize) - BSize) / (double)BSize;
                    ++n2;
                }
                double d = Math.sqrt(fGradient[n4][n3][0] * fGradient[n4][n3][0] + fGradient[n4][n3][1] * fGradient[n4][n3][1]);
                double[] dArray = fGradient[n4][n3];
                dArray[0] = dArray[0] / d;
                double[] dArray2 = fGradient[n4][n3];
                dArray2[1] = dArray2[1] / d;
                ++n3;
            }
            ++n4;
        }
        while (--n3 != 0) {
            n4 = this.uLatticeSelector[n3];
            n = this.random(n);
            n2 = n % BSize;
            this.uLatticeSelector[n3] = this.uLatticeSelector[n2];
            this.uLatticeSelector[n2] = n4;
        }
        n3 = 0;
        while (n3 < BSize + 2) {
            this.uLatticeSelector[SVGFETurbulenceElementImpl.BSize + n3] = this.uLatticeSelector[n3];
            n4 = 0;
            while (n4 < 4) {
                n2 = 0;
                while (n2 < 2) {
                    SVGFETurbulenceElementImpl.fGradient[n4][SVGFETurbulenceElementImpl.BSize + n3][n2] = fGradient[n4][n3][n2];
                    ++n2;
                }
                ++n4;
            }
            ++n3;
        }
    }

    private double s_curve(double d) {
        return d * d * (3.0 - 2.0 * d);
    }

    private double lerp(double d, double d2, double d3) {
        return d2 + d * (d3 - d2);
    }

    private double noise2(int n, double[] dArray, StitchInfo stitchInfo) {
        double d = dArray[0] + (double)PerlinN;
        int n2 = (int)d;
        int n3 = n2 + 1;
        double d2 = d - (double)((int)d);
        double d3 = d2 - 1.0;
        d = dArray[1] + (double)PerlinN;
        int n4 = (int)d;
        int n5 = n4 + 1;
        double d4 = d - (double)((int)d);
        double d5 = d4 - 1.0;
        if (stitchInfo != null) {
            if (n2 >= stitchInfo.nWrapX) {
                n2 -= stitchInfo.nWidth;
            }
            if (n3 >= stitchInfo.nWrapX) {
                n3 -= stitchInfo.nWidth;
            }
            if (n4 >= stitchInfo.nWrapY) {
                n4 -= stitchInfo.nHeight;
            }
            if (n5 >= stitchInfo.nWrapY) {
                n5 -= stitchInfo.nHeight;
            }
        }
        int n6 = this.uLatticeSelector[n2 &= BM];
        int n7 = this.uLatticeSelector[n3 &= BM];
        int n8 = this.uLatticeSelector[n6 + (n4 &= BM)];
        int n9 = this.uLatticeSelector[n7 + n4];
        int n10 = this.uLatticeSelector[n6 + (n5 &= BM)];
        int n11 = this.uLatticeSelector[n7 + n5];
        double d6 = this.s_curve(d2);
        double d7 = this.s_curve(d4);
        double[] dArray2 = fGradient[n][n8];
        double d8 = d2 * dArray2[0] + d4 * dArray2[1];
        dArray2 = fGradient[n][n9];
        double d9 = d3 * dArray2[0] + d4 * dArray2[1];
        double d10 = this.lerp(d6, d8, d9);
        dArray2 = fGradient[n][n10];
        d8 = d2 * dArray2[0] + d5 * dArray2[1];
        dArray2 = fGradient[n][n11];
        d9 = d3 * dArray2[0] + d5 * dArray2[1];
        double d11 = this.lerp(d6, d8, d9);
        return this.lerp(d7, d10, d11);
    }

    private double turbulence(int n, double[] dArray, double d, double d2, int n2, boolean bl, boolean bl2, double d3, double d4, double d5, double d6) {
        double d7;
        StitchInfo stitchInfo = new StitchInfo();
        StitchInfo stitchInfo2 = null;
        if (bl2) {
            double d8;
            d7 = Math.floor(d5 * d) / d5;
            d = d / d7 < (d8 = Math.ceil(d5 * d) / d5) / d ? d7 : d8;
            d7 = Math.floor(d6 * d) / d6;
            d8 = Math.ceil(d6 * d) / d6;
            d2 = d2 / d7 < d8 / d2 ? d7 : d8;
            stitchInfo2 = stitchInfo;
            stitchInfo.nWidth = (int)(d5 * d + 0.5);
            stitchInfo.nWrapX = (int)(d3 * d + (double)PerlinN + (double)stitchInfo.nWidth);
            stitchInfo.nHeight = (int)(d6 * d2 + 0.5);
            stitchInfo.nWrapY = (int)(d4 * d2 + (double)PerlinN + (double)stitchInfo.nHeight);
        }
        d7 = 0.0;
        double[] dArray2 = new double[]{dArray[0] * d, dArray[1] * d2};
        double d9 = 1.0;
        int n3 = 0;
        while (n3 < n2) {
            d7 = bl ? (d7 += this.noise2(n, dArray2, stitchInfo2) / d9) : (d7 += Math.abs(this.noise2(n, dArray2, stitchInfo2)) / d9);
            dArray2[0] = dArray2[0] * 2.0;
            dArray2[1] = dArray2[1] * 2.0;
            d9 *= 2.0;
            if (stitchInfo2 != null) {
                stitchInfo.nWidth *= 2;
                stitchInfo.nWrapX = 2 * stitchInfo.nWrapX - PerlinN;
                stitchInfo.nHeight *= 2;
                stitchInfo.nWrapY = 2 * stitchInfo.nWrapY - PerlinN;
            }
            ++n3;
        }
        return d7;
    }

    static {
        RAND_m = Integer.MAX_VALUE;
        RAND_a = 16807;
        RAND_q = 127773;
        RAND_r = 2836;
        BSize = 256;
        BM = 255;
        PerlinN = 4096;
        NP = 12;
        NM = 4095;
        fGradient = null;
    }

    private class StitchInfo {
        int nWidth;
        int nHeight;
        int nWrapX;
        int nWrapY;

        private StitchInfo() {
        }
    }
}

