/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import java.util.Vector;
import org.csiro.svg.dom.SVGAnimatedBooleanImpl;
import org.csiro.svg.dom.SVGAnimatedEnumerationImpl;
import org.csiro.svg.dom.SVGAnimatedIntegerImpl;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedStringImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedInteger;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGFilterElement;

public class SVGFilterElementImpl
extends SVGStylableImpl
implements SVGFilterElement {
    protected SVGAnimatedLength x;
    protected SVGAnimatedLength y;
    protected SVGAnimatedLength width;
    protected SVGAnimatedLength height;
    protected SVGAnimatedInteger filterResX;
    protected SVGAnimatedInteger filterResY;
    protected SVGAnimatedEnumeration filterUnits;
    protected SVGAnimatedEnumeration primitiveUnits;
    protected SVGAnimatedString href;
    protected SVGAnimatedBoolean externalResourcesRequired;
    private static Vector filterUnitStrings;
    private static Vector filterUnitValues;
    BufferedImage sourceGraphic = null;
    BufferedImage sourceAlpha = null;
    BufferedImage backgroundImage = null;
    BufferedImage backgroundAlpha = null;
    BufferedImage fillPaint = null;
    BufferedImage strokePaint = null;
    BufferedImage resultImage = null;
    public Rectangle2D imageSpaceBounds = new Rectangle2D.Double();
    public Rectangle2D imageUserSpaceBounds = new Rectangle2D.Double();

    public SVGFilterElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "filter");
    }

    public SVGFilterElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "filter");
    }

    public SVGElementImpl cloneElement() {
        SVGAnimationElementImpl sVGAnimationElementImpl;
        int n;
        SVGFilterElementImpl sVGFilterElementImpl = new SVGFilterElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedLengthImpl)this.getX()).getAnimations();
        Vector vector2 = ((SVGAnimatedLengthImpl)this.getY()).getAnimations();
        Vector vector3 = ((SVGAnimatedLengthImpl)this.getWidth()).getAnimations();
        Vector vector4 = ((SVGAnimatedLengthImpl)this.getHeight()).getAnimations();
        Vector vector5 = ((SVGAnimatedIntegerImpl)this.getFilterResX()).getAnimations();
        Vector vector6 = ((SVGAnimatedIntegerImpl)this.getFilterResY()).getAnimations();
        Vector vector7 = ((SVGAnimatedEnumerationImpl)this.getFilterUnits()).getAnimations();
        Vector vector8 = ((SVGAnimatedEnumerationImpl)this.getPrimitiveUnits()).getAnimations();
        Vector vector9 = ((SVGAnimatedBooleanImpl)this.getExternalResourcesRequired()).getAnimations();
        Vector vector10 = ((SVGAnimatedStringImpl)this.getHref()).getAnimations();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGFilterElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector2.elementAt(n);
                sVGFilterElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector3 != null) {
            n = 0;
            while (n < vector3.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector3.elementAt(n);
                sVGFilterElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector4 != null) {
            n = 0;
            while (n < vector4.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector4.elementAt(n);
                sVGFilterElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector5 != null) {
            n = 0;
            while (n < vector5.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector5.elementAt(n);
                sVGFilterElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector6 != null) {
            n = 0;
            while (n < vector6.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector6.elementAt(n);
                sVGFilterElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector7 != null) {
            n = 0;
            while (n < vector7.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector7.elementAt(n);
                sVGFilterElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector8 != null) {
            n = 0;
            while (n < vector8.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector8.elementAt(n);
                sVGFilterElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector9 != null) {
            n = 0;
            while (n < vector9.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector9.elementAt(n);
                sVGFilterElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (vector10 != null) {
            n = 0;
            while (n < vector10.size()) {
                sVGAnimationElementImpl = (SVGAnimationElementImpl)vector10.elementAt(n);
                sVGFilterElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGFilterElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGFilterElementImpl;
    }

    public SVGAnimatedLength getX() {
        if (this.x == null) {
            SVGFilterElementImpl sVGFilterElementImpl = this.getReferencedFilter();
            if (sVGFilterElementImpl != null) {
                return sVGFilterElementImpl.getX();
            }
            this.x = new SVGAnimatedLengthImpl(new SVGLengthImpl("0%", (SVGElement)this, 0), this);
        }
        return this.x;
    }

    public SVGAnimatedLength getY() {
        if (this.y == null) {
            SVGFilterElementImpl sVGFilterElementImpl = this.getReferencedFilter();
            if (sVGFilterElementImpl != null) {
                return sVGFilterElementImpl.getY();
            }
            this.y = new SVGAnimatedLengthImpl(new SVGLengthImpl("0%", (SVGElement)this, 1), this);
        }
        return this.y;
    }

    public SVGAnimatedLength getWidth() {
        if (this.width == null) {
            SVGFilterElementImpl sVGFilterElementImpl = this.getReferencedFilter();
            if (sVGFilterElementImpl != null) {
                return sVGFilterElementImpl.getWidth();
            }
            this.width = new SVGAnimatedLengthImpl(new SVGLengthImpl("100%", (SVGElement)this, 0), this);
        }
        return this.width;
    }

    public SVGAnimatedLength getHeight() {
        if (this.height == null) {
            SVGFilterElementImpl sVGFilterElementImpl = this.getReferencedFilter();
            if (sVGFilterElementImpl != null) {
                return sVGFilterElementImpl.getHeight();
            }
            this.height = new SVGAnimatedLengthImpl(new SVGLengthImpl("100%", (SVGElement)this, 1), this);
        }
        return this.height;
    }

    public SVGAnimatedEnumeration getFilterUnits() {
        if (this.filterUnits == null) {
            SVGFilterElementImpl sVGFilterElementImpl = this.getReferencedFilter();
            if (sVGFilterElementImpl != null) {
                return sVGFilterElementImpl.getFilterUnits();
            }
            if (filterUnitStrings == null) {
                this.initFilterUnitVectors();
            }
            this.filterUnits = new SVGAnimatedEnumerationImpl(2, this, filterUnitStrings, filterUnitValues);
        }
        return this.filterUnits;
    }

    public SVGAnimatedEnumeration getPrimitiveUnits() {
        if (this.primitiveUnits == null) {
            SVGFilterElementImpl sVGFilterElementImpl = this.getReferencedFilter();
            if (sVGFilterElementImpl != null) {
                return sVGFilterElementImpl.getPrimitiveUnits();
            }
            if (filterUnitStrings == null) {
                this.initFilterUnitVectors();
            }
            this.primitiveUnits = new SVGAnimatedEnumerationImpl(1, this, filterUnitStrings, filterUnitValues);
        }
        return this.primitiveUnits;
    }

    private void initFilterUnitVectors() {
        if (filterUnitStrings == null) {
            filterUnitStrings = new Vector();
            filterUnitStrings.addElement("userSpaceOnUse");
            filterUnitStrings.addElement("objectBoundingBox");
        }
        if (filterUnitValues == null) {
            filterUnitValues = new Vector();
            filterUnitValues.addElement(new Short(1));
            filterUnitValues.addElement(new Short(2));
            filterUnitValues.addElement(new Short(0));
        }
    }

    public SVGAnimatedInteger getFilterResX() {
        if (this.filterResX == null) {
            SVGFilterElementImpl sVGFilterElementImpl = this.getReferencedFilter();
            if (sVGFilterElementImpl != null) {
                return sVGFilterElementImpl.getFilterResX();
            }
            this.filterResX = new SVGAnimatedIntegerImpl(400, this);
        }
        return this.filterResX;
    }

    public SVGAnimatedInteger getFilterResY() {
        if (this.filterResY == null) {
            SVGFilterElementImpl sVGFilterElementImpl = this.getReferencedFilter();
            if (sVGFilterElementImpl != null) {
                return sVGFilterElementImpl.getFilterResY();
            }
            this.filterResY = new SVGAnimatedIntegerImpl(400, this);
        }
        return this.filterResY;
    }

    public void setFilterRes(int n, int n2) {
        this.getFilterResX().setBaseVal(n);
        this.getFilterResY().setBaseVal(n2);
    }

    public String getXMLlang() {
        return this.getAttribute("xml:lang");
    }

    public void setXMLlang(String string) {
        if (string != null) {
            super.setAttribute("xml:lang", string);
        } else {
            this.removeAttribute("xml:lang");
        }
    }

    public String getXMLspace() {
        return this.getAttribute("xml:space");
    }

    public void setXMLspace(String string) {
        if (string != null) {
            super.setAttribute("xml:space", string);
        } else {
            this.removeAttribute("xml:space");
        }
    }

    public String getXlinkType() {
        return this.getAttribute("xlink:type");
    }

    public void setXlinkType(String string) throws DOMException {
        this.setAttribute("xlink:type", string);
    }

    public String getXlinkRole() {
        return this.getAttribute("xlink:role");
    }

    public void setXlinkRole(String string) throws DOMException {
        this.setAttribute("xlink:role", string);
    }

    public String getXlinkArcRole() {
        return this.getAttribute("xlink:arcrole");
    }

    public void setXlinkArcRole(String string) throws DOMException {
        this.setAttribute("xlink:arcrole", string);
    }

    public String getXlinkTitle() {
        return this.getAttribute("xlink:title");
    }

    public void setXlinkTitle(String string) throws DOMException {
        this.setAttribute("xlink:title", string);
    }

    public String getXlinkShow() {
        return this.getAttribute("xlink:show");
    }

    public void setXlinkShow(String string) throws DOMException {
        this.setAttribute("xlink:show", string);
    }

    public String getXlinkActuate() {
        return this.getAttribute("xlink:actuate");
    }

    public void setXlinkActuate(String string) throws DOMException {
        this.setAttribute("xlink:actuate", string);
    }

    public SVGAnimatedString getHref() {
        if (this.href == null) {
            this.href = new SVGAnimatedStringImpl("", this);
        }
        return this.href;
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        if (this.externalResourcesRequired == null) {
            this.externalResourcesRequired = new SVGAnimatedBooleanImpl(false, this);
        }
        return this.externalResourcesRequired;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("x")) {
            return this.getX().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("y")) {
            return this.getY().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("width")) {
            return this.getWidth().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("height")) {
            return this.getHeight().getBaseVal().getValueAsString();
        }
        if (string.equalsIgnoreCase("filterRes")) {
            return this.getFilterResX().getBaseVal() + " " + this.getFilterResY().getBaseVal();
        }
        if (string.equalsIgnoreCase("filterUnits")) {
            if (this.getFilterUnits().getBaseVal() == 2) {
                return "objectBoundingBox";
            }
            return "userSpaceOnUse";
        }
        if (string.equalsIgnoreCase("primitiveUnits")) {
            if (this.getPrimitiveUnits().getBaseVal() == 2) {
                return "objectBoundingBox";
            }
            return "userSpaceOnUse";
        }
        if (string.equalsIgnoreCase("xlink:href")) {
            return this.getHref().getBaseVal();
        }
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                return "true";
            }
            return "false";
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("x")) {
            attr.setValue(this.getX().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("y")) {
            attr.setValue(this.getY().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("width")) {
            attr.setValue(this.getWidth().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("height")) {
            attr.setValue(this.getHeight().getBaseVal().getValueAsString());
        } else if (string.equalsIgnoreCase("filterRes")) {
            attr.setValue(this.getFilterResX().getBaseVal() + " " + this.getFilterResY().getBaseVal());
        } else if (string.equalsIgnoreCase("filterUnits")) {
            if (this.getFilterUnits().getBaseVal() == 2) {
                attr.setValue("objectBoundingBox");
            } else {
                attr.setValue("userSpaceOnUse");
            }
        } else if (string.equalsIgnoreCase("primitiveUnits")) {
            if (this.getPrimitiveUnits().getBaseVal() == 2) {
                attr.setValue("objectBoundingBox");
            } else {
                attr.setValue("userSpaceOnUse");
            }
        } else if (string.equalsIgnoreCase("xlink:href")) {
            attr.setValue(this.getHref().getBaseVal());
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                attr.setValue("true");
            } else {
                attr.setValue("false");
            }
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        if (string.equalsIgnoreCase("x")) {
            ((SVGAnimatedLengthImpl)this.getX()).setBaseVal(new SVGLengthImpl(string2, (SVGElement)this, 0));
        } else if (string.equalsIgnoreCase("y")) {
            ((SVGAnimatedLengthImpl)this.getY()).setBaseVal(new SVGLengthImpl(string2, (SVGElement)this, 1));
        } else if (string.equalsIgnoreCase("width")) {
            ((SVGAnimatedLengthImpl)this.getWidth()).setBaseVal(new SVGLengthImpl(string2, (SVGElement)this, 0));
        } else if (string.equalsIgnoreCase("height")) {
            ((SVGAnimatedLengthImpl)this.getHeight()).setBaseVal(new SVGLengthImpl(string2, (SVGElement)this, 1));
        } else if (string.equalsIgnoreCase("filterRes")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.countTokens() == 1) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                this.getFilterResX().setBaseVal(n);
                this.getFilterResY().setBaseVal(n);
            } else {
                this.getFilterResX().setBaseVal(Integer.parseInt(stringTokenizer.nextToken()));
                this.getFilterResY().setBaseVal(Integer.parseInt(stringTokenizer.nextToken()));
            }
        } else if (string.equalsIgnoreCase("filterUnits")) {
            if (string2.equalsIgnoreCase("userSpaceOnUse")) {
                this.getFilterUnits().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("objectBoundingBox")) {
                this.getFilterUnits().setBaseVal((short)2);
            } else {
                System.out.println("invalid value '" + string2 + "' for filterUnits attribute, setting to default 'objectBoundingBox'");
                this.getFilterUnits().setBaseVal((short)2);
                super.setAttribute("filterUnits", "objectBoundingBox");
            }
        } else if (string.equalsIgnoreCase("primitiveUnits")) {
            if (string2.equalsIgnoreCase("userSpaceOnUse")) {
                this.getPrimitiveUnits().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("objectBoundingBox")) {
                this.getPrimitiveUnits().setBaseVal((short)2);
            } else {
                System.out.println("invalid value '" + string2 + "' for primitiveUnits attribute, setting to default 'userSpaceOnUse'");
                this.getPrimitiveUnits().setBaseVal((short)1);
                super.setAttribute("primitiveUnits", "userSpaceOnUse");
            }
        } else if (string.equalsIgnoreCase("xlink:href")) {
            this.getHref().setBaseVal(string2);
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (string2.equalsIgnoreCase("true")) {
                this.getExternalResourcesRequired().setBaseVal(true);
            } else {
                this.getExternalResourcesRequired().setBaseVal(false);
            }
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        String string = attr.getName();
        String string2 = attr.getValue();
        if (string.equalsIgnoreCase("x")) {
            ((SVGAnimatedLengthImpl)this.getX()).setBaseVal(new SVGLengthImpl(string2, (SVGElement)this, 0));
        } else if (string.equalsIgnoreCase("y")) {
            ((SVGAnimatedLengthImpl)this.getY()).setBaseVal(new SVGLengthImpl(string2, (SVGElement)this, 1));
        } else if (string.equalsIgnoreCase("width")) {
            ((SVGAnimatedLengthImpl)this.getWidth()).setBaseVal(new SVGLengthImpl(string2, (SVGElement)this, 0));
        } else if (string.equalsIgnoreCase("height")) {
            ((SVGAnimatedLengthImpl)this.getHeight()).setBaseVal(new SVGLengthImpl(string2, (SVGElement)this, 1));
        } else if (string.equalsIgnoreCase("filterRes")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.countTokens() == 1) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                this.getFilterResX().setBaseVal(n);
                this.getFilterResY().setBaseVal(n);
            } else {
                this.getFilterResX().setBaseVal(Integer.parseInt(stringTokenizer.nextToken()));
                this.getFilterResY().setBaseVal(Integer.parseInt(stringTokenizer.nextToken()));
            }
        } else if (string.equalsIgnoreCase("filterUnits")) {
            if (string2.equalsIgnoreCase("userSpaceOnUse")) {
                this.getFilterUnits().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("objectBoundingBox")) {
                this.getFilterUnits().setBaseVal((short)2);
            } else {
                System.out.println("invalid value '" + string2 + "' for filterUnits attribute, setting to default 'objectBoundingBox'");
                this.getFilterUnits().setBaseVal((short)2);
                attr.setValue("objectBoundingBox");
            }
        } else if (string.equalsIgnoreCase("primitiveUnits")) {
            if (string2.equalsIgnoreCase("userSpaceOnUse")) {
                this.getPrimitiveUnits().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("objectBoundingBox")) {
                this.getPrimitiveUnits().setBaseVal((short)2);
            } else {
                System.out.println("invalid value '" + string2 + "' for primitiveUnits attribute, setting to default 'userSpaceOnUse'");
                this.getPrimitiveUnits().setBaseVal((short)1);
                attr.setValue("userSpaceOnUse");
            }
        } else if (string.equalsIgnoreCase("xlink:href")) {
            this.getHref().setBaseVal(string2);
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (string2.equalsIgnoreCase("true")) {
                this.getExternalResourcesRequired().setBaseVal(true);
            } else {
                this.getExternalResourcesRequired().setBaseVal(false);
            }
        }
        return super.setAttributeNode(attr);
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("x")) {
            ((SVGAnimatedValue)((Object)this.getX())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("y")) {
            ((SVGAnimatedValue)((Object)this.getY())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("width")) {
            ((SVGAnimatedValue)((Object)this.getWidth())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("height")) {
            ((SVGAnimatedValue)((Object)this.getHeight())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("filterUnits")) {
            ((SVGAnimatedValue)((Object)this.getFilterUnits())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("primitiveUnits")) {
            ((SVGAnimatedValue)((Object)this.getPrimitiveUnits())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("filterRes")) {
            ((SVGAnimatedValue)((Object)this.getFilterResX())).addAnimation(sVGAnimationElementImpl);
            ((SVGAnimatedValue)((Object)this.getFilterResY())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("href")) {
            ((SVGAnimatedValue)((Object)this.getHref())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("externalResourcesRequired")) {
            ((SVGAnimatedValue)((Object)this.getExternalResourcesRequired())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }

    protected SVGFilterElementImpl getReferencedFilter() {
        String string = this.getHref().getAnimVal();
        if (string.length() > 0 && string.indexOf(35) != -1) {
            int n = string.indexOf(35);
            String string2 = string.substring(n + 1, string.length());
            Element element = this.getOwnerDoc().getElementById(string2);
            if (element != null && element instanceof SVGFilterElementImpl) {
                return (SVGFilterElementImpl)element;
            }
        }
        return null;
    }

    public void setSourceGraphic(BufferedImage bufferedImage) {
        this.sourceGraphic = bufferedImage;
        this.sourceAlpha = null;
    }

    public BufferedImage getSourceGraphic() {
        return this.sourceGraphic;
    }

    public BufferedImage getSourceAlpha() {
        if (this.sourceAlpha == null) {
            int n = this.sourceGraphic.getWidth();
            int n2 = this.sourceGraphic.getHeight();
            this.sourceAlpha = new BufferedImage(n, n2, 3);
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = this.sourceGraphic.getRGB(n4, n5);
                    if ((n6 &= 0xFF000000) != 0) {
                        ++n3;
                    }
                    this.sourceAlpha.setRGB(n4, n5, n6);
                    ++n5;
                }
                ++n4;
            }
        }
        return this.sourceAlpha;
    }

    public void setBackgroundImage(BufferedImage bufferedImage) {
        this.backgroundImage = bufferedImage;
        this.backgroundAlpha = null;
    }

    public BufferedImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public BufferedImage getBackgroundAlpha() {
        if (this.backgroundAlpha == null) {
            int n = this.backgroundImage.getWidth();
            int n2 = this.backgroundImage.getHeight();
            this.backgroundAlpha = new BufferedImage(n, n2, 3);
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = this.backgroundImage.getRGB(n3, n4);
                    this.backgroundAlpha.setRGB(n3, n4, n5 &= 0xFF000000);
                    ++n4;
                }
                ++n3;
            }
        }
        return this.backgroundAlpha;
    }

    public void clearImages() {
        this.sourceGraphic = null;
        this.sourceAlpha = null;
        this.backgroundImage = null;
        this.backgroundAlpha = null;
        this.fillPaint = null;
        this.strokePaint = null;
        this.resultImage = null;
    }

    public void setResultImage(BufferedImage bufferedImage) {
        this.resultImage = bufferedImage;
    }

    public void setRealBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.imageSpaceBounds.setRect(rectangle2D);
        this.imageUserSpaceBounds.setRect(rectangle2D2);
    }

    public void filter() {
        if (this.resultImage != null) {
            Graphics2D graphics2D = this.resultImage.createGraphics();
            graphics2D.setColor(Color.blue);
            graphics2D.drawRect(0, 0, this.resultImage.getWidth() - 1, this.resultImage.getHeight() - 1);
            graphics2D.dispose();
        }
    }
}

