/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import org.csiro.svg.dom.SVGAnimatedBooleanImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGFontFaceElementImpl;
import org.csiro.svg.dom.SVGGlyphElementImpl;
import org.csiro.svg.dom.SVGMissingGlyphElementImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.csiro.svg.dom.SVGTextElementImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGFontElement;
import org.w3c.dom.svg.SVGRect;

public class SVGFontElementImpl
extends SVGStylableImpl
implements SVGFontElement {
    protected static final int INITIAL = 0;
    protected static final int MEDIAL = 1;
    protected static final int TERMINAL = 2;
    protected static final int ISOLATED = 3;
    protected SVGAnimatedBoolean externalResourcesRequired;
    private SVGFontFaceElementImpl fontFaceElem;

    public SVGFontElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "font");
    }

    public SVGFontElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "font");
    }

    public SVGElementImpl cloneElement() {
        SVGFontElementImpl sVGFontElementImpl = new SVGFontElementImpl(this.getOwnerDoc(), this);
        Vector vector = ((SVGAnimatedBooleanImpl)this.getExternalResourcesRequired()).getAnimations();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                SVGAnimationElementImpl sVGAnimationElementImpl = (SVGAnimationElementImpl)vector.elementAt(n);
                sVGFontElementImpl.attachAnimation(sVGAnimationElementImpl);
                ++n;
            }
        }
        if (this.animatedProperties != null) {
            sVGFontElementImpl.animatedProperties = this.animatedProperties;
        }
        return sVGFontElementImpl;
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        if (this.externalResourcesRequired == null) {
            this.externalResourcesRequired = new SVGAnimatedBooleanImpl(false, this);
        }
        return this.externalResourcesRequired;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                return "true";
            }
            return "false";
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                attr.setValue("true");
            } else {
                attr.setValue("false");
            }
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (string2.equalsIgnoreCase("true")) {
                this.getExternalResourcesRequired().setBaseVal(true);
            } else {
                this.getExternalResourcesRequired().setBaseVal(false);
            }
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        String string = attr.getName();
        String string2 = attr.getValue();
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (string2.equalsIgnoreCase("true")) {
                this.getExternalResourcesRequired().setBaseVal(true);
            } else {
                this.getExternalResourcesRequired().setBaseVal(false);
            }
        }
        return super.setAttributeNode(attr);
    }

    public SVGGlyphElementImpl getGlyph(String string, int n) {
        NodeList nodeList = this.getChildNodes();
        int n2 = nodeList.getLength();
        String string2 = "";
        if (n == 0) {
            string2 = "initial";
        } else if (n == 3) {
            string2 = "isolated";
        } else if (n == 2) {
            string2 = "terminal";
        } else if (n == 1) {
            string2 = "medial";
        }
        String string3 = "";
        if (n == 0) {
            string3 = "zht";
        } else if (n == 3) {
            string3 = "ja";
        } else if (n == 2) {
            string3 = "kor";
        } else if (n == 1) {
            string3 = "zhs";
        }
        int n3 = 0;
        while (n3 < n2) {
            SVGGlyphElementImpl sVGGlyphElementImpl;
            Node node = nodeList.item(n3);
            if (node instanceof SVGGlyphElementImpl && (sVGGlyphElementImpl = (SVGGlyphElementImpl)node).getAttribute("unicode").equals(string) && (sVGGlyphElementImpl.getAttribute("arabic") == "" || sVGGlyphElementImpl.getAttribute("arabic").equals(string2)) && (sVGGlyphElementImpl.getAttribute("han") == "" || sVGGlyphElementImpl.getAttribute("han").equals(string3))) {
                return sVGGlyphElementImpl;
            }
            ++n3;
        }
        return null;
    }

    public SVGMissingGlyphElementImpl getMissingGlyph() {
        NodeList nodeList = this.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof SVGMissingGlyphElementImpl) {
                return (SVGMissingGlyphElementImpl)node;
            }
            ++n2;
        }
        return null;
    }

    public SVGFontFaceElementImpl getFontFace() {
        if (this.fontFaceElem != null) {
            return this.fontFaceElem;
        }
        NodeList nodeList = this.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof SVGFontFaceElementImpl) {
                this.fontFaceElem = (SVGFontFaceElementImpl)node;
                return this.fontFaceElem;
            }
            ++n2;
        }
        return null;
    }

    public String getFamilyName() {
        SVGFontFaceElementImpl sVGFontFaceElementImpl = this.getFontFace();
        if (sVGFontFaceElementImpl != null) {
            return sVGFontFaceElementImpl.getAttribute("font-family");
        }
        return "";
    }

    public String getFontWeight() {
        String string;
        SVGFontFaceElementImpl sVGFontFaceElementImpl = this.getFontFace();
        if (sVGFontFaceElementImpl != null && (string = sVGFontFaceElementImpl.getAttribute("font-weight")).length() > 0) {
            return string;
        }
        return "normal";
    }

    public String getFontStyle() {
        String string;
        SVGFontFaceElementImpl sVGFontFaceElementImpl = this.getFontFace();
        if (sVGFontFaceElementImpl != null && (string = sVGFontFaceElementImpl.getAttribute("font-style")).length() > 0) {
            return string;
        }
        return "normal";
    }

    public float getFontUnitsPerEm() {
        SVGFontFaceElementImpl sVGFontFaceElementImpl = this.getFontFace();
        if (sVGFontFaceElementImpl != null) {
            String string = sVGFontFaceElementImpl.getAttribute("units-per-em");
            if (string.length() == 0) {
                string = sVGFontFaceElementImpl.getAttribute("ascent");
            }
            if (string.length() == 0) {
                string = sVGFontFaceElementImpl.getAttribute("x-height");
            }
            if (string.length() == 0) {
                string = sVGFontFaceElementImpl.getAttribute("cap-height");
            }
            if (string.length() == 0) {
                string = sVGFontFaceElementImpl.getAttribute("top-line");
            }
            if (string.length() > 0) {
                return Float.parseFloat(string);
            }
        }
        return 1.0f;
    }

    public float getFontAscent() {
        SVGFontFaceElementImpl sVGFontFaceElementImpl = this.getFontFace();
        if (sVGFontFaceElementImpl != null) {
            String string = sVGFontFaceElementImpl.getAttribute("ascent");
            if (string.length() == 0) {
                string = sVGFontFaceElementImpl.getAttribute("x-height");
            }
            if (string.length() == 0) {
                string = sVGFontFaceElementImpl.getAttribute("cap-height");
            }
            if (string.length() == 0) {
                string = sVGFontFaceElementImpl.getAttribute("top-line");
            }
            if (string.length() > 0) {
                return Float.parseFloat(string);
            }
        }
        return 1.0f;
    }

    public float getFontDescent() {
        String string;
        SVGFontFaceElementImpl sVGFontFaceElementImpl = this.getFontFace();
        if (sVGFontFaceElementImpl != null && (string = sVGFontFaceElementImpl.getAttribute("descent")).length() > 0) {
            return Float.parseFloat(string);
        }
        return 0.0f;
    }

    public float getHorizAdvX() {
        String string = this.getAttribute("horiz-adv-x");
        if (string.length() > 0) {
            return Float.parseFloat(string);
        }
        return 0.0f;
    }

    public Rectangle2D getBounds(String string, float f, float f2, float f3) {
        float f4 = this.getFontAscent();
        float f5 = this.getFontDescent();
        if (f5 < 0.0f) {
            f5 = -f5;
        }
        float f6 = this.getHorizAdvX();
        float f7 = f3 / this.getFontUnitsPerEm();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float f8 = f2 + f5 * f7;
        float f9 = f2 - f4 * f7;
        float f10 = f;
        int n = string.length();
        float f11 = 0.0f;
        int n2 = 3;
        int n3 = 0;
        while (n3 < n) {
            Object object;
            String string2 = "" + string.charAt(n3);
            boolean bl = false;
            boolean bl2 = false;
            if (n == 1 || n3 == 0 || string.charAt(n3 - 1) == ' ') {
                bl = true;
            }
            if (n3 + 1 == n || string.charAt(n3 + 1) == ' ') {
                bl2 = true;
            }
            if (bl && bl2) {
                n2 = 3;
            } else if (bl && !bl2) {
                n2 = 0;
            } else if (!bl && bl2) {
                n2 = 2;
            } else if (!bl && !bl2) {
                n2 = 1;
            }
            SVGGlyphElementImpl sVGGlyphElementImpl = this.getGlyph(string2, n2);
            if (sVGGlyphElementImpl != null) {
                object = sVGGlyphElementImpl.getBBox();
                float f12 = (object.getX() * 2.0f + object.getWidth()) * f7;
                f11 += f12;
            } else {
                object = this.getMissingGlyph();
                if (object != null) {
                    SVGRect sVGRect = ((SVGMissingGlyphElementImpl)object).getBBox();
                    float f13 = (sVGRect.getX() * 2.0f + sVGRect.getWidth()) * f7;
                    f11 += f13;
                } else {
                    f11 += f6 * f7;
                }
            }
            ++n3;
        }
        ((Rectangle2D)float_).setRect(f10, f9, f11, f8 - f9);
        return float_;
    }

    public void drawText(Graphics2D graphics2D, SVGTextElementImpl sVGTextElementImpl, String string, float f, float f2, float f3, boolean bl) {
        float f4 = this.getHorizAdvX();
        float f5 = this.getFontAscent();
        float f6 = f3 / this.getFontUnitsPerEm();
        int n = string.length();
        float f7 = f;
        int n2 = 3;
        int n3 = 0;
        while (n3 < n) {
            String string2 = "" + string.charAt(n3);
            boolean bl2 = false;
            boolean bl3 = false;
            if (n == 1 || n3 == 0 || string.charAt(n3 - 1) == ' ') {
                bl2 = true;
            }
            if (n3 + 1 == n || string.charAt(n3 + 1) == ' ') {
                bl3 = true;
            }
            if (bl2 && bl3) {
                n2 = 3;
            } else if (bl2 && !bl3) {
                n2 = 0;
            } else if (!bl2 && bl3) {
                n2 = 2;
            } else if (!bl2 && !bl3) {
                n2 = 1;
            }
            SVGGlyphElementImpl sVGGlyphElementImpl = this.getGlyph(string2, n2);
            if (sVGGlyphElementImpl != null) {
                sVGGlyphElementImpl.drawGlyph(graphics2D, sVGTextElementImpl, f7, f2, f3, bl);
                float f8 = 0.0f;
                if (sVGGlyphElementImpl.getHorizAdvX() != 0.0f) {
                    f8 = sVGGlyphElementImpl.getHorizAdvX() * f6;
                } else {
                    SVGRect sVGRect = sVGGlyphElementImpl.getBBox();
                    f8 = (sVGRect.getX() * 2.0f + sVGRect.getWidth()) * f6;
                }
                f7 += f8;
            } else {
                SVGMissingGlyphElementImpl sVGMissingGlyphElementImpl = this.getMissingGlyph();
                if (sVGMissingGlyphElementImpl != null) {
                    sVGMissingGlyphElementImpl.drawGlyph(graphics2D, sVGTextElementImpl, f7, f2, f3, bl);
                    float f9 = 0.0f;
                    if (sVGMissingGlyphElementImpl.getHorizAdvX() != 0.0f) {
                        f9 = sVGMissingGlyphElementImpl.getHorizAdvX() * f6;
                    } else {
                        SVGRect sVGRect = sVGMissingGlyphElementImpl.getBBox();
                        f9 = (sVGRect.getX() * 2.0f + sVGRect.getWidth()) * f6;
                    }
                    f7 += f9;
                } else {
                    f7 += f4 * f6;
                }
            }
            ++n3;
        }
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("externalResourcesRequired")) {
            ((SVGAnimatedValue)((Object)this.getExternalResourcesRequired())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

