/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.csiro.svg.dom.BasicShape;
import org.csiro.svg.dom.Drawable;
import org.csiro.svg.dom.SVGAElementImpl;
import org.csiro.svg.dom.SVGAnimatedLengthImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGFontElementImpl;
import org.csiro.svg.dom.SVGGElementImpl;
import org.csiro.svg.dom.SVGImageElementImpl;
import org.csiro.svg.dom.SVGLengthImpl;
import org.csiro.svg.dom.SVGPathSegArcAbsImpl;
import org.csiro.svg.dom.SVGPathSegArcRelImpl;
import org.csiro.svg.dom.SVGPathSegClosePathImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoCubicAbsImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoCubicRelImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoCubicSmoothAbsImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoCubicSmoothRelImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoQuadraticAbsImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoQuadraticRelImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoQuadraticSmoothAbsImpl;
import org.csiro.svg.dom.SVGPathSegCurvetoQuadraticSmoothRelImpl;
import org.csiro.svg.dom.SVGPathSegLinetoAbsImpl;
import org.csiro.svg.dom.SVGPathSegLinetoHorizontalAbsImpl;
import org.csiro.svg.dom.SVGPathSegLinetoHorizontalRelImpl;
import org.csiro.svg.dom.SVGPathSegLinetoRelImpl;
import org.csiro.svg.dom.SVGPathSegLinetoVerticalAbsImpl;
import org.csiro.svg.dom.SVGPathSegLinetoVerticalRelImpl;
import org.csiro.svg.dom.SVGPathSegListImpl;
import org.csiro.svg.dom.SVGPathSegMovetoAbsImpl;
import org.csiro.svg.dom.SVGPathSegMovetoRelImpl;
import org.csiro.svg.dom.SVGPointImpl;
import org.csiro.svg.dom.SVGPointListImpl;
import org.csiro.svg.dom.SVGRectImpl;
import org.csiro.svg.dom.SVGSVGElementImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.csiro.svg.dom.SVGTransformableImpl;
import org.csiro.svg.dom.SVGUseElementImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGAnimatedNumber;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGGlyphElement;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothRel;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalRel;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGTransformList;
import org.w3c.dom.svg.SVGTransformable;
import org.w3c.dom.svg.SVGUseElement;

public class SVGGlyphElementImpl
extends SVGStylableImpl
implements SVGGlyphElement {
    protected SVGPathSegListImpl pathSegList;
    protected SVGPathSegListImpl animPathSegList;
    protected SVGAnimatedNumber pathLength;
    protected boolean animated;
    SVGGlyphElementImpl clonedGlyph = null;
    float fontHeight = 10.0f;
    BasicStroke stroke = null;
    Paint fillPaint = null;
    Paint linePaint = null;
    private Shape compositeShape;
    GeneralPath path = null;

    public SVGGlyphElementImpl(SVGDocumentImpl sVGDocumentImpl) {
        super(sVGDocumentImpl, "glyph");
    }

    public SVGGlyphElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element) {
        super(sVGDocumentImpl, element, "glyph");
    }

    public SVGElementImpl cloneElement() {
        return new SVGGlyphElementImpl(this.getOwnerDoc(), this);
    }

    public void drawGlyph(Graphics2D graphics2D, SVGElementImpl sVGElementImpl, float f, float f2, float f3, boolean bl) {
        if (bl || this.clonedGlyph == null) {
            this.refreshData();
            this.clonedGlyph = (SVGGlyphElementImpl)this.cloneElement();
            this.fontHeight = ((SVGFontElementImpl)this.getParentNode()).getFontUnitsPerEm();
            this.compositeShape = null;
        }
        if (this.clonedGlyph != null) {
            Node node;
            Node node2;
            if (this.getAttribute("d") != "") {
                node2 = this.getParentNode();
                node = this.getNextSibling();
                node2.removeChild(this);
                sVGElementImpl.appendChild(this);
                this.drawOutline(graphics2D, f, f2, f3);
                sVGElementImpl.removeChild(this);
                node2.insertBefore(this, node);
                this.refreshData();
            }
            if (this.hasChildNodes()) {
                node2 = new SVGSVGElementImpl(sVGElementImpl.getOwnerDoc());
                node = new SVGGElementImpl(sVGElementImpl.getOwnerDoc());
                SVGGElementImpl sVGGElementImpl = new SVGGElementImpl(sVGElementImpl.getOwnerDoc());
                sVGElementImpl.appendChild(node);
                ((SVGElementImpl)node).appendChild(node2);
                ((SVGElementImpl)node2).appendChild(sVGGElementImpl);
                ((SVGElementImpl)node).copyAttributes((SVGFontElementImpl)this.getParentNode());
                sVGGElementImpl.copyAttributes(this);
                Vector<Node> vector = new Vector<Node>();
                if (this.clonedGlyph.hasChildNodes()) {
                    NodeList nodeList = this.clonedGlyph.getChildNodes();
                    int n = nodeList.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        Node node3 = nodeList.item(n2);
                        if (node3 instanceof Drawable) {
                            vector.add(node3);
                        }
                        ++n2;
                    }
                }
                int n = 0;
                while (n < vector.size()) {
                    Node node4 = (Node)vector.elementAt(n);
                    this.clonedGlyph.removeChild(node4);
                    sVGGElementImpl.appendChild(node4);
                    ++n;
                }
                String string = "translate(" + f + "," + f2 + ")";
                SVGTransformList sVGTransformList = SVGTransformListImpl.createTransformList(string);
                ((SVGAnimatedTransformListImpl)((SVGTransformableImpl)node).getTransform()).setBaseVal(sVGTransformList);
                string = "scale(1,-1)";
                sVGTransformList = SVGTransformListImpl.createTransformList(string);
                ((SVGAnimatedTransformListImpl)sVGGElementImpl.getTransform()).setBaseVal(sVGTransformList);
                float f4 = f3;
                float f5 = f3;
                ((SVGSVGElementImpl)node2).setAttribute("style", "overflow: visible");
                ((SVGAnimatedLengthImpl)((SVGSVGElementImpl)node2).getWidth()).setBaseVal(new SVGLengthImpl(f4, (SVGElement)node2, 0));
                ((SVGAnimatedLengthImpl)((SVGSVGElementImpl)node2).getHeight()).setBaseVal(new SVGLengthImpl(f5, (SVGElement)node2, 0));
                ((SVGSVGElementImpl)node2).setAttribute("viewBox", "0, 0, " + this.fontHeight + ", " + this.fontHeight);
                ((SVGGElementImpl)node).draw(graphics2D, true);
                int n3 = 0;
                while (n3 < vector.size()) {
                    Node node5 = (Node)vector.elementAt(n3);
                    sVGGElementImpl.removeChild(node5);
                    this.clonedGlyph.appendChild(node5);
                    ++n3;
                }
                sVGElementImpl.removeChild(node);
            }
        }
    }

    public void drawOutline(Graphics2D graphics2D, float f, float f2, float f3) {
        this.refreshData();
        GeneralPath generalPath = this.getShape();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f, f2);
        affineTransform.scale(f3 / this.fontHeight, -1.0f * f3 / this.fontHeight);
        Shape shape = affineTransform.createTransformedShape(generalPath);
        this.stroke = this.getStroke();
        this.fillPaint = this.getFillPaint();
        this.linePaint = this.getLinePaint();
        graphics2D.setStroke(this.stroke);
        if (this.fillPaint != null) {
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(shape);
        }
        if (this.linePaint != null) {
            graphics2D.setPaint(this.linePaint);
            graphics2D.draw(shape);
        }
    }

    public SVGRect getBBox() {
        Shape shape = this.getCompositeShape();
        Rectangle2D rectangle2D = shape.getBounds2D();
        SVGRectImpl sVGRectImpl = new SVGRectImpl(rectangle2D);
        return sVGRectImpl;
    }

    Shape getCompositeShape() {
        if (this.compositeShape != null) {
            return this.compositeShape;
        }
        GeneralPath generalPath = this.getAttribute("d") != "" ? this.getShape() : new GeneralPath();
        if (this.hasChildNodes()) {
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                AffineTransform affineTransform;
                Object object;
                Node node = nodeList.item(n2);
                Shape shape = null;
                if (node instanceof BasicShape) {
                    shape = ((BasicShape)((Object)node)).getShape();
                } else if (node instanceof SVGGElementImpl) {
                    shape = ((SVGGElementImpl)((Object)shape)).getCompositeShape();
                } else if (node instanceof SVGAElementImpl) {
                    shape = ((SVGAElementImpl)((Object)shape)).getCompositeShape();
                } else if (node instanceof SVGImageElementImpl) {
                    object = ((SVGImageElement)node).getBBox();
                    shape = new Rectangle2D.Float(object.getX(), object.getY(), object.getWidth(), object.getHeight());
                } else if (node instanceof SVGUseElementImpl) {
                    object = ((SVGUseElement)node).getBBox();
                    shape = new Rectangle2D.Float(object.getX(), object.getY(), object.getWidth(), object.getHeight());
                } else if (node instanceof SVGSVGElementImpl) {
                    AffineTransform affineTransform2;
                    object = (SVGSVGElement)node;
                    affineTransform = new AffineTransform();
                    try {
                        affineTransform2 = affineTransform.createInverse();
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        affineTransform2 = null;
                    }
                    float f = ((SVGLengthImpl)((Object)object.getX())).getTransformedLength(affineTransform2);
                    float f2 = ((SVGLengthImpl)((Object)object.getY())).getTransformedLength(affineTransform2);
                    float f3 = ((SVGLengthImpl)((Object)object.getWidth())).getTransformedLength(affineTransform2);
                    float f4 = ((SVGLengthImpl)((Object)object.getHeight())).getTransformedLength(affineTransform2);
                    shape = new Rectangle2D.Float(f, f2, f3, f4);
                }
                if (node instanceof SVGTransformable && (object = ((SVGTransformable)((Object)node)).getTransform()) != null) {
                    affineTransform = ((SVGTransformListImpl)object.getAnimVal()).getAffineTransform();
                    shape = affineTransform.createTransformedShape(shape);
                }
                if (shape != null) {
                    generalPath.append(shape, false);
                }
                ++n2;
            }
        }
        this.compositeShape = generalPath;
        return this.compositeShape;
    }

    public float getHorizAdvX() {
        String string = this.getAttribute("horiz-adv-x");
        if (string.length() > 0) {
            return Float.parseFloat(string);
        }
        return 0.0f;
    }

    public GeneralPath getShape() {
        if (this.path == null) {
            this.path = this.createShape(new SVGPointListImpl());
        }
        return this.path;
    }

    private void constructPathSegList(String string) {
        this.pathSegList = new SVGPathSegListImpl();
        String string2 = "MmLlCcZzSsHhVvQqTtAa";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            while (string2.indexOf(string3) == -1 && stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (string2.indexOf(string3) == -1) continue;
            if (string3.equals("Z") || string3.equals("z")) {
                this.addCommand(string3, null, string);
                continue;
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string4 = stringTokenizer.nextToken();
            this.addCommand(string3, string4, string);
        }
        this.animated = false;
        this.animPathSegList = this.animated ? new SVGPathSegListImpl(this.pathSegList) : this.pathSegList;
    }

    private void addCommand(String string, String string2, String string3) {
        if (string.equals("Z") || string.equals("z")) {
            SVGPathSegClosePathImpl sVGPathSegClosePathImpl = new SVGPathSegClosePathImpl();
            this.pathSegList.appendItem(sVGPathSegClosePathImpl);
        } else if (string.equals("M") || string.equals("m")) {
            this.addMoveTo(string, string2);
        } else if (string.equals("L") || string.equals("l")) {
            this.addLineTo(string, string2);
        } else if (string.equals("C") || string.equals("c")) {
            this.addCurveTo(string, string2);
        } else if (string.equals("S") || string.equals("s")) {
            this.addSmoothCurveTo(string, string2);
        } else if (string.equals("H") || string.equals("h")) {
            this.addHorizontalLineTo(string, string2);
        } else if (string.equals("V") || string.equals("v")) {
            this.addVerticalLineTo(string, string2);
        } else if (string.equals("Q") || string.equals("q")) {
            this.addQuadraticBezierCurveTo(string, string2);
        } else if (string.equals("T") || string.equals("t")) {
            this.addTruetypeQuadraticBezierCurveTo(string, string2);
        } else if (string.equals("A") || string.equals("a")) {
            this.addEllipticArc(string, string2);
        } else {
            System.out.println("Unrecognised path command: '" + string + "' in path: " + string3);
        }
    }

    private String getNextToken(StringTokenizer stringTokenizer, String string, String string2) {
        String string3;
        boolean bl = false;
        try {
            string3 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens() && string.indexOf(string3) != -1) {
                bl = string3.equals("-");
                string3 = stringTokenizer.nextToken();
            }
            if (string.indexOf(string3) != -1) {
                string3 = string2;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            string3 = string2;
        }
        if (bl) {
            string3 = "-" + string3;
        }
        if (string3.endsWith("e") || string3.endsWith("E")) {
            try {
                String string4 = stringTokenizer.nextToken();
                string4 = string4 + stringTokenizer.nextToken();
                string3 = string3 + string4;
            }
            catch (NoSuchElementException noSuchElementException) {
                string3 = string3 + '0';
            }
        }
        return string3;
    }

    private String trimCommas(String string) {
        String string2 = string;
        while (string2.startsWith(",")) {
            string2 = string2.substring(1);
        }
        while (string2.endsWith(",")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private void addMoveTo(String string, String string2) {
        boolean bl = true;
        boolean bl2 = true;
        if (string.equals("m")) {
            bl = false;
        }
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        String string3 = " ,-\n\t\r";
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            if (bl2) {
                if (bl) {
                    this.pathSegList.appendItem(new SVGPathSegMovetoAbsImpl(f, f2));
                } else {
                    this.pathSegList.appendItem(new SVGPathSegMovetoRelImpl(f, f2));
                }
                bl2 = false;
                continue;
            }
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegLinetoAbsImpl(f, f2));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegLinetoRelImpl(f, f2));
        }
    }

    private void addLineTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("l")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegLinetoAbsImpl(f, f2));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegLinetoRelImpl(f, f2));
        }
    }

    private void addCurveTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("c")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f3 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f4 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f5 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f6 = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegCurvetoCubicAbsImpl(f5, f6, f, f2, f3, f4));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegCurvetoCubicRelImpl(f5, f6, f, f2, f3, f4));
        }
    }

    private void addSmoothCurveTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("s")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f3 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f4 = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegCurvetoCubicSmoothAbsImpl(f3, f4, f, f2));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegCurvetoCubicSmoothRelImpl(f3, f4, f, f2));
        }
    }

    private void addHorizontalLineTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("h")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegLinetoHorizontalAbsImpl(f));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegLinetoHorizontalRelImpl(f));
        }
    }

    private void addVerticalLineTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("v")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegLinetoVerticalAbsImpl(f));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegLinetoVerticalRelImpl(f));
        }
    }

    private void addEllipticArc(String string, String string2) {
        boolean bl = true;
        if (string.equals("a")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f3 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            int n = Integer.parseInt(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            int n2 = Integer.parseInt(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f4 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f5 = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegArcAbsImpl(f4, f5, f, f2, f3, n == 1, n2 == 1));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegArcRelImpl(f4, f5, f, f2, f3, n == 1, n2 == 1));
        }
    }

    private void addQuadraticBezierCurveTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("q")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f3 = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f4 = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegCurvetoQuadraticAbsImpl(f3, f4, f, f2));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegCurvetoQuadraticRelImpl(f3, f4, f, f2));
        }
    }

    private void addTruetypeQuadraticBezierCurveTo(String string, String string2) {
        boolean bl = true;
        if (string.equals("t")) {
            bl = false;
        }
        String string3 = " ,-\n\t\r";
        string2 = string2.trim();
        string2 = this.trimCommas(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f = Float.parseFloat(string4);
            string4 = this.getNextToken(stringTokenizer, string3, "0");
            float f2 = Float.parseFloat(string4);
            if (bl) {
                this.pathSegList.appendItem(new SVGPathSegCurvetoQuadraticSmoothAbsImpl(f, f2));
                continue;
            }
            this.pathSegList.appendItem(new SVGPathSegCurvetoQuadraticSmoothRelImpl(f, f2));
        }
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("d")) {
            if (this.pathSegList != null) {
                return this.pathSegList.toString();
            }
            return "";
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("d")) {
            if (this.pathSegList != null) {
                attr.setValue(this.pathSegList.toString());
            } else {
                return null;
            }
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        if (string.equalsIgnoreCase("d")) {
            this.constructPathSegList(string2);
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        String string = attr.getName();
        if (string.equalsIgnoreCase("d")) {
            this.constructPathSegList(attr.getValue());
        }
        return super.setAttributeNode(attr);
    }

    GeneralPath createShape(SVGPointList sVGPointList) {
        GeneralPath generalPath = new GeneralPath();
        float f = 0.0f;
        float f2 = 0.0f;
        Point2D.Float float_ = null;
        int n = this.animPathSegList.getNumberOfItems();
        boolean bl = true;
        SVGPoint sVGPoint = null;
        int n2 = 0;
        while (n2 < n) {
            float f3;
            float f4;
            SVGPathSeg sVGPathSeg = this.animPathSegList.getItem(n2);
            if (bl) {
                while (!sVGPathSeg.getPathSegTypeAsLetter().equalsIgnoreCase("m") && n2 < n) {
                    System.out.println("Warning: Path (or subpath) data should always begin with a moveTo  command, ignoring \"" + sVGPathSeg.getPathSegTypeAsLetter() + "\" command");
                    sVGPathSeg = this.animPathSegList.getItem(++n2);
                }
                if (sVGPathSeg.getPathSegTypeAsLetter().equalsIgnoreCase("m")) {
                    if (sVGPathSeg.getPathSegType() == 3) {
                        f4 = ((SVGPathSegMovetoRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegMovetoRel)sVGPathSeg).getY();
                        generalPath.moveTo(f4 + f, f3 + f2);
                        sVGPoint = new SVGPointImpl(f4 + f, f3 + f2);
                        sVGPointList.appendItem(sVGPoint);
                        f += f4;
                        f2 += f3;
                    } else if (sVGPathSeg.getPathSegType() == 2) {
                        f4 = ((SVGPathSegMovetoAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegMovetoAbs)sVGPathSeg).getY();
                        generalPath.moveTo(f4, f3);
                        sVGPoint = new SVGPointImpl(f4, f3);
                        sVGPointList.appendItem(sVGPoint);
                        f = f4;
                        f2 = f3;
                    }
                    bl = false;
                }
            } else {
                switch (sVGPathSeg.getPathSegType()) {
                    case 1: {
                        generalPath.closePath();
                        float_ = null;
                        bl = true;
                        if (sVGPoint == null) break;
                        sVGPointList.appendItem(sVGPoint);
                        f = sVGPoint.getX();
                        f2 = sVGPoint.getY();
                        sVGPoint = null;
                        break;
                    }
                    case 2: {
                        f4 = ((SVGPathSegMovetoAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegMovetoAbs)sVGPathSeg).getY();
                        generalPath.moveTo(f4, f3);
                        f = f4;
                        f2 = f3;
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 3: {
                        f4 = ((SVGPathSegMovetoRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegMovetoRel)sVGPathSeg).getY();
                        generalPath.moveTo(f4 + f, f3 + f2);
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2 += f3));
                        break;
                    }
                    case 4: {
                        f4 = ((SVGPathSegLinetoAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegLinetoAbs)sVGPathSeg).getY();
                        generalPath.lineTo(f4, f3);
                        f = f4;
                        f2 = f3;
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 5: {
                        f4 = ((SVGPathSegLinetoRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegLinetoRel)sVGPathSeg).getY();
                        generalPath.lineTo(f4 + f, f3 + f2);
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2 += f3));
                        break;
                    }
                    case 12: {
                        f4 = ((SVGPathSegLinetoHorizontalAbs)sVGPathSeg).getX();
                        generalPath.lineTo(f4, f2);
                        f = f4;
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 13: {
                        f4 = ((SVGPathSegLinetoHorizontalRel)sVGPathSeg).getX();
                        generalPath.lineTo(f4 + f, f2);
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2));
                        break;
                    }
                    case 14: {
                        f4 = ((SVGPathSegLinetoVerticalAbs)sVGPathSeg).getY();
                        generalPath.lineTo(f, f4);
                        f2 = f4;
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 15: {
                        f4 = ((SVGPathSegLinetoVerticalRel)sVGPathSeg).getY();
                        generalPath.lineTo(f, f4 + f2);
                        float_ = null;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2 += f4));
                        break;
                    }
                    case 6: {
                        f4 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY();
                        float f5 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX1();
                        float f6 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY1();
                        float f7 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX2();
                        float f8 = ((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY2();
                        generalPath.curveTo(f5, f6, f7, f8, f4, f3);
                        float_ = new Point2D.Float(f7, f8);
                        f = f4;
                        f2 = f3;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 7: {
                        f4 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY();
                        float f9 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX1();
                        float f6 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY1();
                        float f7 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX2();
                        float f8 = ((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY2();
                        generalPath.curveTo(f + f9, f2 + f6, f + f7, f2 + f8, f + f4, f2 + f3);
                        float_ = new Point2D.Float(f + f7, f2 + f8);
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2 += f3));
                        break;
                    }
                    case 16: {
                        f4 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getY();
                        float f10 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getX2();
                        float f6 = ((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getY2();
                        if (float_ == null) {
                            float_ = new Point2D.Float(f, f2);
                        }
                        generalPath.curveTo(2.0f * f - (float)((Point2D)float_).getX(), 2.0f * f2 - (float)((Point2D)float_).getY(), f10, f6, f4, f3);
                        float_ = new Point2D.Float(f10, f6);
                        f = f4;
                        f2 = f3;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 17: {
                        f4 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getY();
                        float f11 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getX2();
                        float f6 = ((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getY2();
                        if (float_ == null) {
                            float_ = new Point2D.Float(f, f2);
                        }
                        generalPath.curveTo(2.0f * f - (float)((Point2D)float_).getX(), 2.0f * f2 - (float)((Point2D)float_).getY(), f + f11, f2 + f6, f + f4, f2 + f3);
                        float_ = new Point2D.Float(f + f11, f2 + f6);
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2 += f3));
                        break;
                    }
                    case 8: {
                        f4 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getY();
                        float f12 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getX1();
                        float f6 = ((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getY1();
                        generalPath.quadTo(f12, f6, f4, f3);
                        float_ = new Point2D.Float(f12, f6);
                        f = f4;
                        f2 = f3;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 9: {
                        f4 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getY();
                        float f13 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getX1();
                        float f6 = ((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getY1();
                        generalPath.quadTo(f + f13, f2 + f6, f + f4, f2 + f3);
                        float_ = new Point2D.Float(f + f13, f2 + f6);
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2 += f3));
                        break;
                    }
                    case 18: {
                        f4 = ((SVGPathSegCurvetoQuadraticSmoothAbs)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoQuadraticSmoothAbs)sVGPathSeg).getY();
                        if (float_ == null) {
                            float_ = new Point2D.Float(f, f2);
                        }
                        Point2D.Float float_2 = new Point2D.Float(2.0f * f - (float)((Point2D)float_).getX(), 2.0f * f2 - (float)((Point2D)float_).getY());
                        generalPath.quadTo((float)((Point2D)float_2).getX(), (float)((Point2D)float_2).getY(), f4, f3);
                        float_ = float_2;
                        f = f4;
                        f2 = f3;
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 19: {
                        f4 = ((SVGPathSegCurvetoQuadraticSmoothRel)sVGPathSeg).getX();
                        f3 = ((SVGPathSegCurvetoQuadraticSmoothRel)sVGPathSeg).getY();
                        if (float_ == null) {
                            float_ = new Point2D.Float(f, f2);
                        }
                        Point2D.Float float_3 = new Point2D.Float(2.0f * f - (float)((Point2D)float_).getX(), 2.0f * f2 - (float)((Point2D)float_).getY());
                        generalPath.quadTo((float)((Point2D)float_3).getX(), (float)((Point2D)float_3).getY(), f + f4, f2 + f3);
                        float_ = float_3;
                        sVGPointList.appendItem(new SVGPointImpl(f += f4, f2 += f3));
                        break;
                    }
                    case 10: {
                        Shape shape;
                        f4 = f;
                        f3 = f2;
                        float f14 = ((SVGPathSegArcAbs)sVGPathSeg).getX();
                        float f6 = ((SVGPathSegArcAbs)sVGPathSeg).getY();
                        float f7 = Math.abs(((SVGPathSegArcAbs)sVGPathSeg).getR1());
                        float f8 = Math.abs(((SVGPathSegArcAbs)sVGPathSeg).getR2());
                        float f15 = (float)Math.toRadians(((SVGPathSegArcAbs)sVGPathSeg).getAngle());
                        boolean bl2 = ((SVGPathSegArcAbs)sVGPathSeg).getLargeArcFlag();
                        boolean bl3 = ((SVGPathSegArcAbs)sVGPathSeg).getSweepFlag();
                        if (f7 == 0.0f || f8 == 0.0f) {
                            generalPath.lineTo(f14, f6);
                            f = f14;
                            f2 = f6;
                            float_ = null;
                        } else {
                            shape = this.createArc(f4, f3, f14, f6, f7, f8, f15, bl2, bl3);
                            generalPath.append(shape, true);
                            f = f14;
                            f2 = f6;
                            float_ = null;
                        }
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                    case 11: {
                        Shape shape;
                        f4 = f;
                        f3 = f2;
                        float f16 = f + ((SVGPathSegArcRel)sVGPathSeg).getX();
                        float f6 = f2 + ((SVGPathSegArcRel)sVGPathSeg).getY();
                        float f7 = Math.abs(((SVGPathSegArcRel)sVGPathSeg).getR1());
                        float f8 = Math.abs(((SVGPathSegArcRel)sVGPathSeg).getR2());
                        float f15 = (float)Math.toRadians(((SVGPathSegArcRel)sVGPathSeg).getAngle());
                        boolean bl2 = ((SVGPathSegArcRel)sVGPathSeg).getLargeArcFlag();
                        boolean bl3 = ((SVGPathSegArcRel)sVGPathSeg).getSweepFlag();
                        if (f7 == 0.0f || f8 == 0.0f) {
                            generalPath.lineTo(f16, f6);
                            f = f16;
                            f2 = f6;
                            float_ = null;
                        } else {
                            shape = this.createArc(f4, f3, f16, f6, f7, f8, f15, bl2, bl3);
                            generalPath.append(shape, true);
                            f = f16;
                            f2 = f6;
                            float_ = null;
                        }
                        sVGPointList.appendItem(new SVGPointImpl(f, f2));
                        break;
                    }
                }
            }
            ++n2;
        }
        return generalPath;
    }

    private Shape createArc(float f, float f2, float f3, float f4, float f5, float f6, float f7, boolean bl, boolean bl2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = Math.cos(f7);
        double d10 = d9 * (double)(f - f3) / 2.0 + (d8 = Math.sin(f7)) * (double)(f2 - f4) / 2.0;
        double d11 = d10 * d10;
        double d12 = d11 / (d7 = (double)(f5 * f5)) + (d6 = (d5 = -d8 * (double)(f - f3) / 2.0 + d9 * (double)(f2 - f4) / 2.0) * d5) / (d4 = (double)(f6 * f6));
        if (d12 > 1.0) {
            f5 = (float)Math.sqrt(d12) * f5;
            f6 = (float)Math.sqrt(d12) * f6;
            System.out.println("radii not large enough, increasing to: " + f5 + "," + f6);
            d7 = f5 * f5;
            d4 = f6 * f6;
        }
        if ((d3 = (d7 * d4 - d7 * d6 - d4 * d11) / (d7 * d6 + d4 * d11)) < 0.0) {
            d3 = 0.0;
        }
        d3 = Math.sqrt(d3);
        if (bl == bl2) {
            d3 = -d3;
        }
        double d13 = d3 * (double)f5 * d5 / (double)f6;
        double d14 = d3 * -((double)f6 * d10 / (double)f5);
        double d15 = d9 * d13 - d8 * d14 + (double)((f + f3) / 2.0f);
        double d16 = d8 * d13 + d9 * d14 + (double)((f2 + f4) / 2.0f);
        double d17 = 1.0;
        double d18 = 0.0;
        double d19 = (d10 - d13) / (double)f5;
        double d20 = (d5 - d14) / (double)f6;
        double d21 = Math.acos((d17 * d19 + d18 * d20) / (Math.sqrt(d17 * d17 + d18 * d18) * Math.sqrt(d19 * d19 + d20 * d20)));
        if (d17 * d20 - d18 * d19 < 0.0) {
            d21 = -d21;
        }
        d17 = (d10 - d13) / (double)f5;
        d18 = (d5 - d14) / (double)f6;
        d19 = (-d10 - d13) / (double)f5;
        d20 = (-d5 - d14) / (double)f6;
        double d22 = Math.acos((d17 * d19 + d18 * d20) / (Math.sqrt(d17 * d17 + d18 * d18) * Math.sqrt(d19 * d19 + d20 * d20)));
        if (d17 * d20 - d18 * d19 < 0.0) {
            d22 = -d22;
        }
        if ((d2 = Math.abs((d = Math.toDegrees(d22)) / 360.0)) > 1.0) {
            d = d > 0.0 ? (d -= 360.0 * Math.floor(d2)) : (d += 360.0 * Math.floor(d2));
            d22 = Math.toRadians(d);
        }
        if (bl2 && d22 < 0.0) {
            d22 += Math.toRadians(360.0);
        } else if (!bl2 && d22 > 0.0) {
            d22 -= Math.toRadians(360.0);
        }
        Shape shape = new Arc2D.Double(d15 - (double)f5, d16 - (double)f6, f5 * 2.0f, f6 * 2.0f, -Math.toDegrees(d21), -Math.toDegrees(d22), 0);
        shape = AffineTransform.getRotateInstance(f7, d15, d16).createTransformedShape(shape);
        return shape;
    }
}

