/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.awt.Color;
import java.awt.Paint;
import java.util.Vector;
import org.csiro.svg.dom.SVGAnimatedBooleanImpl;
import org.csiro.svg.dom.SVGAnimatedEnumerationImpl;
import org.csiro.svg.dom.SVGAnimatedStringImpl;
import org.csiro.svg.dom.SVGAnimatedTransformListImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGElementImpl;
import org.csiro.svg.dom.SVGStopElementImpl;
import org.csiro.svg.dom.SVGStylableImpl;
import org.csiro.svg.dom.SVGTransformListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGAnimatedTransformList;
import org.w3c.dom.svg.SVGGradientElement;
import org.w3c.dom.svg.SVGStopElement;

public abstract class SVGGradientElementImpl
extends SVGStylableImpl
implements SVGGradientElement {
    protected SVGAnimatedEnumeration gradientUnits;
    protected SVGAnimatedTransformList gradientTransform;
    protected SVGAnimatedEnumeration spreadMethod;
    protected SVGAnimatedString href;
    protected SVGAnimatedBoolean externalResourcesRequired;
    private static Vector gradientUnitStrings;
    private static Vector gradientUnitValues;
    private static Vector spreadMethodStrings;
    private static Vector spreadMethodValues;

    public SVGGradientElementImpl(SVGDocumentImpl sVGDocumentImpl, String string) {
        super(sVGDocumentImpl, string);
        super.setAttribute("gradientUnits", "userSpaceOnUse");
        super.setAttribute("spreadMethod", "pad");
        super.setAttribute("gradientTransform", "");
        super.setAttribute("href", this.getHref().getBaseVal());
    }

    public SVGGradientElementImpl(SVGDocumentImpl sVGDocumentImpl, Element element, String string) {
        super(sVGDocumentImpl, element, string);
    }

    private void initGradientUnitVectors() {
        if (gradientUnitStrings == null) {
            gradientUnitStrings = new Vector();
            gradientUnitStrings.addElement("userSpaceOnUse");
            gradientUnitStrings.addElement("objectBoundingBox");
        }
        if (gradientUnitValues == null) {
            gradientUnitValues = new Vector();
            gradientUnitValues.addElement(new Short(1));
            gradientUnitValues.addElement(new Short(2));
            gradientUnitValues.addElement(new Short(0));
        }
    }

    private void initSpreadMethodVectors() {
        if (spreadMethodStrings == null) {
            spreadMethodStrings = new Vector();
            spreadMethodStrings.addElement("pad");
            spreadMethodStrings.addElement("reflect");
            spreadMethodStrings.addElement("repeat");
        }
        if (spreadMethodValues == null) {
            spreadMethodValues = new Vector();
            spreadMethodValues.addElement(new Short(1));
            spreadMethodValues.addElement(new Short(2));
            spreadMethodValues.addElement(new Short(3));
            spreadMethodValues.addElement(new Short(0));
        }
    }

    public SVGAnimatedEnumeration getGradientUnits() {
        if (this.gradientUnits == null) {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null) {
                return sVGGradientElementImpl.getGradientUnits();
            }
            if (gradientUnitStrings == null) {
                this.initGradientUnitVectors();
            }
            this.gradientUnits = new SVGAnimatedEnumerationImpl(2, this, gradientUnitStrings, gradientUnitValues);
        }
        return this.gradientUnits;
    }

    public SVGAnimatedTransformList getGradientTransform() {
        if (this.gradientTransform == null) {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null) {
                return sVGGradientElementImpl.getGradientTransform();
            }
            this.gradientTransform = new SVGAnimatedTransformListImpl(new SVGTransformListImpl(), this);
        }
        return this.gradientTransform;
    }

    public SVGAnimatedEnumeration getSpreadMethod() {
        if (this.spreadMethod == null) {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null) {
                return sVGGradientElementImpl.getSpreadMethod();
            }
            if (spreadMethodStrings == null) {
                this.initSpreadMethodVectors();
            }
            this.spreadMethod = new SVGAnimatedEnumerationImpl(1, this, spreadMethodStrings, spreadMethodValues);
        }
        return this.spreadMethod;
    }

    public String getXlinkType() {
        return this.getAttribute("xlink:type");
    }

    public void setXlinkType(String string) throws DOMException {
        this.setAttribute("xlink:type", string);
    }

    public String getXlinkRole() {
        return this.getAttribute("xlink:role");
    }

    public void setXlinkRole(String string) throws DOMException {
        this.setAttribute("xlink:role", string);
    }

    public String getXlinkArcRole() {
        return this.getAttribute("xlink:arcrole");
    }

    public void setXlinkArcRole(String string) throws DOMException {
        this.setAttribute("xlink:arcrole", string);
    }

    public String getXlinkTitle() {
        return this.getAttribute("xlink:title");
    }

    public void setXlinkTitle(String string) throws DOMException {
        this.setAttribute("xlink:title", string);
    }

    public String getXlinkShow() {
        return this.getAttribute("xlink:show");
    }

    public void setXlinkShow(String string) throws DOMException {
        this.setAttribute("xlink:show", string);
    }

    public String getXlinkActuate() {
        return this.getAttribute("xlink:actuate");
    }

    public void setXlinkActuate(String string) throws DOMException {
        this.setAttribute("xlink:actuate", string);
    }

    public SVGAnimatedString getHref() {
        if (this.href == null) {
            this.href = new SVGAnimatedStringImpl("", this);
        }
        return this.href;
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        if (this.externalResourcesRequired == null) {
            this.externalResourcesRequired = new SVGAnimatedBooleanImpl(false, this);
        }
        return this.externalResourcesRequired;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("gradientUnits")) {
            if (this.getGradientUnits().getBaseVal() == 2) {
                return "objectBoundingBox";
            }
            return "userSpaceOnUse";
        }
        if (string.equalsIgnoreCase("gradientTransform")) {
            return this.getGradientTransform().getBaseVal().toString();
        }
        if (string.equalsIgnoreCase("spreadMethod")) {
            if (this.getSpreadMethod().getBaseVal() == 2) {
                return "reflect";
            }
            if (this.getSpreadMethod().getBaseVal() == 3) {
                return "repeat";
            }
            return "pad";
        }
        if (string.equalsIgnoreCase("xlink:href")) {
            return this.getHref().getBaseVal();
        }
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                return "true";
            }
            return "false";
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("gradientUnits")) {
            if (this.getGradientUnits().getBaseVal() == 2) {
                attr.setValue("objectBoundingBox");
            } else {
                attr.setValue("userSpaceOnUse");
            }
        } else if (string.equalsIgnoreCase("spreadMethod")) {
            if (this.getSpreadMethod().getBaseVal() == 2) {
                attr.setValue("reflect");
            } else if (this.getSpreadMethod().getBaseVal() == 3) {
                attr.setValue("repeat");
            } else {
                attr.setValue("pad");
            }
        } else if (string.equalsIgnoreCase("gradientTransform")) {
            attr.setValue(this.getGradientTransform().getBaseVal().toString());
        } else if (string.equalsIgnoreCase("xlink:href")) {
            attr.setValue(this.getHref().getBaseVal());
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                attr.setValue("true");
            } else {
                attr.setValue("false");
            }
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        this.setAttributeValue(string, string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.setAttributeValue(attr.getName(), attr.getValue());
        return super.setAttributeNode(attr);
    }

    private void setAttributeValue(String string, String string2) {
        if (string.equalsIgnoreCase("gradientUnits")) {
            if (string2.equalsIgnoreCase("userSpaceOnUse")) {
                this.getGradientUnits().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("objectBoundingBox")) {
                this.getGradientUnits().setBaseVal((short)2);
            } else {
                System.out.println("invalid value '" + string2 + "' for gradientUnits attribute, setting to default 'objectBoundingBox'");
                this.getGradientUnits().setBaseVal((short)2);
            }
        } else if (string.equalsIgnoreCase("spreadMethod")) {
            if (string2.equalsIgnoreCase("pad")) {
                this.getSpreadMethod().setBaseVal((short)1);
            } else if (string2.equalsIgnoreCase("reflect")) {
                this.getSpreadMethod().setBaseVal((short)2);
            } else if (string2.equalsIgnoreCase("repeat")) {
                this.getSpreadMethod().setBaseVal((short)3);
            } else {
                System.out.println("bad spreadMethod attribute '" + string2 + "', setting to default value 'pad'");
                this.getSpreadMethod().setBaseVal((short)1);
            }
        } else if (string.equalsIgnoreCase("gradientTransform")) {
            ((SVGAnimatedTransformListImpl)this.getGradientTransform()).setBaseVal(SVGTransformListImpl.createTransformList(string2));
        } else if (string.equalsIgnoreCase("xlink:href")) {
            this.getHref().setBaseVal(string2);
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (string2.equalsIgnoreCase("true")) {
                this.getExternalResourcesRequired().setBaseVal(true);
            } else {
                this.getExternalResourcesRequired().setBaseVal(false);
            }
        }
    }

    public abstract Paint getPaint(SVGElementImpl var1, float var2);

    protected Color getColorAtOffset(double d) {
        double d2 = this.getStop(0).getOffset().getAnimVal();
        double d3 = this.getStop(this.numStops() - 1).getOffset().getAnimVal();
        double d4 = d2 + d * (d3 - d2);
        SVGStopElementImpl sVGStopElementImpl = this.getStop(0);
        SVGStopElementImpl sVGStopElementImpl2 = this.getStop(1);
        if (sVGStopElementImpl != null && sVGStopElementImpl2 == null) {
            return sVGStopElementImpl.getColor();
        }
        double d5 = sVGStopElementImpl.getOffset().getAnimVal();
        double d6 = sVGStopElementImpl2.getOffset().getAnimVal();
        int n = 2;
        while (d4 > d6) {
            sVGStopElementImpl = sVGStopElementImpl2;
            d5 = d6;
            sVGStopElementImpl2 = this.getStop(n);
            if (sVGStopElementImpl2 == null) {
                sVGStopElementImpl2 = sVGStopElementImpl;
                break;
            }
            d6 = sVGStopElementImpl2.getOffset().getAnimVal();
            ++n;
        }
        Color color = sVGStopElementImpl.getColor();
        Color color2 = sVGStopElementImpl2.getColor();
        int n2 = color2.getRed() - color.getRed();
        int n3 = color2.getGreen() - color.getGreen();
        int n4 = color2.getBlue() - color.getBlue();
        int n5 = color2.getAlpha() - color.getAlpha();
        double d7 = (d4 - d5) / (d6 - d5);
        int n6 = color.getRed() + (int)(d7 * (double)n2);
        int n7 = color.getGreen() + (int)(d7 * (double)n3);
        int n8 = color.getBlue() + (int)(d7 * (double)n4);
        int n9 = color.getAlpha() + (int)(d7 * (double)n5);
        return new Color(n6, n7, n8, n9);
    }

    protected int numChildrenStops() {
        int n = 0;
        if (this.hasChildNodes()) {
            NodeList nodeList = this.getChildNodes();
            int n2 = nodeList.getLength();
            int n3 = 0;
            while (n3 < n2) {
                Node node = nodeList.item(n3);
                if (node instanceof SVGStopElement) {
                    ++n;
                }
                ++n3;
            }
        }
        return n;
    }

    public int numStops() {
        int n = this.numChildrenStops();
        if (n > 0) {
            return n;
        }
        SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
        if (sVGGradientElementImpl != null) {
            return sVGGradientElementImpl.numStops();
        }
        return 0;
    }

    public SVGStopElementImpl getStop(int n) {
        if (this.numChildrenStops() > 0) {
            int n2 = 0;
            if (this.hasChildNodes()) {
                NodeList nodeList = this.getChildNodes();
                int n3 = nodeList.getLength();
                int n4 = 0;
                while (n4 < n3) {
                    Node node = nodeList.item(n4);
                    if (node instanceof SVGStopElementImpl) {
                        if (n2 == n) {
                            return (SVGStopElementImpl)node;
                        }
                        ++n2;
                    }
                    ++n4;
                }
            }
        } else {
            SVGGradientElementImpl sVGGradientElementImpl = this.getReferencedGradient();
            if (sVGGradientElementImpl != null) {
                return sVGGradientElementImpl.getStop(n);
            }
        }
        return null;
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("gradientUnits")) {
            ((SVGAnimatedValue)((Object)this.getGradientUnits())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("spreadMethod")) {
            ((SVGAnimatedValue)((Object)this.getSpreadMethod())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("gradientTransform")) {
            ((SVGAnimatedValue)((Object)this.getGradientTransform())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("xlink:href")) {
            ((SVGAnimatedValue)((Object)this.getHref())).addAnimation(sVGAnimationElementImpl);
        } else if (string.equals("externalResourcesRequired")) {
            ((SVGAnimatedValue)((Object)this.getExternalResourcesRequired())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }

    protected SVGGradientElementImpl getReferencedGradient() {
        String string = this.getHref().getAnimVal();
        if (string.length() > 0 && string.indexOf(35) != -1) {
            int n = string.indexOf(35);
            String string2 = string.substring(n + 1, string.length());
            Element element = this.getOwnerDoc().getElementById(string2);
            if (element != null && element instanceof SVGGradientElementImpl) {
                return (SVGGradientElementImpl)element;
            }
        }
        return null;
    }
}

