/*
 * Decompiled with CFR 0.152.
 */
package org.csiro.svg.dom;

import java.util.Hashtable;
import java.util.Vector;
import org.csiro.svg.dom.SVGAnimatedBooleanImpl;
import org.csiro.svg.dom.SVGAnimatedValue;
import org.csiro.svg.dom.SVGAnimationElementImpl;
import org.csiro.svg.dom.SVGDocumentImpl;
import org.csiro.svg.dom.SVGStringListImpl;
import org.csiro.svg.dom.SVGTransformableImpl;
import org.csiro.svg.dom.events.ScriptEventListener;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGExternalResourcesRequired;
import org.w3c.dom.svg.SVGLangSpace;
import org.w3c.dom.svg.SVGStringList;
import org.w3c.dom.svg.SVGTests;

public abstract class SVGGraphic
extends SVGTransformableImpl
implements SVGLangSpace,
SVGTests,
EventTarget,
SVGExternalResourcesRequired {
    protected SVGAnimatedBoolean externalResourcesRequired;
    protected SVGStringListImpl requiredFeatures;
    protected SVGStringListImpl requiredExtensions;
    protected SVGStringListImpl systemLanguage;
    Hashtable eventListeners;

    public SVGGraphic(SVGDocumentImpl sVGDocumentImpl, Element element, String string) {
        super(sVGDocumentImpl, element, string);
    }

    public SVGGraphic(SVGDocumentImpl sVGDocumentImpl, String string) {
        super(sVGDocumentImpl, string);
    }

    public String getXMLlang() {
        return this.getAttribute("xml:lang");
    }

    public void setXMLlang(String string) {
        if (string != null) {
            this.setAttribute("xml:lang", string);
        } else {
            this.removeAttribute("xml:lang");
        }
    }

    public String getXMLspace() {
        return this.getAttribute("xml:space");
    }

    public void setXMLspace(String string) {
        if (string != null) {
            this.setAttribute("xml:space", string);
        } else {
            this.removeAttribute("xml:space");
        }
    }

    public SVGStringList getRequiredFeatures() {
        return this.requiredFeatures;
    }

    public SVGStringList getRequiredExtensions() {
        return this.requiredExtensions;
    }

    public SVGStringList getSystemLanguage() {
        return this.systemLanguage;
    }

    public boolean hasExtension(String string) {
        return string.equalsIgnoreCase("svg");
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        if (this.eventListeners == null) {
            this.eventListeners = new Hashtable();
        }
        Vector vector = this.eventListeners.containsKey(string) ? (Vector)this.eventListeners.get(string) : new Vector();
        vector.add(eventListener);
        this.eventListeners.put(string, vector);
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        Vector vector;
        if (this.eventListeners == null) {
            return;
        }
        if (this.eventListeners.containsKey(string) && (vector = (Vector)this.eventListeners.get(string)).contains(eventListener)) {
            vector.remove(eventListener);
            if (vector.isEmpty()) {
                this.eventListeners.remove(string);
            } else {
                this.eventListeners.put(string, vector);
            }
        }
    }

    public boolean dispatchEvent(Event event) throws EventException {
        if (this.eventListeners == null) {
            return true;
        }
        if (!this.eventListeners.containsKey(event.getType())) {
            return true;
        }
        Vector vector = (Vector)this.eventListeners.get(event.getType());
        int n = 0;
        while (n < vector.size()) {
            EventListener eventListener = (EventListener)vector.elementAt(n);
            eventListener.handleEvent(event);
            ++n;
        }
        return true;
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        if (this.externalResourcesRequired == null) {
            this.externalResourcesRequired = new SVGAnimatedBooleanImpl(false, this);
        }
        return this.externalResourcesRequired;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                return "true";
            }
            return "false";
        }
        return super.getAttribute(string);
    }

    public Attr getAttributeNode(String string) {
        Attr attr = super.getAttributeNode(string);
        if (attr == null) {
            return attr;
        }
        if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (this.getExternalResourcesRequired().getBaseVal()) {
                attr.setValue("true");
            } else {
                attr.setValue("false");
            }
        }
        return attr;
    }

    public void setAttribute(String string, String string2) {
        super.setAttribute(string, string2);
        if (string.equalsIgnoreCase("onfocusin") || string.equalsIgnoreCase("onfocusout") || string.equalsIgnoreCase("onactivate") || string.equalsIgnoreCase("onclick") || string.equalsIgnoreCase("onmousedown") || string.equalsIgnoreCase("onmouseup") || string.equalsIgnoreCase("onmouseover") || string.equalsIgnoreCase("onmousemove") || string.equalsIgnoreCase("onmouseout") || string.equalsIgnoreCase("onload")) {
            ScriptEventListener scriptEventListener = new ScriptEventListener(this.getOwnerDoc(), string2);
            this.addEventListener(string, scriptEventListener, true);
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (string2.equalsIgnoreCase("true")) {
                this.getExternalResourcesRequired().setBaseVal(true);
            } else {
                this.getExternalResourcesRequired().setBaseVal(false);
            }
        } else if (string.equalsIgnoreCase("requiredFeatures")) {
            this.requiredFeatures = new SVGStringListImpl(string2);
        } else if (string.equalsIgnoreCase("requiredExtensions")) {
            this.requiredExtensions = new SVGStringListImpl(string2);
        } else if (string.equalsIgnoreCase("systemLanguage")) {
            this.systemLanguage = new SVGStringListImpl(string2);
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        String string = attr.getName();
        String string2 = attr.getValue();
        if (string.equalsIgnoreCase("onfocusin") || string.equalsIgnoreCase("onfocusout") || string.equalsIgnoreCase("onactivate") || string.equalsIgnoreCase("onclick") || string.equalsIgnoreCase("onmousedown") || string.equalsIgnoreCase("onmouseup") || string.equalsIgnoreCase("onmouseover") || string.equalsIgnoreCase("onmousemove") || string.equalsIgnoreCase("onmouseout") || string.equalsIgnoreCase("onload")) {
            ScriptEventListener scriptEventListener = new ScriptEventListener(this.getOwnerDoc(), string2);
            this.addEventListener(string, scriptEventListener, true);
        } else if (string.equalsIgnoreCase("externalResourcesRequired")) {
            if (string2.equalsIgnoreCase("true")) {
                this.getExternalResourcesRequired().setBaseVal(true);
            } else {
                this.getExternalResourcesRequired().setBaseVal(false);
            }
        } else if (string.equalsIgnoreCase("requiredFeatures")) {
            this.requiredFeatures = new SVGStringListImpl(string2);
        } else if (string.equalsIgnoreCase("reqiredExtensions")) {
            this.requiredExtensions = new SVGStringListImpl(string2);
        } else if (string.equalsIgnoreCase("systemLanguage")) {
            this.systemLanguage = new SVGStringListImpl(string2);
        }
        return super.setAttributeNode(attr);
    }

    public void attachAnimation(SVGAnimationElementImpl sVGAnimationElementImpl) {
        String string = sVGAnimationElementImpl.getAttributeName();
        if (string.equals("externalResourcesRequired")) {
            ((SVGAnimatedValue)((Object)this.getExternalResourcesRequired())).addAnimation(sVGAnimationElementImpl);
        } else {
            super.attachAnimation(sVGAnimationElementImpl);
        }
    }
}

